/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.resource;

import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.app.resource.OperatorResourcesComputer;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;

public class PlanStage {
    private final Set<ILogicalOperator> operators = new HashSet<ILogicalOperator>();
    private final int stageId;

    PlanStage(int stageId) {
        this.stageId = stageId;
    }

    public String toString() {
        return "Stage{stageId=" + this.stageId + ", operators(" + this.operators.size() + ")=" + this.operators + "}";
    }

    public Set<ILogicalOperator> getOperators() {
        return this.operators;
    }

    public long getRequiredMemory(OperatorResourcesComputer resourcesComputer) {
        return this.operators.stream().mapToLong(resourcesComputer::getOperatorRequiredMemory).sum();
    }

    public int getRequiredCores(OperatorResourcesComputer resourcesComputer) {
        return this.operators.stream().mapToInt(resourcesComputer::getOperatorRequiredCores).max().orElse(1);
    }
}

