/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.util.concurrent.TimeUnit;
import org.apache.asterix.app.function.JobSummariesReader;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.app.message.GetJobSummariesRequest;
import org.apache.asterix.app.message.GetJobSummariesResponse;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.metadata.declared.AbstractDatasourceFunction;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobSummariesFunction
extends AbstractDatasourceFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;

    public JobSummariesFunction(AlgebricksAbsolutePartitionConstraint locations) {
        super(locations);
    }

    public IRecordReader<char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        INCServiceContext serviceCtx = ctx.getJobletContext().getServiceContext();
        INCMessageBroker messageBroker = (INCMessageBroker)serviceCtx.getMessageBroker();
        MessageFuture messageFuture = messageBroker.registerMessageFuture();
        long futureId = messageFuture.getFutureId();
        GetJobSummariesRequest request = new GetJobSummariesRequest(serviceCtx.getNodeId(), futureId);
        try {
            messageBroker.sendMessageToPrimaryCC((ICcAddressedMessage)request);
            GetJobSummariesResponse response = (GetJobSummariesResponse)messageFuture.get(ExecuteStatementRequestMessage.DEFAULT_NC_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            JobSummariesReader jobSummariesReader = new JobSummariesReader(response.getSummaries());
            return jobSummariesReader;
        }
        catch (Exception e) {
            LOGGER.warn("Could no retrieve jobs info", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            messageBroker.deregisterMessageFuture(futureId);
        }
    }
}

