/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public final class EliminateIsomorphicSubplanRule
implements IAlgebraicRewriteRule {
    private List<AggregateOperator> targetSubplan1Roots;
    private List<AggregateOperator> targetSubplan2Roots;
    private List<Map<LogicalVariable, LogicalVariable>> targetVarMaps;
    private Map<LogicalVariable, LogicalVariable> tmpVarMap;
    private Mutable<AggregateOperator> tmpAggOpRef;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (((ILogicalOperator)opRef.getValue()).getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        boolean applied = false;
        while (true) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
            Pair<Boolean, Mutable<ILogicalOperator>> p = this.mergeSubplanIntoChildSubplan(opRef, context);
            if (p == null) break;
            applied |= ((Boolean)p.first).booleanValue();
            opRef = (Mutable)p.second;
        }
        return applied;
    }

    private Pair<Boolean, Mutable<ILogicalOperator>> mergeSubplanIntoChildSubplan(Mutable<ILogicalOperator> op1Ref, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)op1Ref.getValue();
        SubplanOperator subplan1 = (SubplanOperator)op1;
        Mutable op2Ref = (Mutable)subplan1.getInputs().get(0);
        ILogicalOperator op2 = (ILogicalOperator)op2Ref.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return null;
        }
        SubplanOperator subplan2 = (SubplanOperator)op2;
        this.reset();
        Iterator nestedPlanIter = subplan1.getNestedPlans().iterator();
        while (nestedPlanIter.hasNext()) {
            ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlanIter.next();
            Iterator rootOpIter = nestedPlan.getRoots().iterator();
            while (rootOpIter.hasNext()) {
                ILogicalOperator rootOp = (ILogicalOperator)((Mutable)rootOpIter.next()).getValue();
                if (!EliminateIsomorphicSubplanRule.findIsomorphicPlanSegment(rootOp, subplan2, this.tmpAggOpRef, this.tmpVarMap)) continue;
                this.targetSubplan1Roots.add((AggregateOperator)rootOp);
                this.targetSubplan2Roots.add(Objects.requireNonNull((AggregateOperator)this.tmpAggOpRef.getValue()));
                this.targetVarMaps.add(new HashMap<LogicalVariable, LogicalVariable>(this.tmpVarMap));
                rootOpIter.remove();
            }
            if (!nestedPlan.getRoots().isEmpty()) continue;
            nestedPlanIter.remove();
        }
        if (this.targetSubplan1Roots.isEmpty()) {
            return new Pair((Object)false, (Object)op2Ref);
        }
        int n = this.targetSubplan1Roots.size();
        for (int i = 0; i < n; ++i) {
            AggregateOperator targetSubplan1Root = this.targetSubplan1Roots.get(i);
            AggregateOperator targetSubplan2Root = this.targetSubplan2Roots.get(i);
            Map<LogicalVariable, LogicalVariable> targetVarMap = this.targetVarMaps.get(i);
            EliminateIsomorphicSubplanRule.consolidateSubplans(targetSubplan1Root, targetSubplan2Root, targetVarMap, context);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)subplan2);
        if (subplan1.getNestedPlans().isEmpty()) {
            op1Ref.setValue((Object)subplan2);
            return new Pair((Object)true, op1Ref);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)subplan1);
        return new Pair((Object)true, (Object)op2Ref);
    }

    private static boolean findIsomorphicPlanSegment(ILogicalOperator op, SubplanOperator subplanOp, Mutable<AggregateOperator> outSubplanRootOpRef, Map<LogicalVariable, LogicalVariable> outVarMap) throws AlgebricksException {
        if (op.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggOp = (AggregateOperator)op;
        if (aggOp.getMergeExpressions() != null) {
            return false;
        }
        ListSet freeVars = new ListSet();
        OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)aggOp, (Set)freeVars);
        ILogicalOperator opChildIsomorphicCandidate = (ILogicalOperator)((Mutable)aggOp.getInputs().get(0)).getValue();
        while (opChildIsomorphicCandidate.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            if (!OperatorPropertiesUtil.isMovable((ILogicalOperator)opChildIsomorphicCandidate)) {
                return false;
            }
            opChildIsomorphicCandidate = (ILogicalOperator)((Mutable)opChildIsomorphicCandidate.getInputs().get(0)).getValue();
        }
        for (ILogicalPlan nestedPlan : subplanOp.getNestedPlans()) {
            for (Mutable rootOpRef : nestedPlan.getRoots()) {
                AggregateOperator aggRootOp;
                ILogicalOperator rootOp = (ILogicalOperator)rootOpRef.getValue();
                if (rootOp.getOperatorTag() != LogicalOperatorTag.AGGREGATE || (aggRootOp = (AggregateOperator)rootOp).getMergeExpressions() != null || !OperatorPropertiesUtil.disjoint((Collection)freeVars, (Collection)aggRootOp.getVariables())) continue;
                ILogicalOperator rootOpChildIsomorphicCandidate = (ILogicalOperator)((Mutable)aggRootOp.getInputs().get(0)).getValue();
                while (rootOpChildIsomorphicCandidate.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    rootOpChildIsomorphicCandidate = (ILogicalOperator)((Mutable)rootOpChildIsomorphicCandidate.getInputs().get(0)).getValue();
                }
                if (!IsomorphismUtilities.isOperatorIsomorphicPlanSegment((ILogicalOperator)opChildIsomorphicCandidate, (ILogicalOperator)rootOpChildIsomorphicCandidate)) continue;
                outSubplanRootOpRef.setValue((Object)aggRootOp);
                IsomorphismUtilities.mapVariablesTopDown((ILogicalOperator)rootOpChildIsomorphicCandidate, (ILogicalOperator)opChildIsomorphicCandidate, outVarMap, (boolean)false);
                return true;
            }
        }
        return false;
    }

    private static void consolidateSubplans(AggregateOperator upperAggRootOp, AggregateOperator targetAggRootOp, Map<LogicalVariable, LogicalVariable> varMap, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator upperChildOp = (ILogicalOperator)((Mutable)upperAggRootOp.getInputs().get(0)).getValue();
        if (upperChildOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator upperAssignOp;
            ArrayDeque<AssignOperator> upperAssignQueue = new ArrayDeque<AssignOperator>();
            do {
                upperAssignQueue.push((AssignOperator)upperChildOp);
            } while ((upperChildOp = (ILogicalOperator)((Mutable)upperChildOp.getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN);
            ILogicalOperator targetChildOp = (ILogicalOperator)((Mutable)targetAggRootOp.getInputs().get(0)).getValue();
            while ((upperAssignOp = (AssignOperator)upperAssignQueue.poll()) != null) {
                AssignOperator upperAssignOpCopy = (AssignOperator)OperatorManipulationUtil.deepCopy((ILogicalOperator)upperAssignOp);
                upperAssignOpCopy.getInputs().clear();
                VariableUtilities.substituteVariables((ILogicalOperator)upperAssignOpCopy, varMap, null);
                upperAssignOpCopy.getInputs().add(new MutableObject((Object)targetChildOp));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)upperAssignOpCopy);
                targetChildOp = upperAssignOpCopy;
            }
            targetAggRootOp.getInputs().clear();
            targetAggRootOp.getInputs().add(new MutableObject((Object)targetChildOp));
        }
        AggregateOperator upperAggRootOpCopy = (AggregateOperator)OperatorManipulationUtil.deepCopy((ILogicalOperator)upperAggRootOp);
        upperAggRootOpCopy.getInputs().clear();
        VariableUtilities.substituteVariables((ILogicalOperator)upperAggRootOpCopy, varMap, null);
        targetAggRootOp.getVariables().addAll(upperAggRootOpCopy.getVariables());
        targetAggRootOp.getExpressions().addAll(upperAggRootOpCopy.getExpressions());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)targetAggRootOp);
    }

    private void reset() {
        if (this.targetSubplan1Roots == null) {
            this.targetSubplan1Roots = new ArrayList<AggregateOperator>();
        } else {
            this.targetSubplan1Roots.clear();
        }
        if (this.targetSubplan2Roots == null) {
            this.targetSubplan2Roots = new ArrayList<AggregateOperator>();
        } else {
            this.targetSubplan2Roots.clear();
        }
        if (this.targetVarMaps == null) {
            this.targetVarMaps = new ArrayList<Map<LogicalVariable, LogicalVariable>>();
        } else {
            this.targetVarMaps.clear();
        }
        if (this.tmpVarMap == null) {
            this.tmpVarMap = new HashMap<LogicalVariable, LogicalVariable>();
        } else {
            this.tmpVarMap.clear();
        }
        if (this.tmpAggOpRef == null) {
            this.tmpAggOpRef = new MutableObject();
        } else {
            this.tmpAggOpRef.setValue(null);
        }
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

