/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractIntroduceCombinerRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractIntroduceGroupByCombinerRule
extends AbstractIntroduceCombinerRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator gbyOp = (GroupByOperator)op;
        AbstractLogicalOperator.ExecutionMode executionMode = gbyOp.getExecutionMode();
        if (!(executionMode == AbstractLogicalOperator.ExecutionMode.PARTITIONED || executionMode == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED && gbyOp.isGroupAll())) {
            return false;
        }
        AbstractIntroduceCombinerRule.BookkeepingInfo bi = new AbstractIntroduceCombinerRule.BookkeepingInfo(this);
        GroupByOperator newGbyOp = this.opToPush(gbyOp, bi, context);
        if (newGbyOp == null) {
            return false;
        }
        ListSet newGbyLiveVars = new ListSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)newGbyOp, (Collection)newGbyLiveVars);
        for (Pair p : gbyOp.getDecorList()) {
            ArrayList usedDecorVars = new ArrayList();
            ((ILogicalExpression)((Mutable)p.second).getValue()).getUsedVariables(usedDecorVars);
            LogicalVariable usedVar = (LogicalVariable)usedDecorVars.get(0);
            if (newGbyLiveVars.contains(usedVar)) continue;
            newGbyOp.addDecorExpression(null, ((ILogicalExpression)((Mutable)p.second).getValue()).cloneExpression());
            newGbyLiveVars.add(usedVar);
        }
        newGbyOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.LOCAL);
        Object v = gbyOp.getAnnotations().get("USE_HASH_GROUP_BY");
        newGbyOp.getAnnotations().put("USE_HASH_GROUP_BY", v);
        Object v2 = gbyOp.getAnnotations().get("USE_EXTERNAL_GROUP_BY");
        newGbyOp.getAnnotations().put("USE_EXTERNAL_GROUP_BY", v2);
        HashSet freeVars = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)gbyOp, freeVars);
        for (LogicalVariable var : freeVars) {
            if (newGbyLiveVars.contains(var)) continue;
            LogicalVariable newDecorVar = context.newVar();
            VariableReferenceExpression varRef = new VariableReferenceExpression(var);
            varRef.setSourceLocation(gbyOp.getSourceLocation());
            newGbyOp.addDecorExpression(newDecorVar, (ILogicalExpression)varRef);
            VariableUtilities.substituteVariables((ILogicalOperator)((ILogicalOperator)((Mutable)((ILogicalPlan)gbyOp.getNestedPlans().get(0)).getRoots().get(0)).getValue()), (LogicalVariable)var, (LogicalVariable)newDecorVar, (ITypingContext)context);
        }
        Mutable opRef3 = (Mutable)gbyOp.getInputs().get(0);
        opRef3.setValue((Object)newGbyOp);
        this.typeGby((AbstractOperatorWithNestedPlans)newGbyOp, context);
        this.typeGby((AbstractOperatorWithNestedPlans)gbyOp, context);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        return true;
    }

    private void typeGby(AbstractOperatorWithNestedPlans op, IOptimizationContext context) throws AlgebricksException {
        for (ILogicalPlan p : op.getNestedPlans()) {
            OperatorPropertiesUtil.typePlan((ILogicalPlan)p, (IOptimizationContext)context);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
    }

    /*
     * WARNING - void declaration
     */
    private GroupByOperator opToPush(GroupByOperator gbyOp, AbstractIntroduceCombinerRule.BookkeepingInfo bi, IOptimizationContext context) throws AlgebricksException {
        void var15_22;
        SourceLocation sourceLoc = gbyOp.getSourceLocation();
        Mutable opRef3 = (Mutable)gbyOp.getInputs().get(0);
        ILogicalOperator op3 = (ILogicalOperator)opRef3.getValue();
        GroupByOperator newGbyOp = new GroupByOperator();
        newGbyOp.setSourceLocation(sourceLoc);
        newGbyOp.getInputs().add(new MutableObject((Object)op3));
        Map annotations = newGbyOp.getAnnotations();
        annotations.putAll(gbyOp.getAnnotations());
        List gbyVars = gbyOp.getGroupByVarList();
        List gbyNestedPlans = gbyOp.getNestedPlans();
        ArrayList backupNestedPlans = new ArrayList(gbyNestedPlans);
        int n = gbyNestedPlans.size();
        for (int i = 0; i < n; ++i) {
            ILogicalPlan nestedPlan = (ILogicalPlan)gbyNestedPlans.get(i);
            ILogicalPlan iLogicalPlan = OperatorManipulationUtil.deepCopy((ILogicalPlan)nestedPlan, (ILogicalOperator)gbyOp);
            OperatorManipulationUtil.computeTypeEnvironment((ILogicalPlan)iLogicalPlan, (ITypingContext)context);
            gbyNestedPlans.set(i, iLogicalPlan);
            Pair<Boolean, ILogicalPlan> bip = this.tryToPushSubplan(iLogicalPlan, gbyOp, newGbyOp, bi, gbyVars, context);
            if (!((Boolean)bip.first).booleanValue()) {
                gbyNestedPlans.clear();
                gbyNestedPlans.addAll(backupNestedPlans);
                return null;
            }
            ILogicalPlan pushedSubplan = (ILogicalPlan)bip.second;
            if (pushedSubplan == null) continue;
            newGbyOp.getNestedPlans().add(pushedSubplan);
        }
        if (bi.modifyGbyMap.isEmpty()) {
            gbyNestedPlans.clear();
            gbyNestedPlans.addAll(backupNestedPlans);
            return null;
        }
        ArrayList<LogicalVariable> newOpGbyList = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> replGbyList = new ArrayList<LogicalVariable>();
        for (Map.Entry entry : bi.modifyGbyMap.entrySet()) {
            List varList = (List)entry.getValue();
            boolean see1 = true;
            int sz1 = newOpGbyList.size();
            int i = 0;
            for (LogicalVariable v : varList) {
                if (see1) {
                    if (i < sz1) {
                        LogicalVariable v2 = (LogicalVariable)newOpGbyList.get(i);
                        if (v != v2) {
                            gbyNestedPlans.clear();
                            gbyNestedPlans.addAll(backupNestedPlans);
                            return null;
                        }
                    } else {
                        see1 = false;
                        newOpGbyList.add(v);
                        replGbyList.add(context.newVar());
                    }
                    ++i;
                    continue;
                }
                newOpGbyList.add(v);
                replGbyList.add(context.newVar());
            }
        }
        int n2 = newOpGbyList.size();
        boolean bl = false;
        while (var15_22 < n2) {
            VariableReferenceExpression varRef = new VariableReferenceExpression((LogicalVariable)newOpGbyList.get((int)var15_22));
            varRef.setSourceLocation(sourceLoc);
            newGbyOp.addGbyExpression((LogicalVariable)replGbyList.get((int)var15_22), (ILogicalExpression)varRef);
            VariableUtilities.substituteVariables((ILogicalOperator)gbyOp, (LogicalVariable)((LogicalVariable)newOpGbyList.get((int)var15_22)), (LogicalVariable)((LogicalVariable)replGbyList.get((int)var15_22)), (boolean)false, (ITypingContext)context);
            ++var15_22;
        }
        newGbyOp.setGlobal(false);
        newGbyOp.setGroupAll(gbyOp.isGroupAll());
        return newGbyOp;
    }

    private Pair<Boolean, ILogicalPlan> tryToPushSubplan(ILogicalPlan nestedPlan, GroupByOperator oldGbyOp, GroupByOperator newGbyOp, AbstractIntroduceCombinerRule.BookkeepingInfo bi, List<LogicalVariable> gbyVars, IOptimizationContext context) throws AlgebricksException {
        ArrayList<Mutable<ILogicalOperator>> pushedRoots = new ArrayList<Mutable<ILogicalOperator>>();
        HashSet<AbstractIntroduceCombinerRule.SimilarAggregatesInfo> toReplaceSet = new HashSet<AbstractIntroduceCombinerRule.SimilarAggregatesInfo>();
        for (Mutable r : nestedPlan.getRoots()) {
            if (this.tryToPushRoot((Mutable<ILogicalOperator>)r, oldGbyOp, newGbyOp, bi, gbyVars, context, pushedRoots, toReplaceSet)) continue;
            return new Pair((Object)false, null);
        }
        if (pushedRoots.isEmpty()) {
            return new Pair((Object)true, null);
        }
        ALogicalPlanImpl newPlan = new ALogicalPlanImpl(pushedRoots);
        ILogicalPlan plan = this.fingIdenticalPlan(newGbyOp, (ILogicalPlan)newPlan);
        this.replaceOriginalAggFuncs(toReplaceSet);
        if (plan == null) {
            return new Pair((Object)true, (Object)newPlan);
        }
        ListSet originalVars = new ListSet();
        ListSet newVars = new ListSet();
        for (Mutable mutable : pushedRoots) {
            VariableUtilities.getProducedVariables((ILogicalOperator)((ILogicalOperator)mutable.getValue()), (Collection)originalVars);
        }
        for (Mutable mutable : plan.getRoots()) {
            VariableUtilities.getProducedVariables((ILogicalOperator)((ILogicalOperator)mutable.getValue()), (Collection)newVars);
        }
        Iterator originalVarIter = originalVars.iterator();
        Iterator iterator = newVars.iterator();
        while (originalVarIter.hasNext()) {
            LogicalVariable originalVar = (LogicalVariable)originalVarIter.next();
            LogicalVariable newVar = (LogicalVariable)iterator.next();
            for (AbstractIntroduceCombinerRule.SimilarAggregatesInfo sai : toReplaceSet) {
                for (AbstractIntroduceCombinerRule.AggregateExprInfo aei : sai.simAggs) {
                    ILogicalExpression afce = (ILogicalExpression)aei.aggExprRef.getValue();
                    afce.substituteVar(originalVar, newVar);
                }
            }
        }
        return new Pair((Object)true, null);
    }

    private ILogicalPlan fingIdenticalPlan(GroupByOperator newGbyOp, ILogicalPlan plan) throws AlgebricksException {
        for (ILogicalPlan nestedPlan : newGbyOp.getNestedPlans()) {
            if (!IsomorphismUtilities.isOperatorIsomorphicPlan((ILogicalPlan)plan, (ILogicalPlan)nestedPlan)) continue;
            return nestedPlan;
        }
        return null;
    }

    private boolean tryToPushRoot(Mutable<ILogicalOperator> root, GroupByOperator oldGbyOp, GroupByOperator newGbyOp, AbstractIntroduceCombinerRule.BookkeepingInfo bi, List<LogicalVariable> gbyVars, IOptimizationContext context, List<Mutable<ILogicalOperator>> toPushAccumulate, Set<AbstractIntroduceCombinerRule.SimilarAggregatesInfo> toReplaceSet) throws AlgebricksException {
        AbstractLogicalOperator op2;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)root.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AbstractLogicalOperator op3 = op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        while (op3.getOperatorTag() != LogicalOperatorTag.GROUP && op3.getInputs().size() == 1) {
            op3 = (AbstractLogicalOperator)((Mutable)op3.getInputs().get(0)).getValue();
        }
        if (op3.getOperatorTag() != LogicalOperatorTag.GROUP) {
            AggregateOperator initAgg = (AggregateOperator)op1;
            Pair<Boolean, Mutable<ILogicalOperator>> pOpRef = this.tryToPushAgg(initAgg, newGbyOp, toReplaceSet, context);
            if (!((Boolean)pOpRef.first).booleanValue()) {
                return false;
            }
            Mutable opRef = (Mutable)pOpRef.second;
            if (opRef != null) {
                toPushAccumulate.add((Mutable<ILogicalOperator>)opRef);
            }
            bi.modifyGbyMap.put(oldGbyOp, gbyVars);
            return true;
        }
        GroupByOperator nestedGby = (GroupByOperator)op3;
        List gbyVars2 = nestedGby.getGroupByVarList();
        HashSet freeVars = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)nestedGby, freeVars);
        gbyVars2.retainAll(freeVars);
        ArrayList<LogicalVariable> concatGbyVars = new ArrayList<LogicalVariable>(gbyVars);
        concatGbyVars.addAll(gbyVars2);
        for (ILogicalPlan p : nestedGby.getNestedPlans()) {
            for (Object r2 : p.getRoots()) {
                if (this.tryToPushRoot((Mutable<ILogicalOperator>)r2, nestedGby, newGbyOp, bi, concatGbyVars, context, toPushAccumulate, toReplaceSet)) continue;
                return false;
            }
        }
        MutableObject currentOpRef = new MutableObject((Object)nestedGby);
        Mutable<ILogicalOperator> bottomOpRef = this.findBottomOpRefStayInOldGby(nestedGby, (Mutable<ILogicalOperator>)currentOpRef);
        Set<LogicalVariable> usedVars = this.collectUsedFreeVariables((Mutable<ILogicalOperator>)currentOpRef, bottomOpRef);
        for (LogicalVariable usedVar : usedVars) {
            if (concatGbyVars.contains(usedVar)) continue;
            concatGbyVars.add(usedVar);
        }
        Mutable<ILogicalOperator> oldNtsRef = this.findNtsRef((Mutable<ILogicalOperator>)currentOpRef);
        ILogicalOperator opToCombiner = (ILogicalOperator)((Mutable)((ILogicalOperator)bottomOpRef.getValue()).getInputs().get(0)).getValue();
        if (opToCombiner.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return true;
        }
        ((ILogicalOperator)bottomOpRef.getValue()).getInputs().set(0, new MutableObject((Object)((ILogicalOperator)oldNtsRef.getValue())));
        Mutable<ILogicalOperator> newGbyNestedOpRef = this.findNtsRef(toPushAccumulate.get(0));
        NestedTupleSourceOperator newNts = (NestedTupleSourceOperator)newGbyNestedOpRef.getValue();
        newGbyNestedOpRef.setValue((Object)opToCombiner);
        oldNtsRef.setValue((Object)newNts);
        return true;
    }

    private Set<LogicalVariable> collectUsedFreeVariables(Mutable<ILogicalOperator> topOpRef, Mutable<ILogicalOperator> bottomOpRef) throws AlgebricksException {
        HashSet<LogicalVariable> usedVars = new HashSet<LogicalVariable>();
        Mutable currentOpRef = topOpRef;
        while (currentOpRef != bottomOpRef) {
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
            VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)currentOpRef.getValue()), usedVars);
        }
        HashSet freeVars = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)((AbstractLogicalOperator)topOpRef.getValue()), freeVars);
        usedVars.retainAll(freeVars);
        return usedVars;
    }

    private Mutable<ILogicalOperator> findNtsRef(Mutable<ILogicalOperator> currentOpRef) {
        while (((ILogicalOperator)currentOpRef.getValue()).getInputs().size() > 0) {
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        }
        return currentOpRef;
    }

    private Mutable<ILogicalOperator> findBottomOpRefStayInOldGby(GroupByOperator nestedGby, Mutable<ILogicalOperator> currentOpRef) throws AlgebricksException {
        HashSet usedVarsInNestedGby = new HashSet();
        for (ILogicalPlan nestedPlan : nestedGby.getNestedPlans()) {
            for (Mutable rootOpRef : nestedPlan.getRoots()) {
                VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)((ILogicalOperator)rootOpRef.getValue()), usedVarsInNestedGby);
            }
        }
        Mutable bottomOpRef = currentOpRef;
        while (((ILogicalOperator)currentOpRef.getValue()).getInputs().size() > 0) {
            HashSet dependingVars = new HashSet();
            VariableUtilities.getProducedVariables((ILogicalOperator)((ILogicalOperator)currentOpRef.getValue()), dependingVars);
            dependingVars.removeAll(usedVarsInNestedGby);
            if (((ILogicalOperator)currentOpRef.getValue()).getOperatorTag() == LogicalOperatorTag.SELECT || !dependingVars.isEmpty()) {
                bottomOpRef = currentOpRef;
            }
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        }
        return bottomOpRef;
    }

    protected abstract void processNullTest(IOptimizationContext var1, GroupByOperator var2, List<LogicalVariable> var3);
}

