/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.FullTextContainsFunctionEvaluator;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class FullTextContainsFunctionDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 2L;
    private static final Map<String, ATypeTag> paramTypeMap = new LinkedHashMap<String, ATypeTag>();
    public static final String SEARCH_MODE_OPTION = "mode";
    private static final byte[] SEARCH_MODE_OPTION_ARRAY = UTF8StringUtil.writeStringToBytes((String)"mode");
    private static final byte[] DISJUNCTIVE_SEARCH_MODE_OPTION_ARRAY = UTF8StringUtil.writeStringToBytes((String)SearchMode.ANY.getValue());
    private static final byte[] CONJUNCTIVE_SEARCH_MODE_OPTION_ARRAY = UTF8StringUtil.writeStringToBytes((String)SearchMode.ALL.getValue());
    public static final String FULLTEXT_CONFIG_OPTION = "config";
    private IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory;
    public static final IFunctionDescriptorFactory FACTORY;

    public void setImmutableStates(Object ... states) {
        IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory;
        super.setImmutableStates(states);
        this.fullTextConfigEvaluatorFactory = fullTextConfigEvaluatorFactory = (IFullTextConfigEvaluatorFactory)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 2L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new FullTextContainsFunctionEvaluator(args, ctx, FullTextContainsFunctionDescriptor.this.fullTextConfigEvaluatorFactory);
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.FULLTEXT_CONTAINS;
    }

    public static byte[] getSearchModeOptionArray() {
        return SEARCH_MODE_OPTION_ARRAY;
    }

    public static byte[] getDisjunctiveFTSearchOptionArray() {
        return DISJUNCTIVE_SEARCH_MODE_OPTION_ARRAY;
    }

    public static byte[] getConjunctiveFTSearchOptionArray() {
        return CONJUNCTIVE_SEARCH_MODE_OPTION_ARRAY;
    }

    public static Map<String, ATypeTag> getParamTypeMap() {
        return paramTypeMap;
    }

    static {
        paramTypeMap.put(SEARCH_MODE_OPTION, ATypeTag.STRING);
        paramTypeMap.put(FULLTEXT_CONFIG_OPTION, ATypeTag.STRING);
        FACTORY = new IFunctionDescriptorFactory(){

            public IFunctionDescriptor createFunctionDescriptor() {
                return new FullTextContainsFunctionDescriptor();
            }

            public IFunctionTypeInferer createFunctionTypeInferer() {
                return new FunctionTypeInferers.FullTextContainsTypeInferer();
            }
        };
    }

    public static enum SearchMode {
        ANY("any"),
        ALL("all");

        private String value;

        private SearchMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

