/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.impls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.HaltOnFailureCallback;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.PageWriteFailureCallback;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public abstract class AbstractTreeIndex
implements ITreeIndex {
    public static final int MINIMAL_TREE_PAGE_COUNT = 2;
    public static final int MINIMAL_TREE_PAGE_COUNT_WITH_FILTER = 3;
    protected int rootPage = 1;
    protected final IBufferCache bufferCache;
    protected final IPageManager freePageManager;
    protected final ITreeIndexFrameFactory interiorFrameFactory;
    protected final ITreeIndexFrameFactory leafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    protected final int fieldCount;
    protected FileReference file;
    private int fileId = -1;
    protected boolean isActive = false;
    protected int bulkloadLeafStart = 0;

    public AbstractTreeIndex(IBufferCache bufferCache, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        this.bufferCache = bufferCache;
        this.freePageManager = freePageManager;
        this.interiorFrameFactory = interiorFrameFactory;
        this.leafFrameFactory = leafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.fieldCount = fieldCount;
        this.file = file;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.fileId = this.bufferCache.createFile(this.file);
        boolean failed = true;
        try {
            this.bufferCache.openFile(this.fileId);
            failed = false;
        }
        finally {
            if (failed) {
                this.bufferCache.deleteFile(this.fileId);
            }
        }
        failed = true;
        try {
            this.freePageManager.open(this.fileId);
            this.freePageManager.init(this.interiorFrameFactory, this.leafFrameFactory);
            this.setRootPage();
            this.freePageManager.close((IPageWriteFailureCallback)HaltOnFailureCallback.INSTANCE);
            failed = false;
        }
        finally {
            this.bufferCache.closeFile(this.fileId);
            if (failed) {
                this.bufferCache.deleteFile(this.fileId);
            }
        }
    }

    private void setRootPage() throws HyracksDataException {
        this.rootPage = this.freePageManager.getRootPageId();
        this.bulkloadLeafStart = this.freePageManager.getBulkLoadLeaf();
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ACTIVATE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        if (this.fileId >= 0) {
            this.bufferCache.openFile(this.fileId);
        } else {
            this.fileId = this.bufferCache.openFile(this.file);
        }
        this.freePageManager.open(this.fileId);
        this.setRootPage();
        this.isActive = true;
    }

    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DEACTIVATE_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.freePageManager.close((IPageWriteFailureCallback)HaltOnFailureCallback.INSTANCE);
        this.bufferCache.closeFile(this.fileId);
        this.isActive = false;
    }

    public void purge() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_PURGE_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.purgeHandle(this.fileId);
        this.fileId = -1;
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_DESTROY_ACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.bufferCache.deleteFile(this.file);
    }

    public synchronized void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CLEAR_INACTIVE_INDEX, (Serializable[])new Serializable[0]);
        }
        this.freePageManager.init(this.interiorFrameFactory, this.leafFrameFactory);
        this.setRootPage();
    }

    public boolean isEmptyTree(ITreeIndexFrame frame) throws HyracksDataException {
        if (this.rootPage == -1) {
            return true;
        }
        return this.freePageManager.isEmpty(frame, this.rootPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getTreeHeight(ITreeIndexFrame frame) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.rootPage), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            byte by = frame.getLevel();
            return by;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }

    @Override
    public int getFileId() {
        return this.fileId;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.interiorFrameFactory;
    }

    @Override
    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.leafFrameFactory;
    }

    @Override
    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    @Override
    public IPageManager getPageManager() {
        return this.freePageManager;
    }

    @Override
    public int getRootPageId() {
        return this.rootPage;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    public IBinaryComparatorFactory[] getCmpFactories() {
        return this.cmpFactories;
    }

    public String toString() {
        return "{\"class\":\"" + this.getClass().getSimpleName() + "\",\"file\":\"" + this.file.getRelativePath() + "\"}";
    }

    public abstract class AbstractTreeIndexBulkLoader
    extends PageWriteFailureCallback
    implements IIndexBulkLoader {
        protected final MultiComparator cmp;
        protected final int slotSize;
        protected final int leafMaxBytes;
        protected final int interiorMaxBytes;
        protected final ArrayList<NodeFrontier> nodeFrontiers = new ArrayList();
        protected final ITreeIndexMetadataFrame metaFrame;
        protected final ITreeIndexTupleWriter tupleWriter;
        protected ITreeIndexFrame leafFrame;
        protected ITreeIndexFrame interiorFrame;
        protected boolean releasedLatches;
        private final IFIFOPageWriter pageWriter;
        protected List<ICachedPage> pagesToWrite;
        private final ICompressedPageWriter compressedPageWriter;

        public AbstractTreeIndexBulkLoader(float fillFactor, IPageWriteCallback callback) throws HyracksDataException {
            this.leafFrame = AbstractTreeIndex.this.leafFrameFactory.createFrame();
            this.interiorFrame = AbstractTreeIndex.this.interiorFrameFactory.createFrame();
            this.metaFrame = AbstractTreeIndex.this.freePageManager.createMetadataFrame();
            this.pageWriter = AbstractTreeIndex.this.bufferCache.createFIFOWriter(callback, (IPageWriteFailureCallback)this);
            if (!AbstractTreeIndex.this.isEmptyTree(this.leafFrame)) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_BULK_LOAD_NON_EMPTY_TREE, (Serializable[])new Serializable[0]);
            }
            this.cmp = MultiComparator.create((IBinaryComparatorFactory[])AbstractTreeIndex.this.cmpFactories);
            this.leafFrame.setMultiComparator(this.cmp);
            this.interiorFrame.setMultiComparator(this.cmp);
            this.tupleWriter = this.leafFrame.getTupleWriter();
            NodeFrontier leafFrontier = new NodeFrontier(this.leafFrame.createTupleReference());
            leafFrontier.pageId = AbstractTreeIndex.this.freePageManager.takePage(this.metaFrame);
            leafFrontier.page = AbstractTreeIndex.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)AbstractTreeIndex.this.fileId, (int)leafFrontier.pageId));
            this.interiorFrame.setPage(leafFrontier.page);
            this.interiorFrame.initBuffer((byte)0);
            this.interiorMaxBytes = (int)((float)this.interiorFrame.getBuffer().capacity() * fillFactor);
            this.leafFrame.setPage(leafFrontier.page);
            this.leafFrame.initBuffer((byte)0);
            this.leafMaxBytes = (int)((float)this.leafFrame.getBuffer().capacity() * fillFactor);
            this.slotSize = this.leafFrame.getSlotSize();
            this.nodeFrontiers.add(leafFrontier);
            this.pagesToWrite = new ArrayList<ICachedPage>();
            this.compressedPageWriter = AbstractTreeIndex.this.bufferCache.getCompressedPageWriter(AbstractTreeIndex.this.fileId);
        }

        protected void handleException() {
            this.compressedPageWriter.abort();
            for (NodeFrontier nodeFrontier : this.nodeFrontiers) {
                ICachedPage frontierPage;
                if (nodeFrontier == null || nodeFrontier.page == null || !(frontierPage = nodeFrontier.page).confiscated()) continue;
                AbstractTreeIndex.this.bufferCache.returnPage(frontierPage, false);
            }
            for (ICachedPage pageToDiscard : this.pagesToWrite) {
                if (pageToDiscard == null) continue;
                AbstractTreeIndex.this.bufferCache.returnPage(pageToDiscard, false);
            }
            this.releasedLatches = true;
        }

        public void end() throws HyracksDataException {
            if (this.hasFailed()) {
                throw HyracksDataException.create((Throwable)this.getFailure());
            }
            AbstractTreeIndex.this.freePageManager.setRootPageId(AbstractTreeIndex.this.rootPage);
        }

        protected void addLevel() throws HyracksDataException {
            NodeFrontier frontier = new NodeFrontier(this.tupleWriter.createTupleReference());
            frontier.page = AbstractTreeIndex.this.bufferCache.confiscatePage(-1L);
            frontier.pageId = -1;
            frontier.lastTuple.setFieldCount(this.cmp.getKeyFieldCount());
            this.interiorFrame.setPage(frontier.page);
            this.interiorFrame.initBuffer((byte)this.nodeFrontiers.size());
            this.nodeFrontiers.add(frontier);
        }

        public ITreeIndexFrame getLeafFrame() {
            return this.leafFrame;
        }

        public void setLeafFrame(ITreeIndexFrame leafFrame) {
            this.leafFrame = leafFrame;
        }

        public void write(ICachedPage cPage) throws HyracksDataException {
            this.compressedPageWriter.prepareWrite(cPage);
            this.pageWriter.write(cPage);
        }

        public void force() throws HyracksDataException {
            AbstractTreeIndex.this.bufferCache.force(AbstractTreeIndex.this.fileId, false);
        }
    }
}

