/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import org.apache.hyracks.http.server.HttpServerConfig;

public class HttpServerConfigBuilder {
    private static final int MAX_REQUEST_CHUNK_SIZE = 262144;
    private static final int MAX_REQUEST_HEADER_SIZE = 262144;
    private static final int MAX_REQUEST_INITIAL_LINE_LENGTH = 131072;
    private static final int RESPONSE_CHUNK_SIZE = 4096;
    private static final int DEFAULT_THREAD_COUNT = 16;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 256;
    private int maxRequestSize = Integer.MAX_VALUE;
    private int threadCount = 16;
    private int requestQueueSize = 256;
    private int maxRequestChunkSize = 262144;
    private int maxResponseChunkSize = 4096;
    private int maxRequestHeaderSize = 262144;
    private int maxRequestInitialLineLength = 131072;

    private HttpServerConfigBuilder() {
    }

    public static HttpServerConfig createDefault() {
        return new HttpServerConfigBuilder().build();
    }

    public static HttpServerConfigBuilder custom() {
        return new HttpServerConfigBuilder();
    }

    public HttpServerConfigBuilder setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public HttpServerConfigBuilder setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public HttpServerConfigBuilder setRequestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
        return this;
    }

    public HttpServerConfigBuilder setMaxRequestChunkSize(int maxRequestChunkSize) {
        this.maxRequestChunkSize = maxRequestChunkSize;
        return this;
    }

    public HttpServerConfigBuilder setMaxResponseChunkSize(int maxResponseChunkSize) {
        this.maxResponseChunkSize = maxResponseChunkSize;
        return this;
    }

    public HttpServerConfigBuilder setMaxRequestHeaderSize(int maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        return this;
    }

    public HttpServerConfigBuilder setMaxRequestInitialLineLength(int maxRequestInitialLineLength) {
        this.maxRequestInitialLineLength = maxRequestInitialLineLength;
        return this;
    }

    public HttpServerConfig build() {
        return HttpServerConfig.of(this.threadCount, this.requestQueueSize, this.maxRequestSize, this.maxRequestInitialLineLength, this.maxRequestHeaderSize, this.maxRequestChunkSize, this.maxResponseChunkSize);
    }
}

