/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismVariableMappingVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;

public class IsomorphismUtilities {
    public static void mapVariablesTopDown(ILogicalOperator op, ILogicalOperator arg, Map<LogicalVariable, LogicalVariable> variableMapping) throws AlgebricksException {
        IsomorphismUtilities.mapVariablesTopDown(op, arg, variableMapping, true);
    }

    public static void mapVariablesTopDown(ILogicalOperator op, ILogicalOperator arg, Map<LogicalVariable, LogicalVariable> variableMapping, boolean goThroughNts) throws AlgebricksException {
        IsomorphismVariableMappingVisitor visitor = new IsomorphismVariableMappingVisitor(variableMapping, goThroughNts);
        op.accept(visitor, arg);
    }

    public static boolean isOperatorIsomorphic(ILogicalOperator op, ILogicalOperator arg) throws AlgebricksException {
        IsomorphismOperatorVisitor visitor = new IsomorphismOperatorVisitor();
        return op.accept(visitor, arg);
    }

    public static boolean isOperatorIsomorphicPlanSegment(ILogicalOperator op, ILogicalOperator arg) throws AlgebricksException {
        List<Mutable<ILogicalOperator>> inputs1 = op.getInputs();
        List<Mutable<ILogicalOperator>> inputs2 = arg.getInputs();
        if (inputs1.size() != inputs2.size()) {
            return false;
        }
        for (int i = 0; i < inputs1.size(); ++i) {
            ILogicalOperator input2;
            ILogicalOperator input1 = (ILogicalOperator)inputs1.get(i).getValue();
            boolean isomorphic = IsomorphismUtilities.isOperatorIsomorphicPlanSegment(input1, input2 = (ILogicalOperator)inputs2.get(i).getValue());
            if (isomorphic) continue;
            return false;
        }
        return IsomorphismUtilities.isOperatorIsomorphic(op, arg);
    }

    public static boolean isOperatorIsomorphicPlan(ILogicalPlan plan, ILogicalPlan arg) throws AlgebricksException {
        if (plan.getRoots().size() != arg.getRoots().size()) {
            return false;
        }
        for (int i = 0; i < plan.getRoots().size(); ++i) {
            ILogicalOperator topOp2;
            ILogicalOperator topOp1 = (ILogicalOperator)plan.getRoots().get(i).getValue();
            if (IsomorphismUtilities.isOperatorIsomorphicPlanSegment(topOp1, topOp2 = (ILogicalOperator)arg.getRoots().get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    private static ILogicalOperator getOpThatProducesPK(ILogicalOperator rootOp, LogicalVariable pkVar) throws AlgebricksException {
        ILogicalOperator prodOp = null;
        for (Mutable<ILogicalOperator> opRef : rootOp.getInputs()) {
            boolean produced = false;
            ArrayList<LogicalVariable> producedVars = new ArrayList<LogicalVariable>();
            VariableUtilities.getProducedVariables((ILogicalOperator)opRef.getValue(), producedVars);
            if (producedVars.contains(pkVar)) {
                prodOp = (ILogicalOperator)opRef.getValue();
                produced = true;
            } else if (((ILogicalOperator)opRef.getValue()).hasInputs() && (prodOp = IsomorphismUtilities.getOpThatProducesPK((ILogicalOperator)opRef.getValue(), pkVar)) != null) {
                produced = true;
            }
            if (!produced) continue;
            break;
        }
        return prodOp;
    }

    public static void mergeHomogeneousPK(ILogicalOperator op, List<LogicalVariable> pkVars) throws AlgebricksException {
        HashMap<LogicalVariable, ILogicalOperator> varOpMap = new HashMap<LogicalVariable, ILogicalOperator>();
        for (LogicalVariable pk : pkVars) {
            ILogicalOperator mOp = IsomorphismUtilities.getOpThatProducesPK(op, pk);
            if (mOp == null || !mOp.getOperatorTag().equals((Object)LogicalOperatorTag.DATASOURCESCAN)) {
                throw new AlgebricksException("Illegal variable production.");
            }
            varOpMap.put(pk, mOp);
        }
        HashMap<LogicalVariable, LogicalVariable> variableMapping = new HashMap<LogicalVariable, LogicalVariable>();
        for (int i = 0; i < pkVars.size() - 1; ++i) {
            for (int j = i + 1; j < pkVars.size(); ++j) {
                IDataSource<?> leftSource = ((DataSourceScanOperator)varOpMap.get(pkVars.get(i))).getDataSource();
                IDataSource<?> rightSource = ((DataSourceScanOperator)varOpMap.get(pkVars.get(j))).getDataSource();
                if (!leftSource.getId().toString().equals(rightSource.getId().toString())) continue;
                IsomorphismUtilities.mapVariablesTopDown((ILogicalOperator)varOpMap.get(pkVars.get(i)), (ILogicalOperator)varOpMap.get(pkVars.get(j)), variableMapping);
            }
        }
        Iterator<LogicalVariable> itr = pkVars.iterator();
        while (itr.hasNext()) {
            LogicalVariable pk = itr.next();
            if (!variableMapping.containsKey(pk)) continue;
            variableMapping.remove(pk);
            itr.remove();
        }
    }
}

