/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.asterix.common.api.IDatasetInfoProvider;
import org.apache.asterix.common.api.ILSMComponentIdGeneratorFactory;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.DatasetInfoProvider;
import org.apache.asterix.common.context.DatasetLSMComponentIdGeneratorFactory;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.NoOpFrameOperationCallbackFactory;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.ioopcallbacks.LSMIndexIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMIndexPageWriteCallbackFactory;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.declared.ArrayBTreeResourceFactoryProvider;
import org.apache.asterix.metadata.declared.BTreeResourceFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.InvertedIndexResourceFactoryProvider;
import org.apache.asterix.metadata.utils.MetadataUtil;
import org.apache.asterix.metadata.utils.RTreeResourceFactoryProvider;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexInstanctSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.UpsertOperationCallbackFactory;
import org.apache.asterix.transaction.management.resource.DatasetLocalResourceFactory;
import org.apache.asterix.transaction.management.runtime.CommitRuntimeFactory;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Dataset
implements IMetadataEntity<Dataset>,
IDataset {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RTreeResourceFactoryProvider rTreeResourceFactoryProvider = RTreeResourceFactoryProvider.INSTANCE;
    private static final InvertedIndexResourceFactoryProvider invertedIndexResourceFactoryProvider = InvertedIndexResourceFactoryProvider.INSTANCE;
    private final int datasetId;
    private final DataverseName dataverseName;
    private final String datasetName;
    private final DataverseName recordTypeDataverseName;
    private final String recordTypeName;
    private final String nodeGroupName;
    private final String compactionPolicyFactory;
    private final Map<String, String> hints;
    private final Map<String, String> compactionPolicyProperties;
    private final DatasetConfig.DatasetType datasetType;
    private final IDatasetDetails datasetDetails;
    private final DataverseName metaTypeDataverseName;
    private final String metaTypeName;
    private final long rebalanceCount;
    private int pendingOp;
    private final String compressionScheme;
    private final DatasetFullyQualifiedName datasetFullyQualifiedName;

    public Dataset(DataverseName dataverseName, String datasetName, DataverseName recordTypeDataverseName, String recordTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp) {
        this(dataverseName, datasetName, recordTypeDataverseName, recordTypeName, null, null, nodeGroupName, compactionPolicy, compactionPolicyProperties, datasetDetails, hints, datasetType, datasetId, pendingOp, "none");
    }

    public Dataset(DataverseName dataverseName, String datasetName, DataverseName itemTypeDataverseName, String itemTypeName, DataverseName metaItemTypeDataverseName, String metaItemTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp, String compressionScheme) {
        this(dataverseName, datasetName, itemTypeDataverseName, itemTypeName, metaItemTypeDataverseName, metaItemTypeName, nodeGroupName, compactionPolicy, compactionPolicyProperties, datasetDetails, hints, datasetType, datasetId, pendingOp, 0L, compressionScheme);
    }

    public Dataset(Dataset dataset) {
        this(dataset.dataverseName, dataset.datasetName, dataset.recordTypeDataverseName, dataset.recordTypeName, dataset.metaTypeDataverseName, dataset.metaTypeName, dataset.nodeGroupName, dataset.compactionPolicyFactory, dataset.compactionPolicyProperties, dataset.datasetDetails, dataset.hints, dataset.datasetType, dataset.datasetId, dataset.pendingOp, dataset.rebalanceCount, dataset.compressionScheme);
    }

    public Dataset(DataverseName dataverseName, String datasetName, DataverseName itemTypeDataverseName, String itemTypeName, DataverseName metaItemTypeDataverseName, String metaItemTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp, long rebalanceCount, String compressionScheme) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.recordTypeName = itemTypeName;
        this.recordTypeDataverseName = itemTypeDataverseName;
        this.metaTypeDataverseName = metaItemTypeDataverseName;
        this.metaTypeName = metaItemTypeName;
        this.nodeGroupName = nodeGroupName;
        this.compactionPolicyFactory = compactionPolicy;
        this.compactionPolicyProperties = compactionPolicyProperties;
        this.datasetType = datasetType;
        this.datasetDetails = datasetDetails;
        this.datasetId = datasetId;
        this.pendingOp = pendingOp;
        this.hints = hints;
        this.rebalanceCount = rebalanceCount;
        this.compressionScheme = compressionScheme;
        this.datasetFullyQualifiedName = new DatasetFullyQualifiedName(dataverseName, datasetName);
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getItemTypeName() {
        return this.recordTypeName;
    }

    public DataverseName getItemTypeDataverseName() {
        return this.recordTypeDataverseName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getCompactionPolicy() {
        return this.compactionPolicyFactory;
    }

    public Map<String, String> getCompactionPolicyProperties() {
        return this.compactionPolicyProperties;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public IDatasetDetails getDatasetDetails() {
        return this.datasetDetails;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    public DataverseName getMetaItemTypeDataverseName() {
        return this.metaTypeDataverseName;
    }

    public String getMetaItemTypeName() {
        return this.metaTypeName;
    }

    public long getRebalanceCount() {
        return this.rebalanceCount;
    }

    public boolean hasMetaPart() {
        return this.metaTypeDataverseName != null && this.metaTypeName != null;
    }

    public void setPendingOp(int pendingOp) {
        this.pendingOp = pendingOp;
    }

    @Override
    public Dataset addToCache(MetadataCache cache) {
        return cache.addDatasetIfNotExists(this);
    }

    @Override
    public Dataset dropFromCache(MetadataCache cache) {
        return cache.dropDataset(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dataset)) {
            return false;
        }
        Dataset otherDataset = (Dataset)other;
        return Objects.equals(this.dataverseName, otherDataset.dataverseName) && Objects.equals(this.datasetName, otherDataset.datasetName);
    }

    public boolean allow(ILogicalOperator topOp, byte operation) {
        if (!this.hasMetaPart()) {
            return true;
        }
        if (((ILogicalOperator)((Mutable)topOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        ILogicalOperator op = (ILogicalOperator)((Mutable)topOp.getInputs().get(0)).getValue();
        while (!op.getInputs().isEmpty() && ((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.UNNEST) {
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        if (op.getInputs().isEmpty()) {
            return false;
        }
        UnnestOperator unnestOp = (UnnestOperator)((Mutable)op.getInputs().get(0)).getValue();
        if (((ILogicalExpression)unnestOp.getExpressionRef().getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)unnestOp.getExpressionRef().getValue();
        if (functionCall.getFunctionIdentifier() != BuiltinFunctions.FEED_COLLECT) {
            return false;
        }
        return operation == 3;
    }

    public void drop(MetadataProvider metadataProvider, MutableObject<MetadataTransactionContext> mdTxnCtx, List<JobSpecification> jobsToExecute, MutableBoolean bActiveTxn, MutableObject<JobUtils.ProgressState> progress, IHyracksClientConnection hcc, boolean dropCorrespondingNodeGroup, SourceLocation sourceLoc, Set<IndexDropOperatorDescriptor.DropOption> options, boolean force) throws Exception {
        HashMap disconnectJobList = new HashMap();
        if (this.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            List<Index> indexes = MetadataManager.INSTANCE.getDatasetIndexes((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
            for (int j = 0; j < indexes.size(); ++j) {
                if (!indexes.get(j).isSecondaryIndex()) continue;
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec(indexes.get(j), metadataProvider, this, options, sourceLoc));
            }
            jobsToExecute.add(DatasetUtil.dropDatasetJobSpec(this, metadataProvider, options));
            MetadataManager.INSTANCE.dropDataset((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName, force);
            MetadataManager.INSTANCE.addDataset((MetadataTransactionContext)mdTxnCtx.getValue(), new Dataset(this.dataverseName, this.datasetName, this.getItemTypeDataverseName(), this.getItemTypeName(), this.getMetaItemTypeDataverseName(), this.getMetaItemTypeName(), this.getNodeGroupName(), this.getCompactionPolicy(), this.getCompactionPolicyProperties(), this.getDatasetDetails(), this.getHints(), this.getDatasetType(), this.getDatasetId(), 2, this.getCompressionScheme()));
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
            bActiveTxn.setValue(false);
            progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
            for (Pair p : disconnectJobList.values()) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)((JobSpecification)p.first), (boolean)true);
            }
            for (JobSpecification jobSpec : jobsToExecute) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
            bActiveTxn.setValue(true);
            metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        } else if (this.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(this);
            List<Index> indexes = MetadataManager.INSTANCE.getDatasetIndexes((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
            for (int j = 0; j < indexes.size(); ++j) {
                if (ExternalIndexingOperations.isFileIndex(indexes.get(j))) {
                    jobsToExecute.add(IndexUtil.buildDropIndexJobSpec(indexes.get(j), metadataProvider, this, sourceLoc));
                    continue;
                }
                jobsToExecute.add(DatasetUtil.buildDropFilesIndexJobSpec(metadataProvider, this));
            }
            MetadataManager.INSTANCE.dropDataset((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName, force);
            MetadataManager.INSTANCE.addDataset((MetadataTransactionContext)mdTxnCtx.getValue(), new Dataset(this.dataverseName, this.datasetName, this.getItemTypeDataverseName(), this.getItemTypeName(), this.getNodeGroupName(), this.getCompactionPolicy(), this.getCompactionPolicyProperties(), this.getDatasetDetails(), this.getHints(), this.getDatasetType(), this.getDatasetId(), 2));
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
            bActiveTxn.setValue(false);
            progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
            for (JobSpecification jobSpec : jobsToExecute) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            if (!indexes.isEmpty()) {
                ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(this);
            }
            mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
            bActiveTxn.setValue(true);
            metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        }
        MetadataManager.INSTANCE.dropDataset((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName, force);
        if (TypeUtil.isDatasetInlineTypeName(this, this.recordTypeDataverseName, this.recordTypeName)) {
            MetadataManager.INSTANCE.dropDatatype((MetadataTransactionContext)mdTxnCtx.getValue(), this.recordTypeDataverseName, this.recordTypeName);
        }
        if (this.hasMetaPart() && TypeUtil.isDatasetInlineTypeName(this, this.metaTypeDataverseName, this.metaTypeName)) {
            MetadataManager.INSTANCE.dropDatatype((MetadataTransactionContext)mdTxnCtx.getValue(), this.metaTypeDataverseName, this.metaTypeName);
        }
        if (dropCorrespondingNodeGroup) {
            metadataProvider.getApplicationContext().getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), this.nodeGroupName);
            MetadataManager.INSTANCE.dropNodegroup((MetadataTransactionContext)mdTxnCtx.getValue(), this.nodeGroupName, true);
        }
    }

    public IResourceFactory getResourceFactory(MetadataProvider mdProvider, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties) throws AlgebricksException {
        IResourceFactory resourceFactory;
        ITypeTraits[] filterTypeTraits = DatasetUtil.computeFilterTypeTraits(this, recordType, metaType);
        IBinaryComparatorFactory[] filterCmpFactories = DatasetUtil.computeFilterBinaryComparatorFactories(this, recordType, metaType, mdProvider.getStorageComponentProvider().getComparatorFactoryProvider());
        switch (index.getIndexType()) {
            case ARRAY: {
                resourceFactory = ArrayBTreeResourceFactoryProvider.INSTANCE.getResourceFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
                break;
            }
            case BTREE: {
                resourceFactory = BTreeResourceFactoryProvider.INSTANCE.getResourceFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
                break;
            }
            case RTREE: {
                resourceFactory = rTreeResourceFactoryProvider.getResourceFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
                break;
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case SINGLE_PARTITION_WORD_INVIX: {
                resourceFactory = invertedIndexResourceFactoryProvider.getResourceFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{index.getIndexType().toString()});
            }
        }
        return new DatasetLocalResourceFactory(this.datasetId, resourceFactory);
    }

    public ILSMIOOperationCallbackFactory getIoOperationCallbackFactory(Index index) throws AlgebricksException {
        return new LSMIndexIOOperationCallbackFactory(this.getComponentIdGeneratorFactory(), this.getDatasetInfoProvider());
    }

    public ILSMPageWriteCallbackFactory getPageWriteCallbackFactory() throws AlgebricksException {
        return new LSMIndexPageWriteCallbackFactory();
    }

    public ILSMOperationTrackerFactory getIndexOperationTrackerFactory(Index index) {
        return index.isPrimaryIndex() ? new PrimaryIndexOperationTrackerFactory(this.getDatasetId()) : new SecondaryIndexOperationTrackerFactory(this.getDatasetId());
    }

    public ILSMComponentIdGeneratorFactory getComponentIdGeneratorFactory() {
        return new DatasetLSMComponentIdGeneratorFactory(this.getDatasetId());
    }

    public IDatasetInfoProvider getDatasetInfoProvider() {
        return new DatasetInfoProvider(this.getDatasetId());
    }

    public ISearchOperationCallbackFactory getSearchCallbackFactory(IStorageComponentProvider storageComponentProvider, Index index, IndexOperation op, int[] primaryKeyFields, int[] primaryKeyFieldsInSecondaryIndex, boolean proceedIndexOnlyPlan) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            return op == IndexOperation.UPSERT || op == IndexOperation.INSERT ? new LockThenSearchOperationCallbackFactory(this.getDatasetId(), primaryKeyFields, storageComponentProvider.getTransactionSubsystemProvider(), 0) : new PrimaryIndexInstantSearchOperationCallbackFactory(this.getDatasetId(), primaryKeyFields, storageComponentProvider.getTransactionSubsystemProvider(), 0);
        }
        if (proceedIndexOnlyPlan) {
            return new SecondaryIndexInstanctSearchOperationCallbackFactory(this.getDatasetId(), primaryKeyFieldsInSecondaryIndex, storageComponentProvider.getTransactionSubsystemProvider(), index.resourceType());
        }
        if (index.isPrimaryKeyIndex()) {
            return new PrimaryIndexInstantSearchOperationCallbackFactory(this.getDatasetId(), primaryKeyFields, storageComponentProvider.getTransactionSubsystemProvider(), 0);
        }
        return new SecondaryIndexSearchOperationCallbackFactory();
    }

    public ISearchOperationCallbackFactory getSearchCallbackFactory(IStorageComponentProvider storageComponentProvider, Index index, IndexOperation op, int[] primaryKeyFields) throws AlgebricksException {
        return this.getSearchCallbackFactory(storageComponentProvider, index, op, primaryKeyFields, null, false);
    }

    public IModificationOperationCallbackFactory getModificationCallbackFactory(IStorageComponentProvider componentProvider, Index index, IndexOperation op, int[] primaryKeyFields) throws AlgebricksException {
        if (index.isPrimaryIndex()) {
            return op == IndexOperation.UPSERT || op == IndexOperation.INSERT ? new UpsertOperationCallbackFactory(this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : (op == IndexOperation.DELETE ? new PrimaryIndexModificationOperationCallbackFactory(this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : NoOpOperationCallbackFactory.INSTANCE);
        }
        return op == IndexOperation.DELETE || op == IndexOperation.INSERT || op == IndexOperation.UPSERT ? new SecondaryIndexModificationOperationCallbackFactory(this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : NoOpOperationCallbackFactory.INSTANCE;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this.toMap());
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARN, "Unable to convert map to json String", (Throwable)e);
            return this.dataverseName + "." + this.datasetName;
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> tree = new HashMap<String, Object>();
        tree.put("datasetId", Integer.toString(this.datasetId));
        tree.put("dataverseName", this.dataverseName);
        tree.put("datasetName", this.datasetName);
        tree.put("recordTypeDataverseName", this.recordTypeDataverseName);
        tree.put("recordTypeName", this.recordTypeName);
        tree.put("nodeGroupName", this.nodeGroupName);
        tree.put("compactionPolicyFactory", this.compactionPolicyFactory);
        tree.put("hints", this.hints);
        tree.put("compactionPolicyProperties", this.compactionPolicyProperties);
        tree.put("datasetType", this.datasetType.name());
        tree.put("datasetDetails", this.datasetDetails.toString());
        tree.put("metaTypeDataverseName", this.metaTypeDataverseName);
        tree.put("metaTypeName", this.metaTypeName);
        tree.put("pendingOp", MetadataUtil.pendingOpToString(this.pendingOp));
        tree.put("rebalanceCount", this.rebalanceCount);
        tree.put("compressionScheme", this.compressionScheme);
        return tree;
    }

    public int hashCode() {
        return Objects.hash(this.dataverseName, this.datasetName);
    }

    public IPushRuntimeFactory getCommitRuntimeFactory(MetadataProvider metadataProvider, int[] primaryKeyFieldPermutation, boolean isSink) throws AlgebricksException {
        int[] datasetPartitions = this.getDatasetPartitions(metadataProvider);
        return new CommitRuntimeFactory(this.datasetId, primaryKeyFieldPermutation, metadataProvider.isWriteTransaction(), datasetPartitions, isSink);
    }

    public IFrameOperationCallbackFactory getFrameOpCallbackFactory(MetadataProvider mdProvider) {
        return NoOpFrameOperationCallbackFactory.INSTANCE;
    }

    public boolean isCorrelated() {
        return "correlated-prefix".equals(this.compactionPolicyFactory);
    }

    public List<List<String>> getPrimaryKeys() {
        if (this.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return IndexingConstants.getRIDKeys(((ExternalDatasetDetails)this.getDatasetDetails()).getProperties());
        }
        return ((InternalDatasetDetails)this.getDatasetDetails()).getPartitioningKey();
    }

    public ITypeTraits[] getPrimaryTypeTraits(MetadataProvider metadataProvider, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        IStorageComponentProvider storageComponentProvider = metadataProvider.getStorageComponentProvider();
        ITypeTraitProvider ttProvider = storageComponentProvider.getTypeTraitProvider();
        List<List<String>> partitioningKeys = this.getPrimaryKeys();
        int numPrimaryKeys = partitioningKeys.size();
        ITypeTraits[] typeTraits = new ITypeTraits[numPrimaryKeys + 1 + (this.hasMetaPart() ? 1 : 0)];
        List<Integer> indicators = null;
        if (this.hasMetaPart()) {
            indicators = ((InternalDatasetDetails)this.getDatasetDetails()).getKeySourceIndicator();
        }
        for (int i = 0; i < numPrimaryKeys; ++i) {
            IAType keyType = this.datasetType == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getFieldType((int)i) : (indicators == null || indicators.get(i) == 0 ? recordType.getSubFieldType(partitioningKeys.get(i)) : metaType.getSubFieldType(partitioningKeys.get(i)));
            typeTraits[i] = ttProvider.getTypeTrait((Object)keyType);
        }
        typeTraits[numPrimaryKeys] = ttProvider.getTypeTrait((Object)recordType);
        if (this.hasMetaPart()) {
            typeTraits[numPrimaryKeys + 1] = ttProvider.getTypeTrait((Object)metaType);
        }
        return typeTraits;
    }

    public RecordDescriptor getPrimaryRecordDescriptor(MetadataProvider metadataProvider) throws AlgebricksException {
        List<List<String>> partitioningKeys = this.getPrimaryKeys();
        int numPrimaryKeys = partitioningKeys.size();
        ISerializerDeserializer[] primaryRecFields = new ISerializerDeserializer[numPrimaryKeys + 1 + (this.hasMetaPart() ? 1 : 0)];
        ITypeTraits[] primaryTypeTraits = new ITypeTraits[numPrimaryKeys + 1 + (this.hasMetaPart() ? 1 : 0)];
        ISerializerDeserializerProvider serdeProvider = metadataProvider.getDataFormat().getSerdeProvider();
        List<Integer> indicators = null;
        if (this.hasMetaPart()) {
            indicators = ((InternalDatasetDetails)this.getDatasetDetails()).getKeySourceIndicator();
        }
        ARecordType itemType = (ARecordType)metadataProvider.findType(this);
        ARecordType metaType = (ARecordType)metadataProvider.findMetaType(this);
        for (int i = 0; i < numPrimaryKeys; ++i) {
            IAType keyType = this.datasetType == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getFieldType((int)i) : (indicators == null || indicators.get(i) == 0 ? itemType.getSubFieldType(partitioningKeys.get(i)) : metaType.getSubFieldType(partitioningKeys.get(i)));
            primaryRecFields[i] = serdeProvider.getSerializerDeserializer((Object)keyType);
            primaryTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
        }
        primaryRecFields[numPrimaryKeys] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)itemType);
        primaryTypeTraits[numPrimaryKeys] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)itemType);
        if (this.hasMetaPart()) {
            primaryRecFields[numPrimaryKeys + 1] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType);
            primaryTypeTraits[numPrimaryKeys + 1] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)itemType);
        }
        return new RecordDescriptor(primaryRecFields, primaryTypeTraits);
    }

    public IBinaryComparatorFactory[] getPrimaryComparatorFactories(MetadataProvider metadataProvider, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        IStorageComponentProvider storageComponentProvider = metadataProvider.getStorageComponentProvider();
        IBinaryComparatorFactoryProvider cmpFactoryProvider = storageComponentProvider.getComparatorFactoryProvider();
        List<List<String>> partitioningKeys = this.getPrimaryKeys();
        int numPrimaryKeys = partitioningKeys.size();
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[numPrimaryKeys];
        List<Integer> indicators = null;
        if (this.hasMetaPart()) {
            indicators = ((InternalDatasetDetails)this.getDatasetDetails()).getKeySourceIndicator();
        }
        for (int i = 0; i < numPrimaryKeys; ++i) {
            IAType keyType = this.datasetType == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getFieldType((int)i) : (indicators == null || indicators.get(i) == 0 ? recordType.getSubFieldType(partitioningKeys.get(i)) : metaType.getSubFieldType(partitioningKeys.get(i)));
            cmpFactories[i] = cmpFactoryProvider.getBinaryComparatorFactory((Object)keyType, true);
        }
        return cmpFactories;
    }

    public IBinaryHashFunctionFactory[] getPrimaryHashFunctionFactories(MetadataProvider metadataProvider) throws AlgebricksException {
        ARecordType recordType = (ARecordType)metadataProvider.findType(this);
        ARecordType metaType = (ARecordType)metadataProvider.findMetaType(this);
        List<List<String>> partitioningKeys = this.getPrimaryKeys();
        int numPrimaryKeys = partitioningKeys.size();
        IBinaryHashFunctionFactory[] hashFuncFactories = new IBinaryHashFunctionFactory[numPrimaryKeys];
        List<Integer> indicators = null;
        if (this.hasMetaPart()) {
            indicators = ((InternalDatasetDetails)this.getDatasetDetails()).getKeySourceIndicator();
        }
        for (int i = 0; i < numPrimaryKeys; ++i) {
            IAType keyType = this.datasetType == DatasetConfig.DatasetType.EXTERNAL ? IndexingConstants.getFieldType((int)i) : (indicators == null || indicators.get(i) == 0 ? recordType.getSubFieldType(partitioningKeys.get(i)) : metaType.getSubFieldType(partitioningKeys.get(i)));
            hashFuncFactories[i] = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory((Object)keyType);
        }
        return hashFuncFactories;
    }

    public int[] getPrimaryBloomFilterFields() {
        List<List<String>> partitioningKeys = this.getPrimaryKeys();
        int numPrimaryKeys = partitioningKeys.size();
        return IntStream.range(0, numPrimaryKeys).toArray();
    }

    public Dataset getTargetDatasetForRebalance(String targetNodeGroupName) {
        return new Dataset(this.dataverseName, this.datasetName, this.recordTypeDataverseName, this.recordTypeName, this.metaTypeDataverseName, this.metaTypeName, targetNodeGroupName, this.compactionPolicyFactory, this.compactionPolicyProperties, this.datasetDetails, this.hints, this.datasetType, DatasetIdFactory.generateAlternatingDatasetId((int)this.datasetId), this.pendingOp, this.rebalanceCount + 1L, this.compressionScheme);
    }

    protected int[] getDatasetPartitions(MetadataProvider metadataProvider) throws AlgebricksException {
        FileSplit[] splitsForDataset = metadataProvider.splitsForIndex(metadataProvider.getMetadataTxnContext(), this, this.getDatasetName());
        int[] partitions = new int[splitsForDataset.length];
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = StoragePathUtil.getPartitionNumFromRelativePath((String)splitsForDataset[i].getPath());
        }
        return partitions;
    }

    public String getCompressionScheme() {
        return this.compressionScheme;
    }

    public DatasetFullyQualifiedName getDatasetFullyQualifiedName() {
        return this.datasetFullyQualifiedName;
    }
}

