/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.accessors;

import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class UTF8StringBinaryHashFunctionFamily
implements IBinaryHashFunctionFamily {
    public static final IBinaryHashFunctionFamily INSTANCE = new UTF8StringBinaryHashFunctionFamily();
    private static final long serialVersionUID = 1L;
    static final int[] primeCoefficents = new int[]{31, 23, 53, 97, 71, 337, 11, 877, 3, 29};

    private UTF8StringBinaryHashFunctionFamily() {
    }

    public IBinaryHashFunction createBinaryHashFunction(int seed) {
        final int coefficient = primeCoefficents[seed % primeCoefficents.length];
        final int r = primeCoefficents[(seed + 1) % primeCoefficents.length];
        return new IBinaryHashFunction(){

            public int hash(byte[] bytes, int offset, int length) {
                return UTF8StringUtil.hash((byte[])bytes, (int)offset, (int)coefficient, (int)r);
            }
        };
    }
}

