/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.openssl;

import java.io.IOException;
import org.python.bouncycastle.openssl.PEMDecryptor;
import org.python.bouncycastle.openssl.PEMDecryptorProvider;
import org.python.bouncycastle.openssl.PEMException;
import org.python.bouncycastle.openssl.PEMKeyPair;
import org.python.bouncycastle.openssl.PEMKeyPairParser;
import org.python.bouncycastle.operator.OperatorCreationException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String string, byte[] byArray, byte[] byArray2, PEMKeyPairParser pEMKeyPairParser) {
        this.dekAlgName = string;
        this.iv = byArray;
        this.keyBytes = byArray2;
        this.parser = pEMKeyPairParser;
    }

    public String getDekAlgName() {
        return this.dekAlgName;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider pEMDecryptorProvider) throws IOException {
        try {
            PEMDecryptor pEMDecryptor = pEMDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(pEMDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new PEMException("cannot create extraction operator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        catch (Exception exception) {
            throw new PEMException("exception processing key pair: " + exception.getMessage(), exception);
        }
    }
}

