#ifndef GEGLQT_NODEVIEWDECLARATIVEITEM_H
#define GEGLQT_NODEVIEWDECLARATIVEITEM_H

/* This file is part of GEGL-QT
 *
 * GEGL-QT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * GEGL-QT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL-QT; if not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (C) 2011 Jon Nordby <jononor@gmail.com>
 */

#include <QtDeclarative>
#include <QtCore>
#include <gegl.h>

#include <gegl-qt/nodeviewoptions.h>

typedef GeglNode * GeglNodePtr;

namespace GeglQt {

class NodeViewImplementation;

class NodeViewDeclarativeItem : public QDeclarativeItem
{
    Q_OBJECT
public:
    explicit NodeViewDeclarativeItem(QDeclarativeItem *parent = 0);
    ~NodeViewDeclarativeItem();

    // QVariant is used so that GeglNode* can be passed through QML
    void setInputNodeVariant(QVariant node);
    QVariant inputNodeVariant();

    void setInputNode(GeglNodePtr node);
    GeglNodePtr inputNode();

    Q_PROPERTY(QVariant inputNode READ inputNodeVariant WRITE setInputNodeVariant NOTIFY inputNodeChanged)

    GeglQt::NodeViewOptions *options() const;
    void setOptions(GeglQt::NodeViewOptions* newOptions);

    Q_PROPERTY(GeglQt::NodeViewOptions * options READ options WRITE setOptions NOTIFY optionsChanged)

    //! reimpl
    void geometryChanged(const QRectF & newGeometry, const QRectF & oldGeometry);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    //! reimpl end

Q_SIGNALS:
    void inputNodeChanged();
    void optionsChanged();

private Q_SLOTS:
    void invalidate(QRectF rect);
    void viewportSizeChangeRequested(QSizeF);

private:
    Q_DISABLE_COPY(NodeViewDeclarativeItem)
    NodeViewImplementation *priv;
};

}
#endif // GEGLQT_NODEVIEWDECLARATIVEITEM_H
