/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFScriptReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.Messages;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.RemoteBreakpoint;

public final class BreakpointTracker {
    private static Map breakpointHandles = new HashMap();
    private static Map handleToLocal = new HashMap();
    private static Map vmToHandles = new HashMap();

    public static RemoteBreakpoint addBreakpoint(CFVirtualMachine vm, Map json) {
        Assert.isNotNull((Object)vm, (String)Messages.BreakpointTracker_2);
        Assert.isNotNull((Object)json, (String)Messages.BreakpointTracker_3);
        Number handle = (Number)json.get("handle");
        if (handle != null) {
            HashSet<Number> handles;
            RemoteBreakpoint bp = (RemoteBreakpoint)breakpointHandles.get(handle);
            if (bp == null) {
                bp = new RemoteBreakpoint(vm, handle, (Map)json.get("location"), (Map)json.get("attributes"), (String)json.get("type"));
                breakpointHandles.put(handle, bp);
            }
            if ((handles = (HashSet<Number>)vmToHandles.get(handle)) == null) {
                handles = new HashSet<Number>();
                vmToHandles.put(vm, handles);
            }
            handles.add(handle);
            return bp;
        }
        return null;
    }

    public static IJavaScriptBreakpoint createLocalBreakpoint(CFVirtualMachine vm, Map json) {
        Assert.isNotNull((Object)vm, (String)Messages.BreakpointTracker_5);
        Assert.isNotNull((Object)json, (String)Messages.BreakpointTracker_6);
        RemoteBreakpoint rb = BreakpointTracker.addBreakpoint(vm, json);
        if (rb != null && rb.isLineBreakpoint()) {
            IFile file;
            IJavaScriptBreakpoint bp = BreakpointTracker.findLocalBreakpoint(rb);
            if (bp != null) {
                return bp;
            }
            CFScriptReference script = rb.vm.findScript(rb.getUrl());
            if (script != null && (file = JavaScriptDebugPlugin.getResolutionManager().getFile((ScriptReference)script)) != null) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("org.eclipse.wst.jsdt.debug.core.type_name", null);
                attributes.put("org.eclipse.wst.jsdt.debug.core.script_path", file.getFullPath().makeAbsolute().toString());
                attributes.put("org.eclipse.wst.jsdt.debug.core.handle", null);
                String condition = rb.getCondition();
                if (condition != null && condition.trim().length() > 0) {
                    attributes.put("org.eclipse.wst.jsdt.debug.core.condition", condition);
                    attributes.put("org.eclipse.wst.jsdt.debug.core.condition_enabled", Boolean.TRUE);
                    attributes.put("org.eclipse.wst.jsdt.debug.core.condition_suspend_on_true", Boolean.TRUE);
                }
                try {
                    bp = JavaScriptDebugModel.createLineBreakpoint((IResource)file, (int)rb.getLine(), (int)-1, (int)-1, attributes, (boolean)true);
                    handleToLocal.put(rb.getHandle(), bp);
                    return bp;
                }
                catch (DebugException debugException) {}
            }
        }
        return null;
    }

    public static final IJavaScriptBreakpoint findLocalBreakpoint(RemoteBreakpoint breakpoint) {
        IFile file;
        Assert.isNotNull((Object)breakpoint, (String)Messages.BreakpointTracker_7);
        IJavaScriptBreakpoint bp = BreakpointTracker.getLocalBreakpoint(breakpoint.getHandle());
        if (bp != null) {
            return bp;
        }
        CFScriptReference script = breakpoint.vm.findScript(breakpoint.getUrl());
        if (script != null && (file = JavaScriptDebugPlugin.getResolutionManager().getFile((ScriptReference)script)) != null) {
            IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
            int i = 0;
            while (i < bps.length) {
                String scriptpath;
                IJavaScriptLineBreakpoint jsbp;
                if (bps[i] instanceof IJavaScriptLineBreakpoint) {
                    jsbp = (IJavaScriptLineBreakpoint)bps[i];
                    try {
                        scriptpath = jsbp.getScriptPath();
                        if (file.getFullPath().isPrefixOf((IPath)new Path(scriptpath)) && breakpoint.getLine() == jsbp.getLineNumber()) {
                            handleToLocal.put(breakpoint.getHandle(), jsbp);
                            return jsbp;
                        }
                    }
                    catch (CoreException coreException) {}
                } else {
                    jsbp = (IJavaScriptBreakpoint)bps[i];
                    try {
                        scriptpath = jsbp.getScriptPath();
                        if (file.getFullPath().isPrefixOf((IPath)new Path(scriptpath))) {
                            handleToLocal.put(breakpoint.getHandle(), jsbp);
                            return jsbp;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        return null;
    }

    public static RemoteBreakpoint findRemoteBreakpoint(IJavaScriptBreakpoint breakpoint) {
        Map.Entry entry;
        Assert.isNotNull((Object)breakpoint, (String)Messages.BreakpointTracker_12);
        Iterator i = handleToLocal.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!breakpoint.equals(entry.getValue())) continue;
            Number handle = (Number)entry.getKey();
            return BreakpointTracker.getBreakpoint(handle);
        }
        i = breakpointHandles.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            try {
                IFile file;
                RemoteBreakpoint rb = (RemoteBreakpoint)entry.getValue();
                CFScriptReference script = rb.vm.findScript(rb.getUrl());
                if (script == null || (file = JavaScriptDebugPlugin.getResolutionManager().getFile((ScriptReference)script)) == null) continue;
                if (breakpoint instanceof IJavaScriptLineBreakpoint) {
                    IJavaScriptLineBreakpoint lb = (IJavaScriptLineBreakpoint)breakpoint;
                    String scriptpath = breakpoint.getScriptPath();
                    if (!file.getFullPath().isPrefixOf((IPath)new Path(scriptpath)) || rb.getLine() != lb.getLineNumber()) continue;
                    handleToLocal.put(rb.handle, breakpoint);
                    return rb;
                }
                String scriptpath = breakpoint.getScriptPath();
                if (!file.getFullPath().isPrefixOf((IPath)new Path(scriptpath))) continue;
                handleToLocal.put(rb.getHandle(), breakpoint);
                return rb;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static final void syncRemoteBreakpoint(RemoteBreakpoint rbreakpoint, IJavaScriptBreakpoint breakpoint) throws CoreException {
        Assert.isNotNull((Object)rbreakpoint, (String)Messages.BreakpointTracker_13);
        Assert.isNotNull((Object)breakpoint, (String)Messages.BreakpointTracker_14);
        rbreakpoint.setEnabled(breakpoint.isEnabled());
        if (breakpoint instanceof IJavaScriptLineBreakpoint) {
            IJavaScriptLineBreakpoint lb = (IJavaScriptLineBreakpoint)breakpoint;
            if (lb.isConditionEnabled()) {
                rbreakpoint.setCondition(lb.getCondition());
            } else {
                rbreakpoint.setCondition(null);
            }
        }
    }

    public static final RemoteBreakpoint getBreakpoint(Number handle) {
        Assert.isNotNull((Object)handle, (String)Messages.BreakpointTracker_0);
        return (RemoteBreakpoint)breakpointHandles.get(handle);
    }

    public static final IJavaScriptBreakpoint getLocalBreakpoint(Number handle) {
        Assert.isNotNull((Object)handle, (String)Messages.BreakpointTracker_10);
        return (IJavaScriptBreakpoint)handleToLocal.get(handle);
    }

    public static RemoteBreakpoint removeBreakpoint(CFVirtualMachine vm, Number handle) {
        Assert.isNotNull((Object)handle, (String)Messages.BreakpointTracker_1);
        RemoteBreakpoint rb = (RemoteBreakpoint)breakpointHandles.remove(handle);
        if (rb != null) {
            HashSet handles = (HashSet)vmToHandles.get(vm);
            if (handles != null) {
                handles.remove(handle);
            }
            handleToLocal.remove(handle);
        }
        return rb;
    }

    public static void removeLocalBreakpoint(CFVirtualMachine vm, Number handle) {
        IJavaScriptBreakpoint jsbp;
        Assert.isNotNull((Object)handle, (String)Messages.BreakpointTracker_9);
        RemoteBreakpoint rb = BreakpointTracker.removeBreakpoint(vm, handle);
        if (rb != null && (jsbp = BreakpointTracker.findLocalBreakpoint(rb)) != null) {
            try {
                jsbp.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    public static RemoteBreakpoint updateBreakpoint(Map json) {
        Assert.isNotNull((Object)json, (String)Messages.BreakpointTracker_4);
        Number handle = (Number)json.get("handle");
        if (handle != null) {
            RemoteBreakpoint bp = (RemoteBreakpoint)breakpointHandles.get(handle);
            if (bp != null) {
                bp.setEnabled(RemoteBreakpoint.getEnabled(json));
                bp.setCondition(RemoteBreakpoint.getCondition(json));
                BreakpointTracker.updateLocalBreakpoint(bp);
            }
            return bp;
        }
        return null;
    }

    public static IJavaScriptBreakpoint updateLocalBreakpoint(RemoteBreakpoint rb) {
        Assert.isNotNull((Object)rb, (String)Messages.BreakpointTracker_8);
        IJavaScriptBreakpoint bp = BreakpointTracker.getLocalBreakpoint(rb.getHandle());
        if (bp instanceof IJavaScriptLineBreakpoint) {
            try {
                Map attributes = bp.getMarker().getAttributes();
                boolean edited = false;
                if (bp.isEnabled() != rb.isEnabled()) {
                    attributes.put("org.eclipse.debug.core.enabled", rb.isEnabled());
                    edited = true;
                }
                String condition = ((IJavaScriptLineBreakpoint)bp).getCondition();
                String rbcondition = rb.getCondition();
                if (rbcondition != null) {
                    if (!rbcondition.equals(condition)) {
                        attributes.put("org.eclipse.wst.jsdt.debug.core.condition", rbcondition);
                        attributes.put("org.eclipse.wst.jsdt.debug.core.condition_enabled", Boolean.TRUE);
                        attributes.put("org.eclipse.wst.jsdt.debug.core.condition_suspend_on_true", Boolean.TRUE);
                        edited = true;
                    }
                } else if (condition != null) {
                    attributes.remove("org.eclipse.wst.jsdt.debug.core.condition");
                    attributes.remove("org.eclipse.wst.jsdt.debug.core.condition_enabled");
                    attributes.remove("org.eclipse.wst.jsdt.debug.core.condition_suspend_on_true");
                    edited = true;
                }
                if (edited) {
                    bp.getMarker().setAttributes(attributes);
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            return bp;
        }
        return null;
    }

    public static void disconnect(CFVirtualMachine vm) {
        Assert.isNotNull((Object)vm, (String)Messages.BreakpointTracker_11);
        HashSet handles = (HashSet)vmToHandles.get(vm);
        if (handles != null) {
            Iterator i = handles.iterator();
            while (i.hasNext()) {
                Number handle = (Number)i.next();
                handleToLocal.remove(handle);
                breakpointHandles.remove(handle);
            }
            vmToHandles.remove(vm);
        }
    }
}

