/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.Action;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.OpenRegistryAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIMainNode;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddBusinessToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddServiceToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.MultipleLinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.NullAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListUDDIBusinessTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListUDDIServicesTool;

public abstract class AddToUDDIPerspectiveAction
extends MultipleLinkAction {
    public AddToUDDIPerspectiveAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID) {
        StringBuffer actionLink = new StringBuffer("wsil/actions/WsilAddToUDDIPerspectiveActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolID);
        actionLink.append('&');
        actionLink.append("viewId");
        actionLink.append('=');
        actionLink.append(viewID);
        actionLink.append('&');
        actionLink.append("viewToolId");
        actionLink.append('=');
        actionLink.append(viewToolID);
        return actionLink.toString();
    }

    public static String getBaseActionLink() {
        return "wsil/actions/WsilAddToUDDIPerspectiveActionJSP.jsp";
    }

    public static Action newAction(HttpServletRequest request, Controller controller) {
        String nodeID = request.getParameter("nodeId");
        NodeManager nodeManager = controller.getWSILPerspective().getNodeManager();
        Tool selectedTool = nodeManager.getNode(Integer.parseInt(nodeID)).getToolManager().getSelectedTool();
        if (selectedTool instanceof ListUDDIServicesTool) {
            return new AddServiceToUDDIPerspectiveAction(controller);
        }
        if (selectedTool instanceof ListUDDIBusinessTool) {
            return new AddBusinessToUDDIPerspectiveAction(controller);
        }
        return new NullAction();
    }

    protected boolean createRegistryInUDDIPerspective(String inquiryAPI, String publishAPI, String registryName) {
        Vector registryNodes = this.getRegistryNodesByInquiryURL(inquiryAPI);
        if (registryNodes != null) {
            Node registryNode = (Node)registryNodes.elementAt(0);
            NodeManager nodeManager = registryNode.getNodeManager();
            nodeManager.setSelectedNodeId(registryNode.getNodeId());
            return true;
        }
        OpenRegistryAction openRegAction = new OpenRegistryAction(this.controller_);
        Hashtable propertyTable = openRegAction.getPropertyTable();
        if (!Validator.validateString(registryName)) {
            return false;
        }
        propertyTable.put("registryName", registryName);
        if (!Validator.validateURL(inquiryAPI)) {
            return false;
        }
        propertyTable.put("inquiryURL", inquiryAPI);
        return openRegAction.run();
    }

    protected Vector getRegistryNodesByInquiryURL(String inquiryURL) {
        Vector<Node> registryNodes = null;
        NodeManager navigatorManager = this.controller_.getUDDIPerspective().getNavigatorManager();
        UDDIMainNode uddiMainNode = (UDDIMainNode)navigatorManager.getRootNode();
        Vector childNodes = uddiMainNode.getChildNodes();
        int i = 0;
        while (i < childNodes.size()) {
            RegistryElement regElement;
            Node childNode = (Node)childNodes.elementAt(i);
            if (childNode instanceof RegistryNode && (regElement = (RegistryElement)childNode.getTreeElement()).getInquiryURL().equals(inquiryURL)) {
                if (registryNodes == null) {
                    registryNodes = new Vector<Node>();
                }
                registryNodes.addElement(childNode);
            }
            ++i;
        }
        return registryNodes;
    }
}

