/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.adapters.IJavaClassAdaptor;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.java.instantiation.IInstantiationInstance;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.InheritanceCycleException;
import org.eclipse.jem.java.Initializer;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaEvent;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.JavaRefFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassImpl
extends EClassImpl
implements JavaClass {
    protected static final TypeKind KIND_EDEFAULT = TypeKind.UNDEFINED_LITERAL;
    protected TypeKind kind = KIND_EDEFAULT;
    protected static final boolean PUBLIC_EDEFAULT = false;
    protected static final int PUBLIC_EFLAG = 1024;
    protected static final boolean FINAL_EDEFAULT = false;
    protected static final int FINAL_EFLAG = 2048;
    protected EList implementsInterfaces = null;
    protected EList classImport = null;
    protected EList packageImports = null;
    protected EList fields = null;
    protected EList methods = null;
    protected EList initializers = null;
    protected EList declaredClasses = null;
    protected JavaClass declaringClass = null;
    protected EList events = null;
    private static final int NOT_REFLECTED = 0;
    private static final int REFLECTED_BASE = 1;
    private static final int REFLECTED_METHODS = 2;
    private static final int REFLECTED_FIELDS = 4;
    protected int reflectionStatus = 0;
    private EList allEvents;
    private EList allProperties;

    protected JavaClassImpl() {
    }

    public EList getEAnnotationsInternal() {
        return super.getEAnnotations();
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.Literals.JAVA_CLASS;
    }

    protected void collectFieldsExtended(List fields) {
        fields.addAll(this.getFields());
        Iterator it = this.getExtendedLookupIterator();
        while (it.hasNext()) {
            ((JavaClassImpl)it.next()).collectFieldsExtended(fields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectMethodsExtended(Map methods, boolean onlyPublic, List excludedClasses, List excludedMethods) {
        Iterator it2 = this.getExtendedLookupIterator();
        while (it2.hasNext()) {
            JavaClassImpl javaClass = (JavaClassImpl)it2.next();
            if (excludedClasses.contains(javaClass)) continue;
            javaClass.collectMethodsExtended(methods, onlyPublic, excludedClasses, excludedMethods);
        }
        ArrayList allMethods = null;
        if (onlyPublic) {
            allMethods = this.getPublicMethods();
        } else {
            allMethods = new ArrayList();
            EList eList = this.getMethods();
            synchronized (eList) {
                allMethods.addAll(this.getMethods());
            }
        }
        for (Method nextMethod : allMethods) {
            if (excludedMethods.contains(nextMethod)) continue;
            methods.put(nextMethod.getMethodElementSignature(), nextMethod);
        }
    }

    public static JavaClass createClassRef(String targetName) {
        return JavaRefFactory.eINSTANCE.createClassRef(targetName);
    }

    protected Method findClassMethodExtended(String methodName, List parameterTypes) {
        Method method = this.getMethod(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        JavaClassImpl mySuper = (JavaClassImpl)this.getSupertype();
        if (mySuper != null) {
            return mySuper.findClassMethodExtended(methodName, parameterTypes);
        }
        return null;
    }

    protected Method findInterfaceMethodExtended(String methodName, List parameterTypes) {
        Method method = this.getMethod(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        EList list = this.getImplementsInterfaces();
        int i = 0;
        while (i < list.size()) {
            JavaClassImpl superInterface = (JavaClassImpl)list.get(i);
            method = superInterface.findInterfaceMethodExtended(methodName, parameterTypes);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public EList getAllSupertypes() {
        this.getESuperTypes();
        return super.getEAllSuperTypes();
    }

    @Override
    public EList getClassImport() {
        this.reflectBase();
        return this.getClassImportGen();
    }

    public EList getEAllOperations() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return super.getEAllOperations();
        }
        if (this.eAllOperations == null) {
            this.eAllOperations = ia.getEAllOperations();
        }
        return this.eAllOperations;
    }

    public EList primGetEAllOperations() {
        return super.getEAllOperations();
    }

    public EList getEOperations() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEOperations();
        }
        return super.getEOperations();
    }

    public EList getEOperationsInternal() {
        return super.getEOperations();
    }

    public EList getEAnnotations() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            adapter.introspectIfNecessary();
        }
        return super.getEAnnotations();
    }

    public EList getEStructuralFeatures() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEStructuralFeatures();
        }
        return super.getEStructuralFeatures();
    }

    public EList getEStructuralFeaturesInternal() {
        return super.getEStructuralFeatures();
    }

    protected Iterator getExtendedLookupIterator() {
        if (this.isInterface()) {
            return this.getImplementsInterfaces().iterator();
        }
        return this.getESuperTypes().iterator();
    }

    @Override
    public Field getField(String fieldName) {
        EList fields = this.getFields();
        int i = 0;
        while (i < fields.size()) {
            Field field = (Field)fields.get(i);
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Field getFieldExtended(String fieldName) {
        Field field = this.getFieldNamed(fieldName);
        if (field != null) {
            return field;
        }
        Iterator it = this.getExtendedLookupIterator();
        while (it.hasNext()) {
            Field result = ((JavaClass)it.next()).getFieldExtended(fieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Field getFieldNamed(String fieldName) {
        return this.getField(fieldName);
    }

    @Override
    public EList getFields() {
        this.reflectFields();
        return this.getFieldsGen();
    }

    @Override
    public List getFieldsExtended() {
        ArrayList fields = new ArrayList();
        this.collectFieldsExtended(fields);
        return fields;
    }

    @Override
    public EList getImplementsInterfaces() {
        this.reflectBase();
        return this.getImplementsInterfacesGen();
    }

    protected synchronized IIntrospectionAdapter getIntrospectionAdapter() {
        return (IIntrospectionAdapter)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)IIntrospectionAdapter.ADAPTER_KEY);
    }

    @Override
    public String getJavaName() {
        return this.getQualifiedName();
    }

    @Override
    public String getSimpleName() {
        return this.primGetName().replace('$', '.');
    }

    @Override
    public JavaPackage getJavaPackage() {
        return (JavaPackage)this.getEPackage();
    }

    @Override
    public Method getMethod(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, (List)this.getMethods());
    }

    protected Method getMethod(String name, List parameterTypes, List methodList) {
        boolean found = false;
        int i = 0;
        while (i < methodList.size()) {
            JavaParameter[] params;
            Method method = (Method)methodList.get(i);
            if (method.getName().equals(name) && (params = method.listParametersWithoutReturn()).length == parameterTypes.size()) {
                found = true;
                int j = 0;
                while (j < params.length) {
                    JavaHelpers jh = (JavaHelpers)params[j].getEType();
                    if (!jh.getQualifiedName().equals(parameterTypes.get(j))) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public List getMethodElementSignatures() {
        List methods = this.getMethodsExtended();
        ArrayList<String> sameNames = new ArrayList<String>();
        ArrayList<String> signatures = new ArrayList<String>(methods.size() + 1);
        signatures.add("*");
        for (Method aMethod : methods) {
            String methodName = aMethod.getName();
            if (sameNames.contains(methodName)) {
                if (!signatures.contains(methodName)) {
                    signatures.add(methodName);
                }
            } else {
                sameNames.add(methodName);
            }
            signatures.add(aMethod.getMethodElementSignature());
        }
        Collections.sort(signatures);
        return signatures;
    }

    @Override
    public Method getMethodExtended(String methodName, List parameterTypes) {
        if (this.isInterface()) {
            return this.findInterfaceMethodExtended(methodName, parameterTypes);
        }
        return this.findClassMethodExtended(methodName, parameterTypes);
    }

    @Override
    public EList getMethods() {
        this.reflectMethods();
        return this.getMethodsGen();
    }

    @Override
    public List getMethodsExtended() {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, false, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return new ArrayList(methods.values());
    }

    @Override
    public List getMethodsExtendedWithFilters(List excludedClasses, List excludedMethods) {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, false, excludedClasses, excludedMethods);
        return new ArrayList(methods.values());
    }

    public String getName() {
        String result = this.primGetName();
        if (result == null && this.eIsProxy()) {
            return JavaRefFactory.eINSTANCE.getTypeName(this.eProxyURI());
        }
        return result;
    }

    @Override
    public List getOnlySpecificMethods(String aMethodNamePrefix, List excludedNames) {
        List methods = this.getMethodsExtended();
        ArrayList<Method> specific = new ArrayList<Method>(methods.size());
        for (Method aMethod : methods) {
            String methodName = aMethod.getName();
            if (aMethodNamePrefix == null || !methodName.startsWith(aMethodNamePrefix) || excludedNames == null || excludedNames.contains(methodName)) continue;
            specific.add(aMethod);
        }
        return specific;
    }

    @Override
    public EList getPackageImports() {
        this.reflectBase();
        return this.getPackageImportsGen();
    }

    @Override
    public JavaDataType getPrimitive() {
        String primitiveName = this.getPrimitiveName();
        if (primitiveName != null) {
            Resource res = this.eResource();
            return (JavaDataType)JavaClassImpl.reflect(primitiveName, res.getResourceSet());
        }
        return null;
    }

    @Override
    public int getPrimitiveID() {
        String myName = this.getQualifiedName();
        if (myName.equals("java.lang.Integer")) {
            return 6;
        }
        if (myName.equals("java.lang.Boolean")) {
            return 1;
        }
        if (myName.equals("java.lang.Byte")) {
            return 3;
        }
        if (myName.equals("java.lang.Short")) {
            return 8;
        }
        if (myName.equals("java.lang.Long")) {
            return 7;
        }
        if (myName.equals("java.lang.Float")) {
            return 5;
        }
        if (myName.equals("java.lang.Double")) {
            return 4;
        }
        if (myName.equals("java.lang.Character")) {
            return 2;
        }
        return 0;
    }

    protected String getPrimitiveName() {
        String myName = this.getQualifiedName();
        if (myName.equals("java.lang.Integer")) {
            return "int";
        }
        if (myName.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (myName.equals("java.lang.Byte")) {
            return "byte";
        }
        if (myName.equals("java.lang.Short")) {
            return "short";
        }
        if (myName.equals("java.lang.Long")) {
            return "long";
        }
        if (myName.equals("java.lang.Float")) {
            return "float";
        }
        if (myName.equals("java.lang.Double")) {
            return "double";
        }
        if (myName.equals("java.lang.Character")) {
            return "char";
        }
        return null;
    }

    @Override
    public Method getPublicMethod(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getPublicMethods());
    }

    @Override
    public Method getPublicMethodExtended(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getPublicMethodsExtended());
    }

    @Override
    public List getPublicMethods() {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        EList theMethods = this.getMethods();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (JavaVisibilityKind.PUBLIC_LITERAL == m.getJavaVisibility()) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    @Override
    public List getPublicMethodsExtended() {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, true, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return new ArrayList(methods.values());
    }

    @Override
    public List getPublicMethodsExtendedNamed(String name) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        List theMethods = this.getPublicMethodsExtended();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (m.getName().equals(name)) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    @Override
    public List getPublicMethodsNamed(String name) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        List theMethods = this.getPublicMethods();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (m.getName().equals(name)) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    @Override
    public String getQualifiedName() {
        String result = null;
        result = this.eIsProxy() ? JavaRefFactory.eINSTANCE.getFullTypeName(this.eProxyURI()) : this.primGetQualifiedName();
        if (result != null) {
            result = result.replace('$', '.');
        }
        return result;
    }

    @Override
    public String getQualifiedNameForReflection() {
        return this.primGetQualifiedName();
    }

    protected synchronized ReadAdaptor getReadAdapter() {
        return (ReadAdaptor)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)"JavaReflection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectBase() {
        ReadAdaptor readAdaptor = null;
        JavaClassImpl javaClassImpl = this;
        synchronized (javaClassImpl) {
            if ((this.reflectionStatus & 1) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = readAdaptor.reflectValuesIfNecessary();
            JavaClassImpl javaClassImpl2 = this;
            synchronized (javaClassImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectFields() {
        ReadAdaptor readAdaptor = null;
        JavaClassImpl javaClassImpl = this;
        synchronized (javaClassImpl) {
            if ((this.reflectionStatus & 4) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = ((IJavaClassAdaptor)((Object)readAdaptor)).reflectFieldsIfNecessary();
            JavaClassImpl javaClassImpl2 = this;
            synchronized (javaClassImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectMethods() {
        ReadAdaptor readAdaptor = null;
        JavaClassImpl javaClassImpl = this;
        synchronized (javaClassImpl) {
            if ((this.reflectionStatus & 2) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = ((IJavaClassAdaptor)((Object)readAdaptor)).reflectMethodsIfNecessary();
            JavaClassImpl javaClassImpl2 = this;
            synchronized (javaClassImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 3;
                }
            }
        }
    }

    @Override
    public JavaClass getSupertype() {
        if (this.isInterface()) {
            return null;
        }
        EList list = this.getESuperTypes();
        return !list.isEmpty() ? (JavaClass)list.get(0) : null;
    }

    @Override
    public JavaClass getWrapper() {
        return this;
    }

    @Override
    public boolean implementsInterface(JavaClass interfaceType) {
        if (this == interfaceType) {
            return true;
        }
        EList implemented = this.getImplementsInterfaces();
        int i = 0;
        while (i < implemented.size()) {
            JavaClass anInterface = (JavaClass)implemented.get(i);
            if (anInterface.implementsInterface(interfaceType)) {
                return true;
            }
            ++i;
        }
        if (this.getSupertype() != null) {
            return this.getSupertype().implementsInterface(interfaceType);
        }
        return false;
    }

    @Override
    public String infoString() {
        EList methods;
        StringBuffer out = new StringBuffer();
        this.reflectBase();
        out.append("Java class: " + this.getQualifiedName() + "\n");
        out.append("  superclass: " + this.getSupertype() + "\n");
        EList fields = this.getFields();
        if (fields.size() > 0) {
            out.append("  Fields:\n");
            int i = 0;
            while (i < fields.size()) {
                Field field = (Field)fields.get(i);
                out.append("    " + ((JavaHelpers)field.getEType()).getJavaName() + " " + field.getName() + "\n");
                ++i;
            }
        }
        if ((methods = this.getMethods()).size() > 0) {
            out.append("  Methods:\n");
            int i = 0;
            while (i < methods.size()) {
                Method method = (Method)methods.get(i);
                method.isStatic();
                if (method.getReturnType() != null) {
                    out.append("    " + method.getReturnType().getJavaName() + " ");
                } else {
                    out.append("    void ");
                }
                out.append(String.valueOf(method.getName()) + "(");
                EList parms = method.getParameters();
                if (parms.size() > 0) {
                    int ii = 0;
                    while (ii < parms.size()) {
                        JavaParameter parm = (JavaParameter)parms.get(ii);
                        out.append(String.valueOf(((JavaHelpers)parm.getEType()).getJavaName()) + " " + parm.getName());
                        if (ii < parms.size() - 1) {
                            out.append(", ");
                        }
                        ++ii;
                    }
                }
                out.append(")\n");
                ++i;
            }
        }
        return out.toString();
    }

    @Override
    public boolean inheritsFrom(JavaClass javaClass) {
        if (this == javaClass) {
            return true;
        }
        if (this.getSupertype() != null) {
            return this.getSupertype().inheritsFrom(javaClass);
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isAssignableFrom(EClassifier aClass) {
        if (aClass instanceof JavaClass) {
            JavaClass theClass = (JavaClass)aClass;
            if (this.getKind() == TypeKind.UNDEFINED_LITERAL || theClass.getKind() == TypeKind.UNDEFINED_LITERAL) {
                return false;
            }
            if (this.getKind() != TypeKind.INTERFACE_LITERAL) {
                if (theClass.getKind() != TypeKind.INTERFACE_LITERAL) {
                    return theClass.inheritsFrom(this);
                }
                return this.getQualifiedName().equals("java.lang.Object");
            }
            return theClass.implementsInterface(this);
        }
        return false;
    }

    @Override
    public boolean isExistingType() {
        JavaReflectionAdaptor adapter = (JavaReflectionAdaptor)this.getReadAdapter();
        if (adapter != null) {
            return adapter.hasReflectionSource();
        }
        return false;
    }

    public boolean isInstance(Object o) {
        return o instanceof IInstantiationInstance ? this.isAssignableFrom((EClassifier)((IInstantiationInstance)o).getJavaType()) : false;
    }

    @Override
    public boolean isInterface() {
        return this.getKind() == TypeKind.INTERFACE_LITERAL;
    }

    @Override
    public boolean isNested() {
        return this.getDeclaringClass() != null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Field[] listFieldExtended() {
        List fields = this.getFieldsExtended();
        Field[] result = new Field[fields.size()];
        fields.toArray(result);
        return result;
    }

    @Override
    public Method[] listMethodExtended() {
        List methods = this.getMethodsExtended();
        Method[] result = new Method[methods.size()];
        methods.toArray(result);
        return result;
    }

    public String primGetName() {
        return super.getName();
    }

    public String primGetQualifiedName() {
        JavaPackage pack;
        String result = "";
        result = this.eIsProxy() ? JavaRefFactory.eINSTANCE.getFullTypeName(this.eProxyURI()) : ((pack = this.getJavaPackage()) != null && pack.getPackageName().length() != 0 ? String.valueOf(pack.getPackageName()) + "." + ((JavaRefFactoryImpl)JavaRefFactory.eINSTANCE).primGetTypeName(this.primGetName()) : this.getName());
        return result;
    }

    public static JavaHelpers reflect(String aQualifiedName, EObject relatedObject) {
        return JavaRefFactory.eINSTANCE.reflectType(aQualifiedName, relatedObject);
    }

    public static JavaHelpers reflect(String aQualifiedName, ResourceSet set) {
        return JavaRefFactory.eINSTANCE.reflectType(aQualifiedName, set);
    }

    public static JavaHelpers reflect(String aPackageName, String aClassName, ResourceSet set) {
        return JavaRefFactory.eINSTANCE.reflectType(aPackageName, aClassName, set);
    }

    @Override
    public void setSupertype(JavaClass aJavaClass) throws InheritanceCycleException {
        this.validateSupertype(aJavaClass);
        EList s = super.getESuperTypes();
        s.clear();
        if (aJavaClass != null) {
            s.add(aJavaClass);
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 30: {
                return ((InternalEList)this.getFields()).basicAdd((Object)otherEnd, msgs);
            }
            case 31: {
                return ((InternalEList)this.getMethods()).basicAdd((Object)otherEnd, msgs);
            }
            case 32: {
                return ((InternalEList)this.getInitializers()).basicAdd((Object)otherEnd, msgs);
            }
            case 33: {
                return ((InternalEList)this.getDeclaredClasses()).basicAdd((Object)otherEnd, msgs);
            }
            case 34: {
                if (this.declaringClass != null) {
                    msgs = ((InternalEObject)this.declaringClass).eInverseRemove((InternalEObject)this, 33, JavaClass.class, msgs);
                }
                return this.basicSetDeclaringClass((JavaClass)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 30: {
                return ((InternalEList)this.getFields()).basicRemove((Object)otherEnd, msgs);
            }
            case 31: {
                return ((InternalEList)this.getMethods()).basicRemove((Object)otherEnd, msgs);
            }
            case 32: {
                return ((InternalEList)this.getInitializers()).basicRemove((Object)otherEnd, msgs);
            }
            case 33: {
                return ((InternalEList)this.getDeclaredClasses()).basicRemove((Object)otherEnd, msgs);
            }
            case 34: {
                return this.basicSetDeclaringClass(null, msgs);
            }
            case 36: {
                return ((InternalEList)this.getEvents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 24: {
                return this.getKind();
            }
            case 25: {
                return this.isPublic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 26: {
                return this.isFinal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                return this.getImplementsInterfaces();
            }
            case 28: {
                return this.getClassImport();
            }
            case 29: {
                return this.getPackageImports();
            }
            case 30: {
                return this.getFields();
            }
            case 31: {
                return this.getMethods();
            }
            case 32: {
                return this.getInitializers();
            }
            case 33: {
                return this.getDeclaredClasses();
            }
            case 34: {
                if (resolve) {
                    return this.getDeclaringClass();
                }
                return this.basicGetDeclaringClass();
            }
            case 35: {
                if (resolve) {
                    return this.getJavaPackage();
                }
                return this.basicGetJavaPackage();
            }
            case 36: {
                return this.getEvents();
            }
            case 37: {
                return this.getAllEvents();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 24: {
                this.setKind((TypeKind)((Object)newValue));
                return;
            }
            case 25: {
                this.setPublic((Boolean)newValue);
                return;
            }
            case 26: {
                this.setFinal((Boolean)newValue);
                return;
            }
            case 27: {
                this.getImplementsInterfaces().clear();
                this.getImplementsInterfaces().addAll((Collection)newValue);
                return;
            }
            case 28: {
                this.getClassImport().clear();
                this.getClassImport().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.getPackageImports().clear();
                this.getPackageImports().addAll((Collection)newValue);
                return;
            }
            case 30: {
                this.getFields().clear();
                this.getFields().addAll((Collection)newValue);
                return;
            }
            case 31: {
                this.getMethods().clear();
                this.getMethods().addAll((Collection)newValue);
                return;
            }
            case 32: {
                this.getInitializers().clear();
                this.getInitializers().addAll((Collection)newValue);
                return;
            }
            case 33: {
                this.getDeclaredClasses().clear();
                this.getDeclaredClasses().addAll((Collection)newValue);
                return;
            }
            case 34: {
                this.setDeclaringClass((JavaClass)newValue);
                return;
            }
            case 36: {
                this.getEvents().clear();
                this.getEvents().addAll((Collection)newValue);
                return;
            }
            case 37: {
                this.getAllEvents().clear();
                this.getAllEvents().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 24: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 25: {
                this.setPublic(false);
                return;
            }
            case 26: {
                this.setFinal(false);
                return;
            }
            case 27: {
                this.getImplementsInterfaces().clear();
                return;
            }
            case 28: {
                this.getClassImport().clear();
                return;
            }
            case 29: {
                this.getPackageImports().clear();
                return;
            }
            case 30: {
                this.getFields().clear();
                return;
            }
            case 31: {
                this.getMethods().clear();
                return;
            }
            case 32: {
                this.getInitializers().clear();
                return;
            }
            case 33: {
                this.getDeclaredClasses().clear();
                return;
            }
            case 34: {
                this.setDeclaringClass(null);
                return;
            }
            case 36: {
                this.getEvents().clear();
                return;
            }
            case 37: {
                this.getAllEvents().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 24: {
                return this.kind != KIND_EDEFAULT;
            }
            case 25: {
                return (this.eFlags & 0x400) != 0;
            }
            case 26: {
                return (this.eFlags & 0x800) != 0;
            }
            case 27: {
                return this.implementsInterfaces != null && !this.implementsInterfaces.isEmpty();
            }
            case 28: {
                return this.classImport != null && !this.classImport.isEmpty();
            }
            case 29: {
                return this.packageImports != null && !this.packageImports.isEmpty();
            }
            case 30: {
                return this.fields != null && !this.fields.isEmpty();
            }
            case 31: {
                return this.methods != null && !this.methods.isEmpty();
            }
            case 32: {
                return this.initializers != null && !this.initializers.isEmpty();
            }
            case 33: {
                return this.declaredClasses != null && !this.declaredClasses.isEmpty();
            }
            case 34: {
                return this.declaringClass != null;
            }
            case 35: {
                return this.basicGetJavaPackage() != null;
            }
            case 36: {
                return this.events != null && !this.events.isEmpty();
            }
            case 37: {
                return !this.getAllEvents().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    protected void validateSupertype(JavaClass aJavaClass) throws InheritanceCycleException {
        if (!this.isValidSupertype(aJavaClass)) {
            throw new InheritanceCycleException(this, aJavaClass);
        }
    }

    @Override
    public boolean isValidSupertype(JavaClass aJavaClass) {
        if (aJavaClass != null) {
            if (this.equals(aJavaClass)) {
                return false;
            }
            return this.extendedIsValidSupertype(this.getSubtypes(), aJavaClass);
        }
        return true;
    }

    private boolean extendedIsValidSupertype(List subtypes, JavaClass aJavaClass) {
        if (!this.basicIsValidSupertype(subtypes, aJavaClass)) {
            return false;
        }
        int i = 0;
        while (i < subtypes.size()) {
            JavaClass subtype = (JavaClass)subtypes.get(i);
            if (!subtype.isValidSupertype(aJavaClass)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean basicIsValidSupertype(List subtypes, JavaClass aJavaClass) {
        int i = 0;
        while (i < subtypes.size()) {
            JavaClass subtype = (JavaClass)subtypes.get(i);
            if (subtype.equals(aJavaClass)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List getSubtypes() {
        return this.getESuperAdapter().getSubclasses();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getQualifiedName() + ")";
    }

    @Override
    public TypeKind getKind() {
        this.reflectBase();
        return this.getKindGen();
    }

    @Override
    public void setKind(TypeKind newKind) {
        TypeKind oldKind = this.kind;
        TypeKind typeKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldKind, (Object)this.kind));
        }
    }

    @Override
    public boolean isPublic() {
        this.reflectBase();
        return this.isPublicGen();
    }

    @Override
    public void setPublic(boolean newPublic) {
        boolean oldPublic;
        boolean bl = oldPublic = (this.eFlags & 0x400) != 0;
        this.eFlags = newPublic ? (this.eFlags |= 0x400) : (this.eFlags &= 0xFFFFFBFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, oldPublic, newPublic));
        }
    }

    @Override
    public boolean isFinal() {
        this.reflectBase();
        return this.isFinalGen();
    }

    @Override
    public void setFinal(boolean newFinal) {
        boolean oldFinal;
        boolean bl = oldFinal = (this.eFlags & 0x800) != 0;
        this.eFlags = newFinal ? (this.eFlags |= 0x800) : (this.eFlags &= 0xFFFFF7FF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 26, oldFinal, newFinal));
        }
    }

    public TypeKind getKindGen() {
        return this.kind;
    }

    public boolean isPublicGen() {
        return (this.eFlags & 0x400) != 0;
    }

    public boolean isFinalGen() {
        return (this.eFlags & 0x800) != 0;
    }

    @Override
    public EList getInitializers() {
        if (this.initializers == null) {
            this.initializers = new EObjectContainmentWithInverseEList(Initializer.class, (InternalEObject)this, 32, 1);
        }
        return this.initializers;
    }

    @Override
    public void setDeclaringClass(JavaClass newDeclaringClass) {
        if (newDeclaringClass != this.declaringClass) {
            NotificationChain msgs = null;
            if (this.declaringClass != null) {
                msgs = ((InternalEObject)this.declaringClass).eInverseRemove((InternalEObject)this, 33, JavaClass.class, msgs);
            }
            if (newDeclaringClass != null) {
                msgs = ((InternalEObject)newDeclaringClass).eInverseAdd((InternalEObject)this, 33, JavaClass.class, msgs);
            }
            if ((msgs = this.basicSetDeclaringClass(newDeclaringClass, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 34, (Object)newDeclaringClass, (Object)newDeclaringClass));
        }
    }

    @Override
    public JavaClass getDeclaringClass() {
        if (this.declaringClass != null && this.declaringClass.eIsProxy()) {
            InternalEObject oldDeclaringClass = (InternalEObject)this.declaringClass;
            this.declaringClass = (JavaClass)this.eResolveProxy(oldDeclaringClass);
            if (this.declaringClass != oldDeclaringClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 34, (Object)oldDeclaringClass, (Object)this.declaringClass));
            }
        }
        return this.declaringClass;
    }

    public JavaClass basicGetDeclaringClass() {
        return this.declaringClass;
    }

    public NotificationChain basicSetDeclaringClass(JavaClass newDeclaringClass, NotificationChain msgs) {
        JavaClass oldDeclaringClass = this.declaringClass;
        this.declaringClass = newDeclaringClass;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 34, (Object)oldDeclaringClass, (Object)newDeclaringClass);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public EList getDeclaredClasses() {
        this.reflectBase();
        return this.getDeclaredClassesGen();
    }

    public EList getDeclaredClassesGen() {
        if (this.declaredClasses == null) {
            this.declaredClasses = new EObjectWithInverseResolvingEList(JavaClass.class, (InternalEObject)this, 33, 34);
        }
        return this.declaredClasses;
    }

    @Override
    public EList getProperties() {
        return this.getEStructuralFeatures();
    }

    @Override
    public EList getEvents() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEvents();
        }
        return this.getEventsGen();
    }

    public EList getEventsGen() {
        if (this.events == null) {
            this.events = new EObjectContainmentEList(JavaEvent.class, (InternalEObject)this, 36);
        }
        return this.events;
    }

    @Override
    public EList getAllEvents() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return ECollections.EMPTY_ELIST;
        }
        this.allEvents = ia.getAllEvents();
        return this.allEvents;
    }

    public EList getAllEventsGen() {
        return this.allEvents;
    }

    @Override
    public EList getAllProperties() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return ECollections.EMPTY_ELIST;
        }
        this.allProperties = ia.getAllProperties();
        return this.allProperties;
    }

    public EList getAllPropertiesGen() {
        return this.allProperties;
    }

    public EList getImplementsInterfacesGen() {
        if (this.implementsInterfaces == null) {
            this.implementsInterfaces = new EObjectResolvingEList(JavaClass.class, (InternalEObject)this, 27){
                private static final long serialVersionUID = 1L;

                public Object get(int index) {
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().get(index);
                    }
                    return super.get(index);
                }

                public void clear() {
                    super.clear();
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().clear();
                    }
                }

                public Object remove(int index) {
                    Object result = super.remove(index);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().remove(index);
                    }
                    return result;
                }

                public boolean removeAll(Collection collection) {
                    boolean result = super.removeAll(collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().removeAll(collection);
                    }
                    return result;
                }

                public void add(int index, Object object) {
                    super.add(index, object);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().add(index, object);
                    }
                }

                public boolean add(Object object) {
                    boolean result = super.add(object);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().add(object);
                    }
                    return result;
                }

                public boolean addAll(Collection collection) {
                    boolean result = super.addAll(collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().addAll(collection);
                    }
                    return result;
                }

                public boolean addAll(int index, Collection collection) {
                    boolean result = super.addAll(index, collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().addAll(index, collection);
                    }
                    return result;
                }
            };
        }
        return this.implementsInterfaces;
    }

    private EList getInterfaceSuperTypes() {
        return super.getESuperTypes();
    }

    public EList getClassImportGen() {
        if (this.classImport == null) {
            this.classImport = new EObjectResolvingEList(JavaClass.class, (InternalEObject)this, 28);
        }
        return this.classImport;
    }

    public EList getEAllSuperTypes() {
        this.reflectBase();
        return super.getEAllSuperTypes();
    }

    public EList getESuperTypes() {
        this.reflectBase();
        return super.getESuperTypes();
    }

    public EList primGetESuperTypes() {
        return super.getESuperTypes();
    }

    public EList getPackageImportsGen() {
        if (this.packageImports == null) {
            this.packageImports = new EObjectResolvingEList(JavaPackage.class, (InternalEObject)this, 29);
        }
        return this.packageImports;
    }

    public EList getFieldsGen() {
        if (this.fields == null) {
            this.fields = new EObjectContainmentWithInverseEList(Field.class, (InternalEObject)this, 30, 15);
        }
        return this.fields;
    }

    public EList getMethodsGen() {
        if (this.methods == null) {
            this.methods = new EObjectContainmentWithInverseEList(Method.class, (InternalEObject)this, 31, 24);
        }
        return this.methods;
    }

    public JavaPackage getJavaPackageGen() {
        JavaPackage javaPackage = this.basicGetJavaPackage();
        return javaPackage != null && javaPackage.eIsProxy() ? (JavaPackage)this.eResolveProxy((InternalEObject)javaPackage) : javaPackage;
    }

    public JavaPackage basicGetJavaPackage() {
        return this.getJavaPackage();
    }

    public String toStringGen() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (kind: ");
        result.append((Object)this.kind);
        result.append(", public: ");
        result.append((this.eFlags & 0x400) != 0);
        result.append(", final: ");
        result.append((this.eFlags & 0x800) != 0);
        result.append(')');
        return result.toString();
    }

    public synchronized void setReflected(boolean aBoolean) {
        if (!aBoolean) {
            this.reflectionStatus = 0;
        }
    }

    @Override
    public Object getReflectionType() {
        JavaReflectionAdaptor ja = (JavaReflectionAdaptor)this.getReadAdapter();
        return ja != null ? ja.getReflectionSource() : null;
    }

    public EList<EObject> eContents() {
        if (this.eContents == null) {
            this.eContents = (EList)EContentsEList.createEContentsEList((EObject)this);
        }
        return this.eContents;
    }

    public EList<EObject> eCrossReferences() {
        if (this.eCrossReferences == null) {
            this.eCrossReferences = (EList)ECrossReferenceEList.createECrossReferenceEList((EObject)this);
        }
        return this.eCrossReferences;
    }
}

