/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.handler;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.vorto.codegen.ui.handler.ExtensionMetaData;
import org.osgi.framework.Bundle;

public class PopulateGeneratorsMenu
extends CompoundContributionItem {
    private static final String CLASS = "class";
    private static final String MENU_LABEL = "menuLabel";

    public PopulateGeneratorsMenu() {
    }

    public PopulateGeneratorsMenu(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<CommandContributionItem> contributionItems = new ArrayList<CommandContributionItem>();
        List<IConfigurationElement> registeredGenerators = this.getAllRegisteredGeneratorNames();
        for (IConfigurationElement aGenerator : registeredGenerators) {
            CommandContributionItem commandForGenerator = this.constructCommandForGenerator(aGenerator);
            if (commandForGenerator == null) continue;
            contributionItems.add(commandForGenerator);
        }
        return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
    }

    private CommandContributionItem constructCommandForGenerator(IConfigurationElement aGenerator) {
        return this.constructCommandForGenerator(this.populateExtensionMetaData(aGenerator));
    }

    private CommandContributionItem constructCommandForGenerator(ExtensionMetaData extensionMetaData) {
        String extensionIdentifier = extensionMetaData.getExtensionIdentifier();
        if (StringUtils.isNotEmpty((CharSequence)extensionIdentifier)) {
            CommandContributionItemParameter generatorCommand = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.eclipse.vorto.codegen.dynamic.menu.contribution.item.id", "org.eclipse.vorto.codegen.generator.command.id", 0);
            generatorCommand.label = extensionMetaData.getMenuLabel();
            String iconPath = extensionMetaData.getIconPath();
            Bundle bundle = Platform.getBundle((String)extensionMetaData.getGeneratorPluginId());
            if (iconPath == null) {
                iconPath = "icons/generate.gif";
                bundle = Platform.getBundle((String)"org.eclipse.vorto.codegen.ui");
            }
            Path path = new Path(iconPath);
            generatorCommand.icon = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)path, null));
            generatorCommand.parameters = new HashMap();
            generatorCommand.parameters.put("org.eclipse.vorto.codegen.generator.commandParameter", extensionIdentifier);
            CommandContributionItem generatorContributionItem = new CommandContributionItem(generatorCommand);
            return generatorContributionItem;
        }
        return null;
    }

    private ExtensionMetaData populateExtensionMetaData(IConfigurationElement confiurationElement) {
        ExtensionMetaData extensionMetaData = new ExtensionMetaData();
        extensionMetaData.setGeneratorPluginId(confiurationElement.getContributor().getName());
        extensionMetaData.setClassName(confiurationElement.getAttribute(CLASS));
        extensionMetaData.setExtensionIdentifier(confiurationElement.getDeclaringExtension().getUniqueIdentifier());
        extensionMetaData.setMenuLabel(confiurationElement.getAttribute(MENU_LABEL));
        extensionMetaData.setIconPath(confiurationElement.getAttribute("icon"));
        return extensionMetaData;
    }

    private List<IConfigurationElement> getAllRegisteredGeneratorNames() {
        IConfigurationElement[] generators;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> registersGenerators = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = generators = extensionRegistry.getConfigurationElementsFor("org.eclipse.vorto.codegen.org_eclipse_vorto_codegen_Generators");
        int n = generators.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            registersGenerators.add(e);
            ++n2;
        }
        return registersGenerators;
    }
}

