/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.markdown.templates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownEntityTemplate;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownEnumTemplate;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownFunctionBlockTemplate;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class MarkdownInformationModelTemplate
implements ITemplate<InformationModel> {
    private MarkdownFunctionBlockTemplate fbTemplate;
    private MarkdownEntityTemplate entityTemplate;
    private MarkdownEnumTemplate enumTemplate;

    public MarkdownInformationModelTemplate(MarkdownFunctionBlockTemplate fbTemplate, MarkdownEntityTemplate entityTemplate, MarkdownEnumTemplate enumTemplate) {
        this.fbTemplate = fbTemplate;
        this.entityTemplate = entityTemplate;
        this.enumTemplate = enumTemplate;
    }

    public String getContent(InformationModel im, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"# Information Model *");
        String _name = im.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"*");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"### Unique Identification");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<tr><td>Name:</td><td>");
        String _name_1 = im.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"</td></tr>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<tr><td>Namespace:</td><td>");
        String _namespace = im.getNamespace();
        _builder.append((Object)_namespace, "\t");
        _builder.append((Object)"</td></tr>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<tr><td>Version:</td><td>");
        String _version = im.getVersion();
        _builder.append((Object)_version, "\t");
        _builder.append((Object)"</td></tr>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</table>");
        _builder.newLine();
        _builder.append((Object)"### Description");
        _builder.newLine();
        String _description = im.getDescription();
        _builder.append((Object)_description, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"### Functionblock Overview");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"<tr><td>Functionblock</td><td>Name</td><td>Description</td></tr>");
        _builder.newLine();
        EList _properties = im.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"<tr><td>");
            FunctionblockModel _type = fbProperty.getType();
            String _name_2 = _type.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"</td><td>");
            String _name_3 = fbProperty.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)"</td><td>");
            String _description_1 = fbProperty.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.append((Object)"</td></tr>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Functionblocks");
        _builder.newLine();
        EList _properties_1 = im.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            FunctionblockModel _type_1 = fbProperty_1.getType();
            String _content = this.fbTemplate.getContent(_type_1, invocationContext);
            _builder.append((Object)_content, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"# Entities");
        _builder.newLine();
        EList _properties_2 = im.getProperties();
        for (FunctionblockProperty fbProperty_2 : _properties_2) {
            FunctionblockModel _type_2 = fbProperty_2.getType();
            FunctionBlock _functionblock = _type_2.getFunctionblock();
            EList _referencedEntities = Utils.getReferencedEntities((FunctionBlock)_functionblock);
            for (Entity type : _referencedEntities) {
                String _content_1 = this.entityTemplate.getContent(type, invocationContext);
                _builder.append((Object)_content_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"# Enums");
        _builder.newLine();
        EList _properties_3 = im.getProperties();
        for (FunctionblockProperty fbProperty_3 : _properties_3) {
            FunctionblockModel _type_3 = fbProperty_3.getType();
            FunctionBlock _functionblock_1 = _type_3.getFunctionblock();
            EList _referencedEnums = Utils.getReferencedEnums((FunctionBlock)_functionblock_1);
            for (Enum type_1 : _referencedEnums) {
                String _content_2 = this.enumTemplate.getContent(type_1, invocationContext);
                _builder.append((Object)_content_2, "");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        return _builder.toString();
    }
}

