/*******************************************************************************
 * Copyright (c) 2015 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *   
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *   
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.ios.templates

import org.eclipse.vorto.codegen.api.IFileTemplate
import org.eclipse.vorto.codegen.api.InvocationContext
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel

/**
 * @author Alexander Edelmann - Robert Bosch (SEA) Pte. Ltd.
 */
class CoreBluetoothDetectionTemplate implements IFileTemplate<InformationModel> {
	
	override getFileName(InformationModel context) {
		return context.name+"Delegate.swift"
	}
	
	override getPath(InformationModel context) {
		return ""
	}
	
	override getContent(InformationModel context,InvocationContext invocationContext) {
'''
//Generated by Vorto

import Foundation
import CoreBluetooth

let «context.name»UUID = NSUserDefaults.standardUserDefaults().stringForKey("«context.name»_uuid")

class «context.name»Delegate: NSObject, CBPeripheralDelegate, CBCentralManagerDelegate {
	
	var «context.name»Peripheral : CBPeripheral!
	
	var found = false
	
	var detectionCompleted:(()->Void)?
	
	override init() {}
	
	func found() -> Bool {
        return self.found
    }
    
    func centralManagerDidUpdateState(central: CBCentralManager!) {
        if central.state == CBCentralManagerState.PoweredOn {
            // Scan for peripherals if BLE is turned on
            central.scanForPeripheralsWithServices(nil, options: nil)
            println("Searching for «context.displayname» devices ...")
        }
        else {
            // Can have different conditions for all states if needed - show generic alert for now
            println("Bluetooth switched off or not initialized")
        }
    }
    
     // Check out the discovered peripherals to find «context.displayname»
    func centralManager(central: CBCentralManager!, didDiscoverPeripheral peripheral: CBPeripheral!, advertisementData: [NSObject : AnyObject]!, RSSI: NSNumber!) {
        
        var deviceUUID  = peripheral.identifier.UUIDString
        
        if «context.name»DeviceReader.found(advertisementData) == true {
            
            println("Scanning...Detected \(deviceUUID)")
            
            if  «context.name»UUID == deviceUUID {
                self.«context.name»Peripheral = peripheral
                self.«context.name»Peripheral.delegate = self
                println("«context.displayname» found.")
                self.found = true
            }
            
            central.connectPeripheral(peripheral, options: nil)
            
            if (self.found()) {
                self.detectionCompleted!()
            }
        }
    }
    
    // Discover services of the peripheral
    func centralManager(central: CBCentralManager!, didConnectPeripheral peripheral: CBPeripheral!) {
        println("Discovering peripheral services")
        peripheral.discoverServices(nil)
    }
    
    // If disconnected, start searching again
    func centralManager(central: CBCentralManager!, didDisconnectPeripheral peripheral: CBPeripheral!, error: NSError!) {
        println("«context.displayname» disconnected")
        self.found = false
        central.scanForPeripheralsWithServices(nil, options: nil)
    }
    
    // Check if the service discovered is valid i.e. one of the following:
    «FOR fbProperty : context.properties»
    // «fbProperty.type.displayname»
    «ENDFOR»
    func peripheral(peripheral: CBPeripheral!, didDiscoverServices error: NSError!) {
        for service in peripheral.services {
            let thisService = service as! CBService
            
            if «context.name»Device.validService(thisService) {
                // Discover characteristics of all valid services
                peripheral.discoverCharacteristics(nil, forService: thisService)
            }
        }
    }
    
    // Get data values when they are updated
    func peripheral(peripheral: CBPeripheral!, didUpdateValueForCharacteristic characteristic: CBCharacteristic!, error: NSError!) {
        
        «FOR fbProperty : context.properties»
        if characteristics.UUID == «fbProperty.type.name»DataUUID {
        	«FOR operation : fbProperty.type.functionblock.operations»
        	«IF operation.returnType != null»
        	let «fbProperty.type.name»_value = «context.name»Device.«operation.name»(characteristics.value)
        	// do something with the value
        	«ENDIF»
        	«ENDFOR»
        }
        «ENDFOR»
    }
}
'''
	}
	
}