/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.pcap;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapOldPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapOldFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PcapPacketTest {
    private static final String EXPECTED_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String EXPECTED_GMT_TIME = "2005-07-04 09:33:52.829";
    private static final Map<String, String> EXPECTED_FIELDS;
    private static final String EXPECTED_TOSTRING;
    private ByteBuffer fHeader;
    private ByteBuffer fPayload;

    static {
        String captureTime = "";
        try {
            SimpleDateFormat gmtFormat = new SimpleDateFormat(EXPECTED_DATE_FORMAT);
            gmtFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date gmtDate = gmtFormat.parse(EXPECTED_GMT_TIME);
            SimpleDateFormat defaultFormat = new SimpleDateFormat(EXPECTED_DATE_FORMAT);
            captureTime = defaultFormat.format(gmtDate);
        }
        catch (ParseException e) {
            Assert.fail((String)"failed to parse date");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Packet Capture 36: 75 bytes on wire, 75 bytes captured.\n");
        sb.append("Arrival time: " + captureTime + ".277.000\n");
        sb.append("Ethernet II, Source: 00:e0:ed:01:6e:bd, Destination: 00:30:54:00:34:56, Type: Internet Protocol Version 4 (0x0800)\n");
        sb.append("Internet Protocol Version 4, Source: 192.168.1.2, Destination: 192.168.1.1\n");
        sb.append("Version: 4, Identification: 0x69aa, Header Length: 20 bytes, Total Length: 61 bytes\n");
        sb.append("Differentiated Services Code Point: 0x00; Explicit Congestion Notification: 0x00\n");
        sb.append("Flags: 0x00 (Don't have more fragments), Fragment Offset: 0\n");
        sb.append("Time to live: 128\n");
        sb.append("Protocol: 17\n");
        sb.append("Header Checksum: 0x4db2\n");
        sb.append("User Datagram Protocol, Source Port: 2719, Destination Port: 53, Length: 41, Checksum: 19038\n");
        sb.append("Payload: ed d4 01 00 00 01 00 00 00 00 00 00 03 66 74 70 07 65 63 69 74 65 6c 65 03 63 6f 6d 00 00 01 00 01");
        EXPECTED_TOSTRING = sb.toString();
        EXPECTED_FIELDS = ImmutableMap.of((Object)"Frame", (Object)"36", (Object)"Frame Length", (Object)"75 bytes", (Object)"Capture Length", (Object)"75 bytes", (Object)"Capture Time", (Object)(String.valueOf(captureTime) + ".277.000"));
    }

    @Before
    public void initialize() {
        this.fHeader = ByteBuffer.allocate(16);
        this.fHeader.put((byte)-128);
        this.fHeader.put((byte)2);
        this.fHeader.put((byte)-55);
        this.fHeader.put((byte)66);
        this.fHeader.put((byte)93);
        this.fHeader.put((byte)-89);
        this.fHeader.put((byte)12);
        this.fHeader.put((byte)0);
        this.fHeader.put((byte)75);
        this.fHeader.put((byte)0);
        this.fHeader.put((byte)0);
        this.fHeader.put((byte)0);
        this.fHeader.put((byte)75);
        this.fHeader.put((byte)0);
        this.fHeader.put((byte)0);
        this.fHeader.put((byte)0);
        this.fHeader.flip();
        this.fPayload = ByteBuffer.allocate(75);
        this.fPayload.order(ByteOrder.BIG_ENDIAN);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)48);
        this.fPayload.put((byte)84);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)52);
        this.fPayload.put((byte)86);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)-32);
        this.fPayload.put((byte)-19);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)110);
        this.fPayload.put((byte)-67);
        this.fPayload.put((byte)8);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)69);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)61);
        this.fPayload.put((byte)105);
        this.fPayload.put((byte)-86);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)-128);
        this.fPayload.put((byte)17);
        this.fPayload.put((byte)77);
        this.fPayload.put((byte)-78);
        this.fPayload.put((byte)-64);
        this.fPayload.put((byte)-88);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)2);
        this.fPayload.put((byte)-64);
        this.fPayload.put((byte)-88);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)10);
        this.fPayload.put((byte)-97);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)53);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)41);
        this.fPayload.put((byte)74);
        this.fPayload.put((byte)94);
        this.fPayload.put((byte)-19);
        this.fPayload.put((byte)-44);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)3);
        this.fPayload.put((byte)102);
        this.fPayload.put((byte)116);
        this.fPayload.put((byte)112);
        this.fPayload.put((byte)7);
        this.fPayload.put((byte)101);
        this.fPayload.put((byte)99);
        this.fPayload.put((byte)105);
        this.fPayload.put((byte)116);
        this.fPayload.put((byte)101);
        this.fPayload.put((byte)108);
        this.fPayload.put((byte)101);
        this.fPayload.put((byte)3);
        this.fPayload.put((byte)99);
        this.fPayload.put((byte)111);
        this.fPayload.put((byte)109);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)1);
        this.fPayload.put((byte)0);
        this.fPayload.put((byte)1);
        this.fPayload.flip();
    }

    @Test
    public void CompletePcapPacketTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_UDP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile file = trace.getTrace();){
            file.seekPacket(36L);
            PcapPacket packet = file.parseNextPacket();
            if (packet == null) {
                Assert.fail((String)"CompletePcapPacketTest has failed!");
                return;
            }
            Assert.assertEquals((Object)PcapProtocol.PCAP, (Object)packet.getProtocol());
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.PCAP));
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.TCP));
            Assert.assertTrue((boolean)packet.validate());
            PcapOldPacket expected = new PcapOldPacket((PcapOldFile)file, this.fHeader, this.fPayload, 36L);
            Assert.assertEquals((long)expected.hashCode(), (long)packet.hashCode());
            Assert.assertEquals((Object)expected, (Object)packet);
            Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
            Assert.assertEquals((Object)EXPECTED_TOSTRING, (Object)packet.toString());
            Assert.assertEquals((Object)"Frame 36: 75 bytes on wire, 75 bytes captured", (Object)packet.getLocalSummaryString());
            Assert.assertEquals((Object)"Source Port: 2719, Destination Port: 53", (Object)packet.getGlobalSummaryString());
            Assert.assertEquals((Object)new PcapEndpoint(packet, true), (Object)packet.getSourceEndpoint());
            Assert.assertEquals((Object)new PcapEndpoint(packet, false), (Object)packet.getDestinationEndpoint());
            ByteBuffer payload = packet.getPayload();
            if (payload == null) {
                Assert.fail((String)"CompletePcapPacketTest has failed!");
                return;
            }
            Assert.assertEquals((long)36L, (long)packet.getIndex());
            Assert.assertEquals((long)75L, (long)packet.getOriginalLength());
            Assert.assertEquals((long)75L, (long)packet.getIncludedLength());
            Assert.assertEquals((long)1120469632829277L, (long)packet.getTimestamp());
            Assert.assertFalse((boolean)packet.isTruncated());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

