/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCLabel;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.junit.Assert;
import org.junit.Test;

public abstract class KernelTimeGraphViewTestBase
extends KernelTestBase {
    private static final int VERTICAL_SCROLLBAR_INDEX = 0;
    private static final int HORIZONTAL_SCROLLBAR_INDEX = 1;
    protected static final String SEPARATOR = "";

    protected abstract SWTBotView getViewBot();

    protected abstract List<String> getToolbarTooltips();

    protected abstract List<String> getLegendValues();

    protected abstract SWTBotView openView();

    @Test
    public void testToolbar() {
        List buttons = this.getViewBot().getToolbarButtons();
        List<String> tooltipsExpected = this.getToolbarTooltips();
        ArrayList<String> tooltips = new ArrayList<String>();
        for (SWTBotToolbarButton button : buttons) {
            tooltips.add(button.getToolTipText());
            Assert.assertTrue((String)(String.valueOf(button.getText()) + " enabled"), (boolean)button.isEnabled());
            Assert.assertTrue((String)(String.valueOf(button.getText()) + " visible"), (boolean)button.isVisible());
        }
        Assert.assertEquals(tooltipsExpected, tooltips);
    }

    @Test
    public void testLegend() {
        List<String> labelValues = this.getLegendValues();
        SWTBotToolbarButton legendButton = this.getViewBot().toolbarButton("Show Legend");
        legendButton.click();
        SWTBotShell shell = fBot.shell("Legend");
        shell.activate();
        SWTBot bot = shell.bot();
        int i = 0;
        while (i < labelValues.size()) {
            SWTBotCLabel label = bot.clabel(i);
            Assert.assertNotNull((Object)label);
            Assert.assertEquals((Object)labelValues.get(i), (Object)label.getText());
            ++i;
        }
        bot.button("OK").click();
    }

    @Test
    public void testOpenCloseOpen() {
        SWTBotView viewBot = this.openView();
        SWTBotTimeGraph tgBot = new SWTBotTimeGraph(viewBot.bot());
        Map<String, List<String>> before = KernelTimeGraphViewTestBase.getItemNames(tgBot);
        viewBot.close();
        viewBot = this.openView();
        tgBot = new SWTBotTimeGraph(viewBot.bot());
        Map<String, List<String>> after = KernelTimeGraphViewTestBase.getItemNames(tgBot);
        Assert.assertEquals(before, after);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testVerticalScrollbar() {
        SWTBotView viewBot = this.openView();
        @NonNull List sliders = viewBot.bot().widgets(WidgetOfType.widgetOfType(Slider.class));
        Assert.assertTrue((String)("The view has " + sliders.size() + " sliders"), (sliders.size() >= 2 ? 1 : 0) != 0);
        Rectangle sliderRect = KernelTimeGraphViewTestBase.getBounds((Control)sliders.get(0));
        Rectangle timegraphRect = KernelTimeGraphViewTestBase.getBounds((Control)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class)));
        Assert.assertEquals((String)"Incorrect vertical slider start position", (long)timegraphRect.width, (long)sliderRect.x);
        Assert.assertEquals((String)"Incorrect vertical slider height", (long)timegraphRect.height, (long)sliderRect.height);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testHorizontalScrollbar() {
        SWTBotView viewBot = this.openView();
        @NonNull List sliders = viewBot.bot().widgets(WidgetOfType.widgetOfType(Slider.class));
        Assert.assertTrue((String)("The view has " + sliders.size() + " sliders"), (sliders.size() >= 2 ? 1 : 0) != 0);
        Rectangle sliderRect = KernelTimeGraphViewTestBase.getBounds((Control)sliders.get(1));
        SWTBotTimeGraph tgBot = new SWTBotTimeGraph((TimeGraphControl)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class)));
        Rectangle timegraphRect = KernelTimeGraphViewTestBase.getBounds((Control)viewBot.bot().widget(WidgetOfType.widgetOfType(TimeGraphControl.class)));
        Assert.assertEquals((String)"Incorrect horizontal slider start position", (long)(timegraphRect.x + tgBot.getNameSpace()), (long)sliderRect.x);
    }

    private static @NonNull Map<String, List<String>> getItemNames(SWTBotTimeGraph tgBot) {
        HashMap<String, List<String>> returnStructure = new HashMap<String, List<String>>();
        SWTBotTimeGraphEntry[] sWTBotTimeGraphEntryArray = tgBot.getEntries();
        int n = sWTBotTimeGraphEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTimeGraphEntry element = sWTBotTimeGraphEntryArray[n2];
            returnStructure.put(element.getText(), Arrays.stream(element.getEntries()).map(tgEntry -> tgEntry.getText()).collect(Collectors.toList()));
            ++n2;
        }
        return returnStructure;
    }

    private static Rectangle getBounds(Control widget) {
        return (Rectangle)UIThreadRunnable.syncExec(() -> widget.getBounds());
    }
}

