/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core.pathmatch;

import org.apache.tools.ant.types.selectors.TokenizedPath;
import org.apache.tools.ant.types.selectors.TokenizedPattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatcher;

public class ResourceMatchers {
    public static ResourceMatcher ANY = new ResourceMatcher(){

        public String toString() {
            return "ResourceMatcher(ANY)";
        }

        @Override
        public boolean matches(IResource resource) {
            return true;
        }
    };

    public static ResourceMatcher commaSeparatedPaths(String text) {
        if ((text = text.trim()).isEmpty()) {
            return ANY;
        }
        String[] paths = text.split(",");
        if (paths.length == 1) {
            return ResourceMatchers.path(paths[0].trim());
        }
        ResourceMatcher[] matchers = new ResourceMatcher[paths.length];
        int i = 0;
        while (i < matchers.length) {
            String pattern = paths[i].trim();
            if (!pattern.isEmpty()) {
                matchers[i] = ResourceMatchers.path(pattern);
            }
            ++i;
        }
        return ResourceMatchers.either(matchers);
    }

    private static ResourceMatcher either(final ResourceMatcher ... matchers) {
        return new ResourceMatcher(){

            public String toString() {
                StringBuilder buf = new StringBuilder("ResourceMatcher(");
                int i = 0;
                while (i < matchers.length) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(matchers[i]);
                    ++i;
                }
                buf.append(")");
                return buf.toString();
            }

            @Override
            public boolean matches(IResource resource) {
                ResourceMatcher[] resourceMatcherArray = matchers;
                int n = matchers.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceMatcher m = resourceMatcherArray[n2];
                    if (m != null && m.matches(resource)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    private static ResourceMatcher path(String _pat) {
        if (!_pat.startsWith("/") && !_pat.startsWith("**/")) {
            _pat = "**/" + _pat;
        }
        final String pat = _pat;
        final TokenizedPattern matcher = new TokenizedPattern(pat);
        return new ResourceMatcher(){

            public String toString() {
                return pat;
            }

            @Override
            public boolean matches(IResource resource) {
                TokenizedPath path = new TokenizedPath(resource.getFullPath().toString());
                return matcher.matchPath(path, true);
            }
        };
    }
}

