/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.eval;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.eval.ITechniquesItem;

public class TechniquesItemImpl
implements ITechniquesItem {
    private static final Pattern TECH_ID = Pattern.compile("(\\p{Alpha}+)(\\d+)");
    private static final List<String> prefixArray = Arrays.asList("G", "H", "C", "SCR", "SVR", "SM", "T", "ARIA", "FLASH", "F");
    private String guideline = "";
    private String id = "";
    private String url = "";

    public String getGuidelineName() {
        return this.guideline;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setGuidelineName(String string) {
        this.guideline = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public int compareTo(ITechniquesItem iTechniquesItem) {
        int n;
        Matcher matcher = TECH_ID.matcher(this.getId());
        matcher.matches();
        String string = matcher.group(1);
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = prefixArray.indexOf(string);
        if (n3 < 0) {
            System.err.println("Unknown techniques prefix: " + string);
            n3 = 999;
        }
        Matcher matcher2 = TECH_ID.matcher(iTechniquesItem.getId());
        matcher2.matches();
        String string2 = matcher2.group(1);
        int n4 = Integer.parseInt(matcher2.group(2));
        int n5 = prefixArray.indexOf(string2);
        if (n5 < 0) {
            System.err.println("Unknown techniques prefix: " + string2);
            n5 = 999;
        }
        if ((n = new Integer(n3).compareTo(new Integer(n5))) == 0) {
            n = new Integer(n2).compareTo(new Integer(n4));
        }
        return n;
    }
}

