/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.mediator.IACTFReportGenerator;
import org.eclipse.actf.mediator.Mediator;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.WaitForBrowserReadyHandler;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.ui.util.DialogSave;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventHandler;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventListener;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.internal.BlindVisualizerExtension;
import org.eclipse.actf.visualization.blind.ui.internal.BlindVisualizationBrowser;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.blind.ui.internal.SaveReportBlind;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.html.util.VisualizeReportUtil;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.eval.problem.ReportUtil;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartControlBlind
implements IHighlightElementListener {
    private static final String ABOUT_BLANK = "about:blank";
    public static final String BLIND_REPORT_FILE = "report.htm";
    private IBlindVisualizer[] blindVizualizers = BlindVisualizerExtension.getVisualizers();
    private BlindVisualizationBrowser _blindBrowser;
    private boolean _canSave = false;
    private PageData _pageData;
    private String maxReachingTimeS = "";
    private PageEvaluation _pageEval;
    private Document resultDoc;
    private Shell _shell;
    private String targetUrl;
    private Mediator mediator = Mediator.getInstance();
    private IVisualizationView vizView;
    private IEvaluationResult checkResult = new EvaluationResultBlind();
    private HashMap<String, WaitExecSyncEventListener> eventhandlerHolder = new HashMap();
    private static final String LISTENER_KEY = "browser";

    public PartControlBlind(IVisualizationView iVisualizationView, Composite composite) {
        this.vizView = iVisualizationView;
        this._shell = composite.getShell();
        this._blindBrowser = new BlindVisualizationBrowser(composite);
        this._blindBrowser.setBrowserSilent();
    }

    public void doSave(boolean bl) {
        String string = DialogSave.open((Shell)this._shell, (int)4, (String)this.targetUrl, (String)".csv");
        if (string != null) {
            Object object;
            IEvaluationResult iEvaluationResult = (IEvaluationResult)Mediator.getInstance().getReport((IACTFReportGenerator)this.vizView);
            if (iEvaluationResult != null) {
                try {
                    object = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(string)), "Shift_JIS");
                    PrintWriter printWriter = new PrintWriter((Writer)object);
                    ReportUtil reportUtil = new ReportUtil();
                    reportUtil.setPrintWriter(printWriter);
                    reportUtil.writeFirstLine();
                    iEvaluationResult.accept((IProblemItemVisitor)reportUtil);
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
            if (bl) {
                if (this.resultDoc == null || string == null) {
                    return;
                }
                if (string.toLowerCase().endsWith(".csv")) {
                    string = string.substring(0, string.length() - 3);
                }
                string = string.concat(".html");
                object = String.valueOf(string.substring(string.lastIndexOf("\\") + 1, string.lastIndexOf("."))) + "/";
                object = ((String)object).replace(' ', '_');
                this.saveReportFile(string, (String)object, true);
            }
        }
    }

    public int doVisualize() {
        return this.doVisualize(true);
    }

    public int doVisualize(boolean bl) {
        IModelService iModelService = ModelServiceUtils.getActiveModelService();
        int n = -1;
        if (iModelService == null) {
            IEditorPart iEditorPart = ModelServiceUtils.reopenInACTFBrowser();
            if (iEditorPart instanceof IModelServiceHolder) {
                iModelService = ((IModelServiceHolder)iEditorPart).getModelService();
                WaitForBrowserReadyHandler waitForBrowserReadyHandler = new WaitForBrowserReadyHandler((IWebBrowserACTF)iModelService, 30.0, false, new Runnable(){

                    public void run() {
                        PartControlBlind.this.eventhandlerHolder.remove(PartControlBlind.LISTENER_KEY);
                        PartControlBlind.this.doVisualize();
                        PlatformUIUtil.showView((String)"org.eclipse.actf.visualization.blind.ui.views.BlindView");
                    }
                });
                this.eventhandlerHolder.put(LISTENER_KEY, new WaitExecSyncEventListener((WaitExecSyncEventHandler)waitForBrowserReadyHandler));
                n = 0;
                return 0;
            }
            return n;
        }
        String string = "";
        this.targetUrl = iModelService.getURL();
        this.maxReachingTimeS = "";
        this.checkResult = new EvaluationResultBlind();
        this.mediator.setReport((IACTFReportGenerator)this.vizView, (IACTFReport)this.checkResult);
        this._blindBrowser.navigate(ABOUT_BLANK);
        this._canSave = false;
        this.vizView.setStatusMessage(Messages.BlindView_Now_preparing);
        IBlindVisualizer[] iBlindVisualizerArray = this.blindVizualizers;
        int n2 = this.blindVizualizers.length;
        int n3 = 0;
        while (n3 < n2) {
            IBlindVisualizer iBlindVisualizer = iBlindVisualizerArray[n3];
            if (iBlindVisualizer.setModelService(iModelService)) {
                iBlindVisualizer.setVisualizationView(this.vizView);
                n = iBlindVisualizer.visualize();
                this._pageData = iBlindVisualizer.getPageData();
                this.checkResult = iBlindVisualizer.getEvaluationResult();
                this.resultDoc = iBlindVisualizer.getResultDocument();
                this.maxReachingTimeS = iBlindVisualizer.getMaxReachingTime();
                string = iBlindVisualizer.getResultFile().getAbsolutePath();
                if (n > -1) {
                    this.vizView.setStatusMessage(Messages.BlindView_Now_rendering);
                    CreateReport createReport = new CreateReport(this.checkResult, new File(BlindVizResourceUtil.getTempDirectory(), BLIND_REPORT_FILE));
                    if (bl) {
                        this._blindBrowser.navigate(string);
                        this._shell.getDisplay().asyncExec((Runnable)createReport);
                    } else {
                        this._blindBrowser.navigate(ABOUT_BLANK);
                        this._shell.getDisplay().syncExec((Runnable)createReport);
                    }
                    this._canSave = true;
                } else {
                    this.checkResult.setProblemList(new ArrayList());
                    this._blindBrowser.navigate(ABOUT_BLANK);
                    CreateReport createReport = new CreateReport(this.checkResult);
                    this._shell.getDisplay().syncExec((Runnable)createReport);
                }
                return n;
            }
            ++n3;
        }
        System.out.println("not supported: " + iModelService.getID() + " " + iModelService.getCurrentMIMEType());
        return -1;
    }

    public void saveReportFile(String string, String string2, boolean bl) {
        if (this._canSave) {
            this.vizView.setStatusMessage(Messages.BlindView_saving_file);
            SaveReportBlind.saveReport((Document)this.resultDoc.cloneNode(true), this.mediator.getReport((IACTFReportGenerator)this.vizView), string, string2, this.maxReachingTimeS, this._pageEval, bl);
            this.vizView.setStatusMessage(Messages.BlindView_end_saving_file);
        }
    }

    private void execScript(String string) {
        this._blindBrowser.execScript(string);
    }

    public void clearHighlight() {
        this._blindBrowser.clearHighlight();
    }

    protected IEvaluationResult getCheckResult() {
        return this.checkResult;
    }

    public void highlight(List<HighlightTargetId> list) {
        if (list != null) {
            switch (list.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.execScript("setHighlight(" + list.get(0).getStartId() + "," + list.get(0).getEndId() + ");");
                    break;
                }
                default: {
                    Iterator<HighlightTargetId> iterator = list.iterator();
                    StringBuffer stringBuffer = new StringBuffer(512);
                    StringBuffer stringBuffer2 = new StringBuffer(512);
                    HighlightTargetId highlightTargetId = iterator.next();
                    stringBuffer.append(highlightTargetId.getStartId());
                    stringBuffer2.append(highlightTargetId.getEndId());
                    while (iterator.hasNext()) {
                        highlightTargetId = iterator.next();
                        stringBuffer.append("," + highlightTargetId.getStartId());
                        stringBuffer2.append("," + highlightTargetId.getEndId());
                    }
                    String string = "setHighlight2(new Array(" + stringBuffer.toString() + "), new Array(" + stringBuffer2.toString() + "));";
                    this.execScript(string);
                }
            }
        }
    }

    public boolean isBrowserModeSupported(IModelServiceHolder iModelServiceHolder) {
        if (iModelServiceHolder != null) {
            IBlindVisualizer[] iBlindVisualizerArray = this.blindVizualizers;
            int n = this.blindVizualizers.length;
            int n2 = 0;
            while (n2 < n) {
                IBlindVisualizer iBlindVisualizer = iBlindVisualizerArray[n2];
                if (iBlindVisualizer.setModelService(iModelServiceHolder.getModelService()) && iBlindVisualizer.getClass().getName().startsWith("org.eclipse.actf.visualization.blind.")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private class CreateReport
    extends Thread {
        IEvaluationResult _checkResult;
        File targetFile;

        CreateReport(IEvaluationResult iEvaluationResult, File file) {
            this._checkResult = iEvaluationResult;
            this.targetFile = file;
        }

        CreateReport(IEvaluationResult iEvaluationResult) {
            this._checkResult = iEvaluationResult;
            this.targetFile = null;
        }

        public void run() {
            PartControlBlind.this._pageEval = new PageEvaluation(this._checkResult.getProblemList(), PartControlBlind.this._pageData);
            if (this.targetFile == null) {
                PartControlBlind.this.checkResult.setSummaryReportUrl(PartControlBlind.ABOUT_BLANK);
                PartControlBlind.this.checkResult.setSummaryReportText("");
            } else {
                VisualizeReportUtil.createReport((File)this.targetFile, (PageEvaluation)PartControlBlind.this._pageEval);
                this._checkResult.setSummaryReportUrl(this.targetFile.getAbsolutePath());
                this._checkResult.setSummaryReportText(PartControlBlind.this._pageEval.getSummary());
                this._checkResult.setLineStyleListener((LineStyleListener)PageEvaluation.getHighLightStringListener());
            }
            if (this._checkResult instanceof EvaluationResultBlind) {
                ((EvaluationResultBlind)this._checkResult).setPageEvaluation(PartControlBlind.this._pageEval);
            }
            PartControlBlind.this._shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PartControlBlind.this.mediator.setReport((IACTFReportGenerator)PartControlBlind.this.vizView, (IACTFReport)CreateReport.this._checkResult);
                    PartControlBlind.this.vizView.setStatusMessage(Messages.BlindView_Done);
                }
            });
        }
    }
}

