/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import java.util.HashSet;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.ElementImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.TextImpl;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.actf.util.win32.comclutch.ComPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTerms
extends AbstractTerms {
    private static HTMLTerms instance;
    private static HashSet<String> headingTags;
    private static HashSet<String> listItemTags;
    private static HashSet<String> blockTags;
    private static HashSet<String> listTopTags;
    private static final HashSet<String> reducibleElementNames;

    static {
        headingTags = new HashSet();
        headingTags.add("H1".intern());
        headingTags.add("H2".intern());
        headingTags.add("H3".intern());
        headingTags.add("H4".intern());
        headingTags.add("H5".intern());
        headingTags.add("H6".intern());
        listItemTags = new HashSet();
        listItemTags.add("LI".intern());
        listItemTags.add("DT".intern());
        listTopTags = new HashSet();
        listTopTags.add("UL".intern());
        listTopTags.add("OL".intern());
        listTopTags.add("DL".intern());
        blockTags = new HashSet();
        blockTags.add("H1".intern());
        blockTags.add("H2".intern());
        blockTags.add("H3".intern());
        blockTags.add("H4".intern());
        blockTags.add("H5".intern());
        blockTags.add("H6".intern());
        blockTags.add("B".intern());
        blockTags.add("STRONG".intern());
        blockTags.add("DIV".intern());
        blockTags.add("SPAN".intern());
        blockTags.add("P".intern());
        blockTags.add("FONT".intern());
        reducibleElementNames = new HashSet();
        reducibleElementNames.add("FONT".intern());
        reducibleElementNames.add("BASEFONT".intern());
        reducibleElementNames.add("S".intern());
        reducibleElementNames.add("STRIKE".intern());
        reducibleElementNames.add("U".intern());
        reducibleElementNames.add("EM".intern());
        reducibleElementNames.add("STRONG".intern());
        reducibleElementNames.add("SPAN".intern());
        reducibleElementNames.add("VAR".intern());
        reducibleElementNames.add("CODE".intern());
        reducibleElementNames.add("CITE".intern());
        reducibleElementNames.add("ABBR".intern());
        reducibleElementNames.add("ACRONYM".intern());
        reducibleElementNames.add("Q".intern());
        reducibleElementNames.add("B".intern());
        reducibleElementNames.add("BIG".intern());
        reducibleElementNames.add("I".intern());
        reducibleElementNames.add("SMALL".intern());
        reducibleElementNames.add("TT".intern());
        reducibleElementNames.add("SUB".intern());
        reducibleElementNames.add("SUP".intern());
        reducibleElementNames.add("WBR".intern());
    }

    public boolean isAlterable(IEvalTarget iEvalTarget) {
        return this.isImage(iEvalTarget);
    }

    public static HTMLTerms getInstance() {
        if (instance == null) {
            instance = new HTMLTerms();
        }
        return instance;
    }

    public boolean isValidNode(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        String string;
        return !(iEvalTarget instanceof ElementImpl) || !"HEAD".equals(string = (elementImpl = (ElementImpl)iEvalTarget).getLocalName()) && !"MAP".equals(string);
    }

    public boolean isVisibleNode(IEvalTarget iEvalTarget) {
        return true;
    }

    public boolean isMultilineEdit(IEvalTarget iEvalTarget) {
        TextImpl textImpl;
        Node node;
        if (iEvalTarget instanceof ElementImpl) {
            ElementImpl elementImpl = (ElementImpl)iEvalTarget;
            String string = elementImpl.getLocalName();
            if ("TEXTAREA".equals(string)) {
                return true;
            }
        } else if (iEvalTarget instanceof TextImpl && (node = (textImpl = (TextImpl)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return this.isMultilineEdit((IEvalTarget)node);
        }
        return false;
    }

    public boolean isSelectOption(IEvalTarget iEvalTarget) {
        TextImpl textImpl;
        Node node;
        if (iEvalTarget instanceof ElementImpl) {
            ElementImpl elementImpl = (ElementImpl)iEvalTarget;
            String string = elementImpl.getLocalName();
            if ("OPTION".equals(string)) {
                return true;
            }
        } else if (iEvalTarget instanceof TextImpl && (node = (textImpl = (TextImpl)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return this.isSelectOption((IEvalTarget)node);
        }
        return false;
    }

    public boolean isInputable(IEvalTarget iEvalTarget) {
        TextImpl textImpl;
        Node node;
        if (iEvalTarget instanceof ElementImpl) {
            ElementImpl elementImpl = (ElementImpl)iEvalTarget;
            String string = elementImpl.getLocalName();
            if ("INPUT".equals(string)) {
                ElementImpl.InputType inputType = elementImpl.getInputType();
                if (inputType == null) {
                    return false;
                }
                return inputType.isEdit() || inputType.isPassword() || inputType.isFileEdit() || inputType.isCheckBox() || inputType.isRadio();
            }
            if ("TEXTAREA".equals(string)) {
                return true;
            }
        } else if (iEvalTarget instanceof TextImpl && (node = (textImpl = (TextImpl)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isInputable().eval((IEvalTarget)node);
        }
        return false;
    }

    public boolean isCombobox(IEvalTarget iEvalTarget) {
        TextImpl textImpl;
        Node node;
        if (iEvalTarget instanceof ElementImpl) {
            ElementImpl elementImpl = (ElementImpl)iEvalTarget;
            String string = elementImpl.getLocalName();
            if ("SELECT".equals(string)) {
                return true;
            }
        } else if (iEvalTarget instanceof TextImpl && (node = (textImpl = (TextImpl)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isSelectable().eval((IEvalTarget)node);
        }
        return false;
    }

    public boolean isMultiSelectable(IEvalTarget iEvalTarget) {
        TextImpl textImpl;
        Node node;
        if (iEvalTarget instanceof ElementImpl) {
            ElementImpl elementImpl = (ElementImpl)iEvalTarget;
            String string = elementImpl.getLocalName();
            if ("SELECT".equals(string)) {
                return (Boolean)Helper.get(elementImpl.getINode(), "multiple");
            }
        } else if (iEvalTarget instanceof TextImpl && (node = (textImpl = (TextImpl)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isMultiSelectable().eval((IEvalTarget)node);
        }
        return false;
    }

    public boolean isClickable(IEvalTarget iEvalTarget) {
        Node node;
        Object object;
        if (iEvalTarget instanceof TextImpl && (object = ((NodeImpl)(node = (TextImpl)iEvalTarget)).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isClickable().eval((IEvalTarget)object);
        }
        if (iEvalTarget instanceof ElementImpl) {
            ElementImpl.InputType inputType;
            node = (ElementImpl)iEvalTarget;
            object = ((NodeImpl)node).getLocalName();
            String string = (String)Helper.get(((NodeImpl)node).getINode(), "href");
            if (("A".equals(object) || "AREA".equals(object)) && string != null && string.length() > 0) {
                return true;
            }
            if ("BUTTON".equals(object) || "OPTION".equals(object)) {
                return true;
            }
            if ("INPUT".equals(object) && (inputType = ((ElementImpl)node).getInputType()) != null) {
                return inputType.isClickable();
            }
            if (Helper.hasProperty(((NodeImpl)node).getINode(), "onclick")) {
                return true;
            }
        }
        if (iEvalTarget instanceof Node && (object = (node = (Node)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isClickable().eval((IEvalTarget)object);
        }
        return false;
    }

    public boolean isLink(IEvalTarget iEvalTarget) {
        Node node;
        Object object;
        if (iEvalTarget instanceof TextImpl && (object = ((NodeImpl)(node = (TextImpl)iEvalTarget)).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isLink().eval((IEvalTarget)object);
        }
        if (iEvalTarget instanceof ElementImpl) {
            node = (ElementImpl)iEvalTarget;
            object = ((NodeImpl)node).getLocalName();
            String string = (String)Helper.get(((NodeImpl)node).getINode(), "href");
            if (("A".equals(object) || "AREA".equals(object)) && string != null && string.length() > 0) {
                return true;
            }
        }
        if (iEvalTarget instanceof Node && (object = (node = (Node)iEvalTarget).getParentNode()) instanceof IEvalTarget) {
            return Vocabulary.isLink().eval((IEvalTarget)object);
        }
        return false;
    }

    public boolean isCheckbox(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        ElementImpl.InputType inputType;
        if (iEvalTarget instanceof ElementImpl && (inputType = (elementImpl = (ElementImpl)iEvalTarget).getInputType()) != null) {
            return inputType.isCheckBox();
        }
        return false;
    }

    public boolean isChecked(IEvalTarget iEvalTarget) {
        Object object;
        if (iEvalTarget instanceof ElementImpl && (object = Helper.get(((ElementImpl)iEvalTarget).getINode(), "checked")) != null) {
            return (Boolean)object;
        }
        return false;
    }

    public boolean isRadio(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        ElementImpl.InputType inputType;
        if (iEvalTarget instanceof ElementImpl && (inputType = (elementImpl = (ElementImpl)iEvalTarget).getInputType()) != null) {
            return inputType.isRadio();
        }
        return false;
    }

    public boolean isTextbox(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        ElementImpl.InputType inputType;
        if (iEvalTarget instanceof ElementImpl && (inputType = (elementImpl = (ElementImpl)iEvalTarget).getInputType()) != null) {
            return inputType.isEdit();
        }
        return false;
    }

    public boolean isPassword(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        ElementImpl.InputType inputType;
        if (iEvalTarget instanceof ElementImpl && (inputType = (elementImpl = (ElementImpl)iEvalTarget).getInputType()) != null) {
            return inputType.isPassword();
        }
        return false;
    }

    public boolean isButton(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        ElementImpl.InputType inputType;
        if (iEvalTarget instanceof ElementImpl && (inputType = (elementImpl = (ElementImpl)iEvalTarget).getInputType()) != null) {
            return inputType.isButton();
        }
        return false;
    }

    private boolean isInTags(IEvalTarget iEvalTarget, HashSet<String> hashSet) {
        ElementImpl elementImpl;
        String string;
        return iEvalTarget instanceof ElementImpl && hashSet.contains((string = (elementImpl = (ElementImpl)iEvalTarget).getNodeName()).intern());
    }

    public boolean isListTop(IEvalTarget iEvalTarget) {
        if (this.isInTags(iEvalTarget, listTopTags) && iEvalTarget instanceof Element) {
            Element element = (Element)iEvalTarget;
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node = nodeList.item(n2);
                if (node instanceof IEvalTarget && this.isListItem((IEvalTarget)node)) {
                    ++n;
                }
                ++n2;
            }
            if (n > 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isListItem(IEvalTarget iEvalTarget) {
        return this.isListItemJumpPoint(iEvalTarget);
    }

    public boolean isFileEdit(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        ElementImpl.InputType inputType;
        if (iEvalTarget instanceof ElementImpl && (inputType = (elementImpl = (ElementImpl)iEvalTarget).getInputType()) != null) {
            return inputType.isFileEdit();
        }
        return false;
    }

    public boolean isEmbeddedObject(IEvalTarget iEvalTarget) {
        ElementImpl elementImpl;
        String string;
        return iEvalTarget instanceof ElementImpl && ("EMBED".equals(string = (elementImpl = (ElementImpl)iEvalTarget).getLocalName()) || "OBJECT".equals(string));
    }

    public boolean isImage(IEvalTarget iEvalTarget) {
        if (!(iEvalTarget instanceof ElementImpl)) {
            return false;
        }
        ElementImpl elementImpl = (ElementImpl)iEvalTarget;
        String string = elementImpl.getLocalName();
        return "IMG".equals(string);
    }

    public boolean hasContent(IEvalTarget iEvalTarget) {
        if (this.isMultilineEdit(iEvalTarget) && iEvalTarget instanceof Element) {
            return !this.hasContent((IEvalTarget)((Element)iEvalTarget).getFirstChild());
        }
        if (this.isInputable(iEvalTarget)) {
            return true;
        }
        if (this.isListTop(iEvalTarget)) {
            return true;
        }
        return super.hasContent(iEvalTarget);
    }

    public boolean isReducible(IEvalTarget iEvalTarget) {
        if (!(iEvalTarget instanceof ElementImpl)) {
            return false;
        }
        ElementImpl elementImpl = (ElementImpl)iEvalTarget;
        String string = elementImpl.getLocalName().intern();
        return reducibleElementNames.contains(string);
    }

    public boolean isVisitedLink(IEvalTarget iEvalTarget) {
        if (!(iEvalTarget instanceof INodeEx)) {
            return false;
        }
        INodeEx iNodeEx = (INodeEx)iEvalTarget;
        String string = iNodeEx.getLinkURI();
        if (string == null) {
            return false;
        }
        return ComPlugin.getDefault().getBrowserHistory().isVisited(string);
    }

    public boolean isHeadingJumpPoint(IEvalTarget iEvalTarget) {
        return this.isJumpPoint(iEvalTarget, headingTags);
    }

    public boolean isListItemJumpPoint(IEvalTarget iEvalTarget) {
        return this.isJumpPoint(iEvalTarget, listItemTags);
    }

    public boolean isBlockJumpPointF(IEvalTarget iEvalTarget) {
        return this.isJumpPoint(iEvalTarget, blockTags, 3) || this.isJumpPoint2(iEvalTarget, headingTags, 3);
    }

    public boolean isBlockJumpPointB(IEvalTarget iEvalTarget) {
        return this.isJumpPoint(iEvalTarget, blockTags, 3) || this.isJumpPoint2(iEvalTarget, headingTags, 3);
    }

    private boolean isJumpPoint(IEvalTarget iEvalTarget, HashSet<String> hashSet) {
        return this.isJumpPoint(iEvalTarget, hashSet, 100);
    }

    private boolean isJumpPoint(IEvalTarget iEvalTarget, HashSet<String> hashSet, int n) {
        Node node;
        Object object;
        if (n <= 0) {
            return false;
        }
        if (iEvalTarget instanceof Element && hashSet.contains(((String)(object = (node = (Element)iEvalTarget).getLocalName())).intern())) {
            return true;
        }
        if (!(iEvalTarget instanceof Node)) {
            return false;
        }
        node = (Node)iEvalTarget;
        object = node.getPreviousSibling();
        while (object != null) {
            if (this.hasText((Node)object)) {
                return false;
            }
            object = object.getPreviousSibling();
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return false;
        }
        if (node2 instanceof IEvalTarget) {
            return this.isJumpPoint((IEvalTarget)node2, hashSet, n - 1);
        }
        return false;
    }

    private boolean isJumpPoint2(IEvalTarget iEvalTarget, HashSet<String> hashSet, int n) {
        Node node;
        Object object;
        if (n <= 0) {
            return false;
        }
        if (iEvalTarget instanceof Element && hashSet.contains(((String)(object = (node = (Element)iEvalTarget).getLocalName())).intern())) {
            return true;
        }
        if (!(iEvalTarget instanceof Node)) {
            return false;
        }
        node = (Node)iEvalTarget;
        object = node.getParentNode();
        if (object == null) {
            return false;
        }
        if (object instanceof IEvalTarget) {
            return this.isJumpPoint((IEvalTarget)object, hashSet, n - 1);
        }
        return false;
    }

    private boolean hasText(Node node) {
        if (node instanceof INodeEx) {
            INodeEx iNodeEx = (INodeEx)node;
            if (iNodeEx.hasChildNodes()) {
                NodeList nodeList = iNodeEx.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node2 = nodeList.item(n);
                    if (this.hasText(node2)) {
                        return true;
                    }
                    ++n;
                }
            } else if (iNodeEx.extractString().length() > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isAccessKey(char c, IEvalTarget iEvalTarget) {
        if (!(iEvalTarget instanceof INodeEx)) {
            return false;
        }
        INodeEx iNodeEx = (INodeEx)iEvalTarget;
        char c2 = iNodeEx.getAccessKey();
        return c2 == c;
    }

    public boolean isReachable(IEvalTarget iEvalTarget, Node node) {
        Node node2;
        Node node3;
        if (!(iEvalTarget instanceof Node)) {
            return false;
        }
        Node node4 = (Node)iEvalTarget;
        Node node5 = this.searchNonReducibleAncestor(node4);
        if (node5 == null) {
            return false;
        }
        Node node6 = this.searchNonReducibleAncestor(node);
        if (node6 == null) {
            return false;
        }
        if (node5.getParentNode() == null) {
            return false;
        }
        if (node6.getParentNode() == null) {
            return false;
        }
        if (!node5.getParentNode().isSameNode(node6.getParentNode())) {
            return false;
        }
        if (node5 instanceof IEvalTarget && node6 instanceof IEvalTarget) {
            node3 = (IEvalTarget)node5;
            node2 = (IEvalTarget)node6;
            if (this.isLink((IEvalTarget)node3) && this.isLink((IEvalTarget)node2)) {
                return true;
            }
            if (this.isButton((IEvalTarget)node3) && this.isButton((IEvalTarget)node2)) {
                return true;
            }
        }
        node3 = node4;
        node2 = node;
        if (node2 instanceof Text) {
            node2 = this.getPrev(node2);
        }
        if (node2 == null) {
            return false;
        }
        Node node7 = this.getNext(node3);
        while (node7 != null) {
            if (!(node7 instanceof IEvalTarget)) {
                node7 = this.getNext(node7);
                continue;
            }
            if (!Vocabulary.isReducible().eval((IEvalTarget)node7)) {
                return false;
            }
            if (node7.isSameNode(node2)) break;
            node7 = this.getNext(node7);
        }
        return true;
    }

    private Node getPrev(Node node) {
        Node node2 = node.getPreviousSibling();
        if (node2 != null) {
            return node2;
        }
        return node.getParentNode();
    }

    private Node getNext(Node node) {
        Node node2 = node.getNextSibling();
        if (node2 != null) {
            return node2;
        }
        return node.getParentNode();
    }

    private Node searchNonReducibleAncestor(Node node) {
        Node node2 = null;
        Node node3 = node;
        while (node3 != null && node3 instanceof IEvalTarget && (node3 instanceof Text || this.isImage((IEvalTarget)node3)) || this.isReducible((IEvalTarget)node3)) {
            node2 = node3;
            node3 = node3.getParentNode();
        }
        return node2;
    }
}

