/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class SHTableCellElement
extends SHElement
implements HTMLTableCellElement {
    private static final long serialVersionUID = 4538969444602022762L;

    protected SHTableCellElement(String string, SHDocument sHDocument) {
        super(string, sHDocument);
    }

    public int getCellIndex() {
        Node node = this.getParentNode();
        if (node instanceof HTMLTableRowElement) {
            int n = 0;
            Node node2 = this.getPreviousSibling();
            while (node2 != null) {
                ++n;
                node2 = node2.getPreviousSibling();
            }
            return n;
        }
        int n = 0;
        Node node3 = this.getPreviousSibling();
        while (node3 != null && !(node3 instanceof HTMLTableRowElement)) {
            ++n;
            node3 = node3.getPreviousSibling();
        }
        return n;
    }

    public void setCellIndex(int n) {
        if (n < 0) {
            return;
        }
        Node node = this.getParentNode();
        if (node instanceof HTMLTableRowElement) {
            node.removeChild(this);
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() <= n) {
                node.insertBefore(this, null);
            } else {
                node.insertBefore(this, nodeList.item(n));
            }
        } else {
            Node node2 = this;
            Node node3 = this.getPreviousSibling();
            while (node3 != null && !(node3 instanceof HTMLTableRowElement)) {
                node2 = node3;
                node3 = node3.getPreviousSibling();
            }
            node.removeChild(this);
            node3 = node2;
            int n2 = 0;
            while (n2 < n) {
                Node node4 = node3.getNextSibling();
                if (node4 == null || node4 instanceof HTMLTableRowElement) {
                    node.insertBefore(this, null);
                    return;
                }
                node3 = node3.getNextSibling();
                ++n2;
            }
            node.insertBefore(this, node3);
        }
    }

    public String getAbbr() {
        return this.getAttribute("abbr");
    }

    public void setAbbr(String string) {
        this.setAttribute("abbr", string);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("aling", string);
    }

    public String getAxis() {
        return this.getAttribute("axis");
    }

    public void setAxis(String string) {
        this.setAttribute("axis", string);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    public String getCh() {
        return this.getAttribute("char");
    }

    public void setCh(String string) {
        this.setAttribute("char", string);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String string) {
        this.setAttribute("charoff", string);
    }

    public int getColSpan() {
        return Integer.parseInt(this.getAttribute("colspan"));
    }

    public void setColSpan(int n) {
        this.setAttribute("colspan", Integer.toString(n));
    }

    public String getHeaders() {
        return this.getAttribute("headers");
    }

    public void setHeaders(String string) {
        this.setAttribute("headers", string);
    }

    public String getHeight() {
        return this.getAttribute("height");
    }

    public void setHeight(String string) {
        this.setAttribute("height", string);
    }

    public boolean getNoWrap() {
        String string = this.getAttribute("nowrap");
        return string != null && string.length() != 0;
    }

    public void setNoWrap(boolean bl) {
        this.setAttribute("nowrap", bl ? "nowrap" : null);
    }

    public int getRowSpan() {
        return Integer.parseInt(this.getAttribute("rowspan"));
    }

    public void setRowSpan(int n) {
        this.setAttribute("rowspan", Integer.toString(n));
    }

    public String getScope() {
        return this.getAttribute("scope");
    }

    public void setScope(String string) {
        this.setAttribute("scope", string);
    }

    public String getVAlign() {
        return this.getAttribute("valign");
    }

    public void setVAlign(String string) {
        this.setAttribute("valign", string);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String string) {
        this.setAttribute("width", string);
    }
}

