/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class SHTableElement
extends SHElement
implements HTMLTableElement {
    private static final long serialVersionUID = -4310847532198779587L;

    protected SHTableElement(String string, SHDocument sHDocument) {
        super(string, sHDocument);
    }

    public HTMLTableCaptionElement getCaption() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableCaptionElement) {
                return (HTMLTableCaptionElement)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public void setCaption(HTMLTableCaptionElement hTMLTableCaptionElement) {
        this.insertBefore(hTMLTableCaptionElement, this.getFirstChild());
    }

    public HTMLTableSectionElement getTHead() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("THEAD")) {
                return (HTMLTableSectionElement)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public void setTHead(HTMLTableSectionElement hTMLTableSectionElement) {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement) {
                this.insertBefore(hTMLTableSectionElement, node);
            }
            node = node.getNextSibling();
        }
        this.insertBefore(hTMLTableSectionElement, this.getLastChild());
    }

    public HTMLTableSectionElement getTFoot() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("TFOOT")) {
                return (HTMLTableSectionElement)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public void setTFoot(HTMLTableSectionElement hTMLTableSectionElement) {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("TBODY")) {
                this.insertBefore(hTMLTableSectionElement, node);
            }
            node = node.getNextSibling();
        }
        this.insertBefore(hTMLTableSectionElement, this.getLastChild());
    }

    public HTMLCollection getRows() {
        int n = 0;
        Node[] nodeArray = new HTMLTableRowElement[16];
        Node node = this.getFirstChild();
        while (node != null) {
            HTMLTableRowElement[] hTMLTableRowElementArray;
            if (node instanceof HTMLTableSectionElement) {
                hTMLTableRowElementArray = node.getFirstChild();
                while (hTMLTableRowElementArray != null) {
                    if (hTMLTableRowElementArray instanceof HTMLTableRowElement) {
                        if (nodeArray.length == n) {
                            HTMLTableRowElement[] hTMLTableRowElementArray2 = new HTMLTableRowElement[n * 2];
                            System.arraycopy(nodeArray, 0, hTMLTableRowElementArray2, 0, n);
                            nodeArray = hTMLTableRowElementArray2;
                        }
                        nodeArray[n++] = (HTMLTableRowElement)hTMLTableRowElementArray;
                    }
                    hTMLTableRowElementArray = hTMLTableRowElementArray.getNextSibling();
                }
            } else if (node instanceof HTMLTableRowElement) {
                if (nodeArray.length == n) {
                    hTMLTableRowElementArray = new HTMLTableRowElement[n * 2];
                    System.arraycopy(nodeArray, 0, hTMLTableRowElementArray, 0, n);
                    nodeArray = hTMLTableRowElementArray;
                }
                nodeArray[n++] = (HTMLTableRowElement)node;
            }
            node = node.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(nodeArray, n);
    }

    public HTMLCollection getTBodies() {
        int n = 0;
        Node[] nodeArray = new HTMLTableSectionElement[16];
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("TBODY")) {
                if (nodeArray.length == n) {
                    HTMLTableSectionElement[] hTMLTableSectionElementArray = new HTMLTableSectionElement[n * 2];
                    System.arraycopy(nodeArray, 0, hTMLTableSectionElementArray, 0, n);
                    nodeArray = hTMLTableSectionElementArray;
                }
                nodeArray[n++] = (HTMLTableSectionElement)node;
            }
            node = node.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(nodeArray, n);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public void setBorder(String string) {
        this.setAttribute("border", string);
    }

    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    public void setCellPadding(String string) {
        this.setAttribute("cellpadding", string);
    }

    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    public void setCellSpacing(String string) {
        this.setAttribute("cellspacing", string);
    }

    public String getFrame() {
        return this.getAttribute("frame");
    }

    public void setFrame(String string) {
        this.setAttribute("frame", string);
    }

    public String getRules() {
        return this.getAttribute("rules");
    }

    public void setRules(String string) {
        this.setAttribute("rules", string);
    }

    public String getSummary() {
        return this.getAttribute("summary");
    }

    public void setSummary(String string) {
        this.setAttribute("summary", string);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String string) {
        this.setAttribute("width", string);
    }

    public HTMLElement createTHead() {
        return (HTMLElement)this.getOwnerDocument().createElement("THEAD");
    }

    public void deleteTHead() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("THEAD")) {
                this.removeChild(node);
                return;
            }
            node = node.getNextSibling();
        }
    }

    public HTMLElement createTFoot() {
        return (HTMLElement)this.getOwnerDocument().createElement("TFOOT");
    }

    public void deleteTFoot() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("TFOOT")) {
                this.removeChild(node);
                return;
            }
            node = node.getNextSibling();
        }
    }

    public HTMLElement createCaption() {
        return (HTMLElement)this.getOwnerDocument().createElement("CAPTION");
    }

    public void deleteCaption() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableSectionElement && node.getNodeName().equalsIgnoreCase("CAPTION")) {
                this.removeChild(node);
                return;
            }
            node = node.getNextSibling();
        }
    }

    public HTMLElement insertRow(int n) {
        if (n < 0) {
            return null;
        }
        HTMLCollection hTMLCollection = this.getRows();
        if (hTMLCollection.getLength() <= n) {
            return null;
        }
        Node node = hTMLCollection.item(n);
        Node node2 = node.getParentNode();
        HTMLElement hTMLElement = (HTMLElement)this.getOwnerDocument().createElement("TR");
        node2.insertBefore(hTMLElement, node);
        return hTMLElement;
    }

    public void deleteRow(int n) {
        if (n < 0) {
            return;
        }
        HTMLCollection hTMLCollection = this.getRows();
        if (hTMLCollection.getLength() <= n) {
            return;
        }
        Node node = hTMLCollection.item(n);
        node.getParentNode().removeChild(node);
    }
}

