/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.dom;

import java.util.HashMap;
import org.eclipse.actf.util.dom.WhatToShowNodeFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    private Node walkerRoot;
    private Node current;
    private int whatToShow;
    private NodeFilter filter;
    private NodeFilter defaultFilter;
    private boolean entitiyReferenceExpansion;
    private boolean noFilter = true;
    private HashMap<Node, Node> parentMap = new HashMap();

    public TreeWalkerImpl(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (node == null) {
            throw new DOMException(9, "Root can't be a null.");
        }
        this.walkerRoot = node;
        this.current = node;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.noFilter = nodeFilter == null;
        this.entitiyReferenceExpansion = bl;
        this.defaultFilter = new WhatToShowNodeFilter(n);
    }

    private short eval(Node node) {
        short s = this.defaultFilter.acceptNode(node);
        if (this.noFilter || s == 3) {
            return s;
        }
        return this.filter.acceptNode(node);
    }

    private Node getVisibleNextSibling(Node node, Node node2) {
        if (node == node2) {
            return null;
        }
        Node node3 = node.getNextSibling();
        if (node3 == null) {
            Node node4 = this.getParentNode(node);
            if (this.eval(node4) == 3) {
                return this.getVisibleNextSibling(node4, node2);
            }
            return null;
        }
        switch (this.eval(node3)) {
            case 1: {
                return node3;
            }
            case 3: {
                Node node5 = this.getVisibleFirstChild(node3);
                if (node5 == null) break;
                return node5;
            }
        }
        return this.getVisibleNextSibling(node3, node2);
    }

    private Node getVisiblePreviousSibling(Node node, Node node2) {
        if (node == node2) {
            return null;
        }
        Node node3 = node.getPreviousSibling();
        if (node3 == null) {
            Node node4 = this.getParentNode(node);
            if (this.eval(node4) == 3) {
                return this.getVisiblePreviousSibling(node4, node2);
            }
            return null;
        }
        switch (this.eval(node3)) {
            case 1: {
                return node3;
            }
            case 3: {
                Node node5 = this.getVisibleLastChild(node3);
                if (node5 == null) break;
                return node5;
            }
        }
        return this.getVisiblePreviousSibling(node3, node2);
    }

    private Node getVisibleFirstChild(Node node) {
        if (!this.entitiyReferenceExpansion && 5 == node.getNodeType()) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        this.parentMap.put(node2, node);
        Node node3 = node2.getNextSibling();
        while (node3 != null) {
            this.parentMap.put(node3, node);
            node3 = node3.getNextSibling();
        }
        switch (this.eval(node2)) {
            case 1: {
                return node2;
            }
            case 3: {
                Node node4 = this.getVisibleFirstChild(node2);
                if (node4 == null) break;
                return node4;
            }
        }
        return this.getVisibleNextSibling(node2, node);
    }

    private Node getVisibleLastChild(Node node) {
        if (!this.entitiyReferenceExpansion && 5 == node.getNodeType()) {
            return null;
        }
        Node node2 = node.getLastChild();
        if (node2 == null) {
            return null;
        }
        switch (this.eval(node2)) {
            case 1: {
                return node2;
            }
            case 3: {
                Node node3 = this.getVisibleLastChild(node2);
                if (node3 == null) break;
                return node3;
            }
        }
        return this.getVisiblePreviousSibling(node2, node);
    }

    private Node getVisibleParent(Node node) {
        if (node == this.walkerRoot) {
            return null;
        }
        Node node2 = this.getParentNode(node);
        if (node2 == null) {
            return null;
        }
        switch (this.eval(node2)) {
            case 1: {
                return node2;
            }
        }
        return this.getVisibleParent(node2);
    }

    protected Node getParentNode(Node node) {
        Node node2 = this.parentMap.get(node);
        if (node2 != null) {
            return node2;
        }
        return node.getParentNode();
    }

    public Node firstChild() {
        Node node = this.getVisibleFirstChild(this.current);
        if (node != null) {
            this.current = node;
        }
        return node;
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public boolean getExpandEntityReferences() {
        return this.entitiyReferenceExpansion;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.walkerRoot;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node lastChild() {
        Node node = this.getVisibleLastChild(this.current);
        if (node != null) {
            this.current = node;
        }
        return node;
    }

    public Node nextNode() {
        Node node = this.getVisibleFirstChild(this.current);
        if (node != null) {
            this.current = node;
            return node;
        }
        node = this.getVisibleNextSibling(this.current, this.walkerRoot);
        if (node != null) {
            this.current = node;
            return node;
        }
        Node node2 = this.getVisibleParent(this.current);
        while (node2 != null) {
            node = this.getVisibleNextSibling(node2, this.walkerRoot);
            if (node != null) {
                this.current = node;
                return node;
            }
            node2 = this.getVisibleParent(node2);
        }
        return null;
    }

    public Node nextSibling() {
        Node node = this.getVisibleNextSibling(this.current, this.walkerRoot);
        if (node != null) {
            this.current = node;
        }
        return node;
    }

    public Node parentNode() {
        Node node = this.getVisibleParent(this.current);
        if (node != null) {
            this.current = node;
        }
        return node;
    }

    public Node previousNode() {
        Node node = this.getVisiblePreviousSibling(this.current, this.walkerRoot);
        if (node == null) {
            node = this.getVisibleParent(this.current);
            if (node != null) {
                this.current = node;
                return node;
            }
            return null;
        }
        Node node2 = this.getVisibleLastChild(node);
        while (node2 != null) {
            node = node2;
            node2 = this.getVisibleLastChild(node);
        }
        this.current = node;
        return node;
    }

    public Node previousSibling() {
        Node node = this.getVisiblePreviousSibling(this.current, this.walkerRoot);
        if (node != null) {
            this.current = node;
        }
        return node;
    }

    public void setCurrentNode(Node node) throws DOMException {
        if (node == null) {
            throw new DOMException(9, "Current node can't be null.");
        }
        this.current = node;
    }
}

