/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.Arrays;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsElementScanner;

public class SuppressionToolRule
implements IRule {
    private String[] toolList;
    private IToken token;
    private WordRule subrule;
    private static final IToken DUMMY_TOKEN = new Token(null);
    private static final char[] COLON = new char[]{':'};

    public SuppressionToolRule(String[] tools, IToken successToken) {
        this.toolList = tools;
        this.token = successToken;
        this.subrule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                for (String tool : SuppressionToolRule.this.toolList) {
                    if (c != tool.charAt(0)) continue;
                    return true;
                }
                return false;
            }

            public boolean isWordPart(char c) {
                return c != ':';
            }
        });
        for (String tool : this.toolList) {
            this.subrule.addWord(tool, DUMMY_TOKEN);
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken result = this.subrule.evaluate(scanner);
        if (!result.isUndefined()) {
            boolean match = true;
            int tokenLength = ((SuppressionsElementScanner)scanner).getTokenLength();
            match = this.checkColon(scanner);
            if (match) {
                for (int i = 0; i < tokenLength; ++i) {
                    scanner.unread();
                }
                int indentLength = 0;
                while (scanner.getColumn() > 0) {
                    scanner.unread();
                    ++indentLength;
                }
                while (indentLength-- > 0) {
                    int ch = scanner.read();
                    if (Character.isWhitespace(ch)) continue;
                    match = false;
                }
                for (int i = 0; i < tokenLength; ++i) {
                    scanner.read();
                }
            }
            if (!match) {
                this.unreadBuffer(scanner, tokenLength);
                result = Token.UNDEFINED;
            } else {
                result = this.token;
            }
        }
        return result;
    }

    private boolean checkColon(ICharacterScanner scanner) {
        int ch = scanner.read();
        if (ch == -1) {
            return false;
        }
        scanner.unread();
        return Arrays.equals(Character.toChars(ch), COLON);
    }

    private void unreadBuffer(ICharacterScanner scanner, int length) {
        for (int i = 0; i < length; ++i) {
            scanner.unread();
        }
    }
}

