/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tools.launch.ui.properties;

import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.linuxtools.internal.tools.launch.ui.properties.CustomComboFieldEditor;
import org.eclipse.linuxtools.internal.tools.launch.ui.properties.Messages;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LinuxtoolsPathPropertyPage
extends PropertyPage {
    public static final String LINUXTOOLS_PATH_COMBO_NAME = "org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPathCombo";
    private static final String LINUXTOOLS_PATH_EXT_POINT = "LinuxtoolsPathOptions";
    private static final String LINUXTOOLS_PATH_OPTION = "option";
    private static final String LINUXTOOLS_PATH_OPTION_NAME = "name";
    private static final String LINUXTOOLS_PATH_OPTION_PATH = "path";
    private static final String[][] DEFAULT_PATHS = new String[][]{{"Custom", ""}};
    private StringFieldEditor linuxtoolsPath;
    private StringFieldEditor linuxtoolsPrefix;
    private CustomComboFieldEditor linuxtoolsPathCombo;
    private IAdaptable element = null;
    private Composite result;
    private Button systemEnvButton;
    private Button customButton;
    private boolean customSelected;
    private boolean initialized = false;

    private String[][] fillPaths() {
        IConfigurationElement[] configs;
        LinkedList<String[]> list = new LinkedList<String[]>();
        String[][] stringArray = DEFAULT_PATHS;
        int n = DEFAULT_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] t = stringArray[n2];
            list.add(t);
            ++n2;
        }
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.tools.launch.core", LINUXTOOLS_PATH_EXT_POINT);
        IConfigurationElement[] iConfigurationElementArray = configs = extPoint.getConfigurationElements();
        int n3 = configs.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement config = iConfigurationElementArray[n4];
            if (config.getName().equals(LINUXTOOLS_PATH_OPTION)) {
                String path = config.getAttribute(LINUXTOOLS_PATH_OPTION_PATH);
                String name = config.getAttribute(LINUXTOOLS_PATH_OPTION_NAME);
                list.add(new String[]{name, path});
            }
            ++n4;
        }
        return (String[][])list.toArray((T[])new String[0][0]);
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.result.setLayout((Layout)layout);
        String[][] paths = this.fillPaths();
        this.getPreferenceStore().setDefault("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath", LinuxtoolsPathProperty.getInstance().getLinuxtoolsPathSystemDefault());
        this.getPreferenceStore().setDefault(LINUXTOOLS_PATH_COMBO_NAME, LinuxtoolsPathProperty.getInstance().getLinuxtoolsPathDefault());
        Composite radios = new Composite(this.result, 0);
        GridLayout layoutRadios = new GridLayout();
        layoutRadios.marginWidth = 0;
        layoutRadios.numColumns = 1;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        radios.setLayout((Layout)layoutRadios);
        radios.setLayoutData((Object)gridData);
        boolean systemPathSelected = this.getPreferenceStore().getBoolean("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath");
        this.systemEnvButton = new Button(radios, 16);
        this.systemEnvButton.setText(Messages.LINUXTOOLS_PATH_SYSTEM_ENV);
        this.systemEnvButton.setSelection(systemPathSelected);
        this.systemEnvButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateOptionsEnable()));
        this.customButton = new Button(radios, 16);
        this.customButton.setText(Messages.LINUXTOOLS_PATH_CUSTOM);
        this.customButton.setToolTipText(Messages.LINUXTOOLS_PATH_CUSTOM_TOOLTIP);
        this.customButton.setSelection(!systemPathSelected);
        this.linuxtoolsPathCombo = new CustomComboFieldEditor(LINUXTOOLS_PATH_COMBO_NAME, Messages.LINUXTOOLS_PATH_COMBO, paths, this.result);
        this.linuxtoolsPathCombo.setPage((DialogPage)this);
        this.linuxtoolsPathCombo.setPreferenceStore(this.getPreferenceStore());
        this.linuxtoolsPathCombo.load();
        this.linuxtoolsPathCombo.setPropertyChangeListener(event -> {
            this.customSelected = event.getNewValue().toString().equals("");
            if (!this.customSelected) {
                this.linuxtoolsPath.setStringValue(event.getNewValue().toString());
            }
            this.updateOptionsEnable();
        });
        this.linuxtoolsPath = new StringFieldEditor("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPath", Messages.LINUXTOOLS_PATH, this.result);
        this.linuxtoolsPath.setPage((DialogPage)this);
        this.linuxtoolsPath.setPreferenceStore(this.getPreferenceStore());
        this.linuxtoolsPath.getTextControl(this.result).setToolTipText(Messages.LINUXTOOLS_PATH_TOOLTIP);
        this.linuxtoolsPrefix = new StringFieldEditor("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPrefix", Messages.LINUXTOOLS_PREFIX_COMBO, this.result);
        this.linuxtoolsPrefix.setPage((DialogPage)this);
        this.linuxtoolsPrefix.setPreferenceStore(this.getPreferenceStore());
        this.linuxtoolsPrefix.getTextControl(this.result).setToolTipText(Messages.LINUXTOOLS_PREFIX_TOOLTIP);
        this.getPreferenceStore().setDefault("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPrefix", LinuxtoolsPathProperty.getInstance().getLinuxtoolsPrefixDefault());
        this.linuxtoolsPrefix.load();
        String selected = this.getPreferenceStore().getString(LINUXTOOLS_PATH_COMBO_NAME);
        this.customSelected = selected.equals("");
        this.getPreferenceStore().setDefault("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPath", LinuxtoolsPathProperty.getInstance().getLinuxtoolsPathDefault());
        this.linuxtoolsPath.load();
        this.linuxtoolsPathCombo.setSelectedValue(this.linuxtoolsPath.getStringValue());
        Dialog.applyDialogFont((Control)this.result);
        this.updateOptionsEnable();
        this.initialized = true;
        return this.result;
    }

    private void updateOptionsEnable() {
        if (this.systemEnvButton.getSelection()) {
            this.linuxtoolsPath.setEnabled(false, this.result);
            this.linuxtoolsPathCombo.setEnabled(false, this.result);
        } else {
            this.linuxtoolsPath.setEnabled(this.customSelected, this.result);
            this.linuxtoolsPathCombo.setEnabled(true, this.result);
        }
    }

    protected void performDefaults() {
        if (this.initialized) {
            this.linuxtoolsPath.loadDefault();
            this.linuxtoolsPrefix.loadDefault();
            this.linuxtoolsPathCombo.loadDefault();
            this.customButton.setSelection(!LinuxtoolsPathProperty.getInstance().getLinuxtoolsPathSystemDefault());
            this.systemEnvButton.setSelection(LinuxtoolsPathProperty.getInstance().getLinuxtoolsPathSystemDefault());
            this.updateOptionsEnable();
        }
    }

    public boolean performOk() {
        if (this.initialized) {
            this.linuxtoolsPath.store();
            this.linuxtoolsPrefix.store();
            this.linuxtoolsPathCombo.store();
            this.getPreferenceStore().setValue("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath", this.systemEnvButton.getSelection());
        }
        return super.performOk();
    }

    protected void performApply() {
        if (this.initialized) {
            this.linuxtoolsPath.store();
            this.linuxtoolsPrefix.store();
            this.linuxtoolsPathCombo.store();
            this.getPreferenceStore().setValue("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath", this.systemEnvButton.getSelection());
        }
        super.performApply();
    }

    public void setElement(IAdaptable element) {
        this.element = element;
        IAdaptable e = this.getElement();
        if (e != null) {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new ProjectScope((IProject)e), "org.eclipse.linuxtools.tools.launch.core"));
        }
    }

    public IAdaptable getElement() {
        if (this.element == null) {
            return this.element;
        }
        if (!(this.element instanceof IProject)) {
            return (IAdaptable)this.element.getAdapter(IProject.class);
        }
        return this.element;
    }
}

