/**
 * Copyright (c) 2006, 2009, 2021 Borland Software Corporation, CEA LIST, ARTAL and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.diagram.editparts.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class CompartmentEditPart {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  private Externalizer xptExternalizer;

  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;

  public CharSequence className(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }

  public CharSequence packageName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }

  public CharSequence constructor(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence hasModelChildrenChanged(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isListLayout = it.isListLayout();
      if (_isListLayout) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean hasModelChildrenChanged(org.eclipse.emf.common.notify.Notification evt) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence getCompartmentName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getCompartmentName() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getDiagram().getEditorGen(), this.i18nKeyForCompartmentTitle(it));
    _builder.append(_accessorCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createFigure(final GenCompartment it) {
    CharSequence _xifexpression = null;
    boolean _hasExternalSuperClass = this.hasExternalSuperClass(it, 
      "org.eclipse.papyrus.uml.diagram.activity.edit.part.ShapeCompartmentWithoutScrollbarsEditPart");
    if (_hasExternalSuperClass) {
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _overrideC = this._codeStyle.overrideC(it);
      _builder.append(_overrideC);
      _builder.newLineIfNotEmpty();
      _builder.append("public org.eclipse.draw2d.IFigure createFigure() {");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("return super.createFigure();");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        boolean _isNeedsTitle = it.isNeedsTitle();
        boolean _not = (!_isNeedsTitle);
        if (_not) {
          CharSequence _generatedMemberComment = this._common.generatedMemberComment();
          _builder_1.append(_generatedMemberComment);
          _builder_1.newLineIfNotEmpty();
          CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
          _builder_1.append(_overrideC_1);
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("public org.eclipse.draw2d.IFigure createFigure() {");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure result = (org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure) super.createFigure();");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("result.setTitleVisibility(false);");
          _builder_1.newLine();
          _builder_1.append("\t");
          _builder_1.append("return result;");
          _builder_1.newLine();
          _builder_1.append("}");
          _builder_1.newLine();
        }
      }
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }

  public CharSequence createDefaultEditPoliciesBody(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    {
      boolean _isCanCollapse = it.isCanCollapse();
      if (_isCanCollapse) {
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installSemanticEditPolicy = this.xptEditpartsCommon.installSemanticEditPolicy(it);
    _builder.append(_installSemanticEditPolicy);
    _builder.newLineIfNotEmpty();
    {
      boolean _isEmpty = it.getChildNodes().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CREATION_ROLE, new org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy());");
        _builder.newLine();
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.DRAG_DROP_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy());");
        _builder.newLine();
        _builder.append("installEditPolicy(org.eclipse.papyrus.uml.diagram.common.editpolicies.PasteEditPolicy.PASTE_ROLE, new org.eclipse.papyrus.uml.diagram.common.editpolicies.PasteEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installCanonicalEditPolicy = this.xptEditpartsCommon.installCanonicalEditPolicy(it);
    _builder.append(_installCanonicalEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence additionalEditPolicies(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence refreshVisuals(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void refreshVisuals() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.refreshVisuals();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("refreshBounds();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence handleNotificationEventBody(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.handleNotificationEvent(notification);");
    _builder.newLine();
    _builder.append("Object feature = notification.getFeature();");
    _builder.newLine();
    _builder.append("if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width().equals(feature)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("|| org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height().equals(feature)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("|| org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X().equals(feature)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("|| org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshBounds();");
    _builder.newLine();
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }

  public CharSequence refreshBounds(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void refreshBounds() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int x = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int y = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int width = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int height = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("((org.eclipse.gef.GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence setRatio(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setRatio(Double ratio) {");
    _builder.newLine();
    {
      ViewmapLayoutType _layoutType = it.getNode().getLayoutType();
      boolean _equals = Objects.equal(ViewmapLayoutType.UNKNOWN_LITERAL, _layoutType);
      if (_equals) {
        _builder.append("\t");
        _builder.append("if (getFigure().getParent().getLayoutManager() instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("super.setRatio(ratio);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("// nothing to do -- parent layout does not accept Double constraints as ratio");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// super.setRatio(ratio); ");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getTargetEditPartMethod(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.EditPart getTargetEditPart(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getTargetEditPart(request);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Localization
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment compartment : _compartments) {
        CharSequence _internal_i18nAccessors = this.internal_i18nAccessors(compartment);
        _builder.append(_internal_i18nAccessors);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence internal_i18nAccessors(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _tripleNotEquals = (null != _title);
      if (_tripleNotEquals) {
        CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForCompartmentTitle(it));
        _builder.append(_accessorField);
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment compartment : _compartments) {
        CharSequence _internal_i18nValues = this.internal_i18nValues(compartment);
        _builder.append(_internal_i18nValues);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence internal_i18nValues(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _tripleNotEquals = (null != _title);
      if (_tripleNotEquals) {
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForCompartmentTitle(it), it.getTitle());
        _builder.append(_messageEntry);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public String i18nKeyForCompartmentTitle(final GenCompartment compartment) {
    CharSequence _className = this.className(compartment);
    return (_className + ".title");
  }

  public boolean hasExternalSuperClass(final GenCompartment it, final String className) {
    String _superEditPart = it.getSuperEditPart();
    return Objects.equal(_superEditPart, className);
  }
}
