/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.common.mmqueries;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotml.generators.common.mmqueries.ArchitectureQueries;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class GeneralQueries {
    protected static void getElementsWithStereotype(Element parent_elt, java.lang.Class clazz, LinkedList<NamedElement> target_list) {
        if (parent_elt instanceof Class) {
            for (EObject stereoApplication : parent_elt.getStereotypeApplications()) {
                if (!clazz.isInstance(stereoApplication)) continue;
                target_list.add((NamedElement)parent_elt);
            }
        }
        for (Element ne : parent_elt.getOwnedElements()) {
            if (!(ne instanceof NamedElement) || !(ne instanceof Class)) continue;
            for (EObject stereoApplication : ne.getStereotypeApplications()) {
                if (!clazz.isInstance(stereoApplication)) continue;
                target_list.add((NamedElement)ne);
            }
            GeneralQueries.getElementsWithStereotype(ne, clazz, target_list);
        }
    }

    @Deprecated
    public static List<NamedElement> getElementsWithStereotype(Model model, String stereotype) {
        LinkedList<NamedElement> found_elts = new LinkedList<NamedElement>();
        for (Element ne : model.getOwnedElements()) {
            if (ne instanceof NamedElement) {
                if (ne instanceof Class && GeneralQueries.hasStereotype((Class)ne, stereotype).booleanValue()) {
                    found_elts.add((NamedElement)ne);
                }
            } else if (ne instanceof Model) {
                found_elts.addAll(GeneralQueries.getElementsWithStereotype((Model)ne, stereotype));
            }
            GeneralQueries.getElementsWithStereotype(ne, stereotype, found_elts);
        }
        return found_elts;
    }

    @Deprecated
    private static void getElementsWithStereotype(Element parent_elt, String stereotype, LinkedList<NamedElement> target_list) {
        for (Element ne : parent_elt.getOwnedElements()) {
            if (!(ne instanceof NamedElement)) continue;
            if (ne instanceof Class && GeneralQueries.hasStereotype((Class)ne, stereotype).booleanValue()) {
                target_list.add((NamedElement)ne);
            }
            GeneralQueries.getElementsWithStereotype(ne, stereotype, target_list);
        }
    }

    @Deprecated
    public static List<NamedElement> getElementsWithInheritedStereotype(Model model, String stereotype) {
        LinkedList<NamedElement> found_elts = new LinkedList<NamedElement>();
        for (Element ne : model.getOwnedElements()) {
            if (ne instanceof NamedElement) {
                if (ne instanceof Class && GeneralQueries.inheritsFrom((Class)ne, stereotype).booleanValue()) {
                    found_elts.add((NamedElement)ne);
                }
            } else if (ne instanceof Model) {
                found_elts.addAll(GeneralQueries.getElementsWithInheritedStereotype((Model)ne, stereotype));
            }
            GeneralQueries.getElementsWithInheritedStereotype(ne, stereotype, found_elts);
        }
        return found_elts;
    }

    @Deprecated
    private static void getElementsWithInheritedStereotype(Element parent_elt, String stereotype, LinkedList<NamedElement> target_list) {
        for (Element ne : parent_elt.getOwnedElements()) {
            if (!(ne instanceof NamedElement)) continue;
            if (ne instanceof Class && GeneralQueries.inheritsFrom((Class)ne, stereotype).booleanValue()) {
                target_list.add((NamedElement)ne);
            }
            GeneralQueries.getElementsWithInheritedStereotype(ne, stereotype, target_list);
        }
    }

    @Deprecated
    public static String getStereotype(Class cl) {
        if (cl.getAppliedStereotypes().size() == 1) {
            return ((Stereotype)cl.getAppliedStereotypes().get(0)).getName();
        }
        return "--";
    }

    public static Boolean inheritsFrom(Class cl, String stname) {
        for (Stereotype st : cl.getAppliedStereotypes()) {
            if (st.getName().equals(stname)) {
                return true;
            }
            if (!GeneralQueries.inheritsFrom(st, stname).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Boolean inheritsFrom(Stereotype st, String stname) {
        if (st.getName().equals(stname)) {
            return true;
        }
        for (Class scl : st.getSuperClasses()) {
            if (!GeneralQueries.inheritsFrom((Stereotype)scl, stname).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static String getStereotypeInheritedFrom(Class cl, String stname) {
        for (Stereotype st : cl.getAppliedStereotypes()) {
            if (!GeneralQueries.inheritsFrom(st, stname).booleanValue()) continue;
            return st.getName();
        }
        return null;
    }

    public static Boolean hasStereotype(Class cl, java.lang.Class stereotype) {
        for (EObject stereoApplication : cl.getStereotypeApplications()) {
            if (!stereotype.isInstance(stereoApplication)) continue;
            return true;
        }
        return false;
    }

    public static Boolean hasStereotype(Class cl, String s) {
        for (Stereotype st : cl.getAppliedStereotypes()) {
            if (!st.getName().equals(s)) continue;
            return true;
        }
        return false;
    }

    public static Boolean isClass(Element elt) {
        return elt instanceof Class;
    }

    public static Boolean isDataType(Element elt) {
        boolean b = elt instanceof DataType;
        return b;
    }

    public static Boolean isInterface(Element elt) {
        boolean b = elt instanceof Interface;
        return b;
    }

    public static Boolean isProperty(Element elt) {
        return elt instanceof Property;
    }

    public static Boolean isPort(Element prop) {
        return prop instanceof Port;
    }

    public static Boolean isInstanceSpecification(Element elt) {
        return elt instanceof InstanceSpecification;
    }

    public static String getInstanceMultiplicity(Property p) {
        block4: {
            try {
                if (p.getLower() != 1 || p.getUpper() != 1) break block4;
                return "";
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
                return "";
            }
        }
        if (p.getLower() == p.getUpper()) {
            return "[" + p.getLower() + "]";
        }
        return "[]";
    }

    public static String getAttributeValue(Class cl, String attr, String stname) {
        for (Stereotype st : cl.getAppliedStereotypes()) {
            Object o;
            if (!st.getName().equals(stname) || (o = cl.getValue(st, attr)) == null) continue;
            if (o instanceof NamedElement) {
                String v = ((NamedElement)o).getName();
                return v;
            }
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof EList) {
                if (((EList)o).isEmpty()) {
                    return null;
                }
                return ((EList)o).get(0).toString();
            }
            return o.toString();
        }
        return null;
    }

    public static String getAttributeValue(Class cl, String attr, String stname, String defaultValue) {
        String result = null;
        result = GeneralQueries.getAttributeValue(cl, attr, stname);
        if (result == null || result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    public static List<String> getAttributeValues(Class cl, String attr, String stname) {
        LinkedList<String> result = new LinkedList<String>();
        for (Stereotype st : cl.getAppliedStereotypes()) {
            Object o;
            if (!st.getName().equals(stname) || (o = cl.getValue(st, attr)) == null) continue;
            if (o instanceof NamedElement) {
                result.add(((NamedElement)o).getName());
                continue;
            }
            if (o instanceof String) {
                result.add((String)o);
                continue;
            }
            if (o instanceof EList) {
                int i = 0;
                while (i < ((EList)o).size()) {
                    result.add(((EList)o).get(i).toString());
                    ++i;
                }
                continue;
            }
            result.add(o.toString());
        }
        return result;
    }

    public static Class findClassInModel(Model model, String name) {
        for (Element ne : model.getOwnedElements()) {
            Class result;
            if (ne instanceof NamedElement) {
                if (ne instanceof Class) {
                    if (!((Class)ne).getName().equals(name)) continue;
                    return (Class)ne;
                }
                if (!(ne instanceof Package) || (result = GeneralQueries.findClassInPackage((Package)ne, name)) == null) continue;
                return result;
            }
            if (!(ne instanceof Model) || (result = GeneralQueries.findClassInModel((Model)ne, name)) == null) continue;
            return result;
        }
        return null;
    }

    public static Class findClassInPackage(Package pack, String name) {
        for (Element ne : pack.getOwnedElements()) {
            Class result;
            if (ne instanceof NamedElement) {
                if (ne instanceof Class) {
                    if (!((Class)ne).getName().equals(name)) continue;
                    return (Class)ne;
                }
                if (!(ne instanceof Package) || (result = GeneralQueries.findClassInPackage((Package)ne, name)) == null) continue;
                return result;
            }
            if (!(ne instanceof Model) || (result = GeneralQueries.findClassInModel((Model)ne, name)) == null) continue;
            return result;
        }
        return null;
    }

    public static void inspectDataType(DataType datatype) {
        System.out.println("\t\t* data type: " + datatype.getName());
    }

    public static void inspectClass(Class cl) {
        System.out.println("\t* super classes: " + cl.getSuperClasses());
        for (Stereotype st : cl.getAppliedStereotypes()) {
            System.out.println("\t* applied stereotype: " + st.getName());
        }
        for (Property prop : cl.getAllAttributes()) {
            System.out.println("\t* property: " + prop.getName());
            if (GeneralQueries.isPort((Element)prop).booleanValue()) {
                GeneralQueries.inspectPort((Port)prop);
                continue;
            }
            Type propType = prop.getType();
            if (GeneralQueries.isDataType((Element)propType).booleanValue()) {
                System.out.println("\t\t* property read from stereotype: " + prop.getName());
                continue;
            }
            if (GeneralQueries.isClass((Element)propType).booleanValue()) {
                System.out.println("\t\t* class sub instance : " + propType.getName() + " - " + prop.getUpper() + " - " + prop.getLower());
                continue;
            }
            System.err.println("UNKONWN PROPERTY TYPE !");
        }
        for (Connector connector : cl.getOwnedConnectors()) {
            System.out.println("\t* owned connector: " + connector.getName());
            for (ConnectorEnd cend : connector.getEnds()) {
                if (cend.getRole() != null && cend.getPartWithPort() != null) {
                    System.out.println("\t\t* from property: " + cend.getRole().getName() + " in instance " + cend.getPartWithPort().getName());
                    continue;
                }
                System.err.println("\t\t* Unconnected Port !");
                System.out.println();
            }
        }
        for (Operation op : cl.getAllOperations()) {
            System.out.println("\t* operation: " + op.getName() + " - datatype: " + op.getDatatype() + " - interface: " + op.getInterface());
        }
    }

    public static void inspectPort(Port port) {
        if (ArchitectureQueries.isDataFlowPort(port).booleanValue()) {
            ArchitectureQueries.inspectDataFlowPort(port);
        } else if (ArchitectureQueries.isServicePort(port).booleanValue()) {
            ArchitectureQueries.inspectServicePort(port);
        } else {
            System.err.println("UNKONWN PORT !");
        }
    }

    public static Boolean inspectModel(Model model) {
        try {
            System.out.println("* model name: " + model.getName());
            for (PackageableElement elt : model.getImportedElements()) {
                System.out.println("* model imported packageable element: " + elt);
            }
            for (PackageableElement elt : model.getImportedPackages()) {
                System.out.println("* model imported package: " + elt);
            }
            for (PackageableElement elt : model.getNestedPackages()) {
                System.out.println("* model nested package: " + elt);
            }
            for (PackageableElement elt : model.getMembers()) {
                System.out.println("* model member: " + elt.getName());
                if (GeneralQueries.isClass((Element)elt).booleanValue()) {
                    GeneralQueries.inspectClass((Class)elt);
                    continue;
                }
                if (GeneralQueries.isDataType((Element)elt).booleanValue()) {
                    GeneralQueries.inspectDataType((DataType)elt);
                    continue;
                }
                if (GeneralQueries.isInterface((Element)elt).booleanValue()) {
                    System.out.println("\t* interface definition : " + elt.getName());
                    continue;
                }
                System.err.println("\t* unknown element: " + elt);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return true;
    }

    public String removeBrackets(String str) {
        return str.replaceAll("[\\[\\]]", "");
    }
}

