/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.common.mmqueries;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class DataTypeQueries {
    public static String newline = System.getProperty("line.separator");

    public List<DataType> getMetamodelComposedDataTypes(Element rootelt) {
        LinkedList<DataType> results;
        block6: {
            block5: {
                results = new LinkedList<DataType>();
                if (!(rootelt instanceof Model)) break block5;
                EList packages = ((Model)rootelt).getImportedPackages();
                for (Package p : packages) {
                    EList elts = p.getOwnedElements();
                    for (Element elt : elts) {
                        if (elt instanceof PrimitiveType) continue;
                        if (elt instanceof DataType) {
                            results.add((DataType)elt);
                            continue;
                        }
                        if (!(elt instanceof Package)) continue;
                        results.addAll(this.getMetamodelComposedDataTypes(elt));
                    }
                }
                break block6;
            }
            if (!(rootelt instanceof Package)) break block6;
            Package p = (Package)rootelt;
            EList elts = p.getOwnedElements();
            for (Element elt : elts) {
                if (elt instanceof PrimitiveType) continue;
                if (elt instanceof DataType) {
                    results.add((DataType)elt);
                    continue;
                }
                if (!(elt instanceof Package)) continue;
                results.addAll(this.getMetamodelComposedDataTypes(elt));
            }
        }
        return results;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isRobotMLDataType(Element root_model, String datatype_name) {
        try {
            if (root_model instanceof Model) {
                EList packages = ((Model)root_model).getImportedPackages();
                for (Package p : packages) {
                    EList elts = p.getOwnedElements();
                    for (Element elt : elts) {
                        if (elt instanceof DataType && datatype_name.compareTo(((DataType)elt).getName()) == 0) {
                            return true;
                        }
                        if (!(elt instanceof Package) || !DataTypeQueries.isRobotMLDataType(elt, datatype_name)) continue;
                        return true;
                    }
                }
            } else if (root_model instanceof Package) {
                EList elts = ((Package)root_model).getOwnedElements();
                for (Element elt : elts) {
                    if (elt instanceof DataType && datatype_name.compareTo(((DataType)elt).getName()) == 0) {
                        return true;
                    }
                    if (!(elt instanceof Package) || !DataTypeQueries.isRobotMLDataType(elt, datatype_name)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return false;
    }

    public String getCppClassForDatatType(DataType dt) {
        try {
            String s = "";
            if (dt instanceof Enumeration) {
                Enumeration en = (Enumeration)dt;
                s = "enum " + en.getName() + " {" + newline;
                EList literals = en.getOwnedLiterals();
                for (EnumerationLiteral literal : literals) {
                    s = String.valueOf(s) + "\t" + literal.getName() + "," + newline;
                }
            } else if (!(dt instanceof EnumerationLiteral)) {
                EList attributes = dt.getOwnedAttributes();
                s = "class " + dt.getName() + " {" + newline + "\tpublic:" + newline;
                for (Property attribute : attributes) {
                    String type_name = attribute.getType() != null ? attribute.getType().getName() : "Unknown_NULL_IN_MODEL";
                    s = attribute.getUpper() < 0 ? String.valueOf(s) + "\tstd::vector<" + type_name + "> " + attribute.getName() + ";" + newline : (attribute.getUpper() <= 1 ? String.valueOf(s) + "\t" + type_name + " " + attribute.getName() + ";" + newline : (attribute.getUpper() == attribute.getLower() ? String.valueOf(s) + "\t" + type_name + " " + attribute.getName() + "[" + attribute.getUpper() + "];" + newline : String.valueOf(s) + "\tstd::vector<" + type_name + "> " + attribute.getName() + ";" + newline));
                }
            }
            s = String.valueOf(s) + "};" + newline;
            return s;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public List<NamedElement> getElementsDataType(Model model) {
        LinkedList<NamedElement> found_elts = new LinkedList<NamedElement>();
        for (NamedElement ne : model.getOwnedMembers()) {
            if (ne instanceof DataType) {
                found_elts.add(ne);
            }
            this.getElementsDataType((Element)ne, found_elts);
        }
        return found_elts;
    }

    private void getElementsDataType(Element parent_elt, LinkedList<NamedElement> target_list) {
        for (Element ne : parent_elt.getOwnedElements()) {
            if (ne instanceof DataType) {
                target_list.add((NamedElement)ne);
            }
            this.getElementsDataType(ne, target_list);
        }
    }

    public DataType getPortDataType(Port port) {
        Type t = port.getType();
        if (t != null && t instanceof DataType) {
            return (DataType)t;
        }
        return null;
    }

    public static boolean isPrimitiveType(Element elt) {
        return elt instanceof PrimitiveType;
    }
}

