/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.common.mmqueries;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.RobotML.DataFlowDirectionKind;
import org.eclipse.papyrus.RobotML.DataFlowPort;
import org.eclipse.papyrus.RobotML.Platform;
import org.eclipse.papyrus.RobotML.ServiceFlowKind;
import org.eclipse.papyrus.RobotML.ServicePort;
import org.eclipse.papyrus.robotml.generators.common.mmqueries.GeneralQueries;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ArchitectureQueries {
    private static boolean isSourcePort(ConnectorEnd end, Port p) {
        return ArchitectureQueries.isAnInputPort(p) != false && end.getPartWithPort() == null || ArchitectureQueries.isAnOutputPort(p) != false && end.getPartWithPort() != null;
    }

    private static boolean isDestPort(ConnectorEnd end, Port p) {
        return ArchitectureQueries.isAnOutputPort(p) != false && end.getPartWithPort() == null || ArchitectureQueries.isAnInputPort(p) != false && end.getPartWithPort() != null;
    }

    private static int getSourcePort(Connector conn, Port[] dest_port) {
        if (((ConnectorEnd)conn.getEnds().get(0)).getRole() instanceof Port) {
            Port test_1 = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
            if (ArchitectureQueries.isSourcePort((ConnectorEnd)conn.getEnds().get(0), test_1)) {
                dest_port[0] = test_1;
                return 0;
            }
            Port test_2 = (Port)((ConnectorEnd)conn.getEnds().get(1)).getRole();
            if (ArchitectureQueries.isSourcePort((ConnectorEnd)conn.getEnds().get(1), test_2)) {
                dest_port[0] = test_2;
                return 1;
            }
        }
        dest_port = null;
        return -1;
    }

    public static int getDestPort(Connector conn, Port[] dest_port) {
        if (((ConnectorEnd)conn.getEnds().get(0)).getRole() instanceof Port) {
            Port test_1 = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
            if (ArchitectureQueries.isDestPort((ConnectorEnd)conn.getEnds().get(0), test_1)) {
                dest_port[0] = test_1;
                return 0;
            }
            Port test_2 = (Port)((ConnectorEnd)conn.getEnds().get(1)).getRole();
            if (ArchitectureQueries.isDestPort((ConnectorEnd)conn.getEnds().get(1), test_2)) {
                dest_port[0] = test_2;
                return 1;
            }
        }
        dest_port = null;
        return -1;
    }

    public static String getSourcePortName(Connector conn) {
        Port[] inputPort = new Port[1];
        int index = ArchitectureQueries.getSourcePort(conn, inputPort);
        if (index < 0) {
            return "Unknown";
        }
        String inputName = inputPort[0].getName();
        return inputName;
    }

    public static String getSourceComponentTypeNameForConnector(Connector conn) {
        Property prop = ArchitectureQueries.getSourceComponentForConnector(conn);
        if (prop == null) {
            return null;
        }
        return prop.getType().getName();
    }

    public static String getSourceComponentInstanceNameForConnector(Connector conn) {
        Property prop = ArchitectureQueries.getSourceComponentForConnector(conn);
        if (prop == null) {
            return null;
        }
        return prop.getName();
    }

    public static Property getSourceComponentForConnector(Connector conn) {
        Port[] inputPort = new Port[1];
        int index = ArchitectureQueries.getSourcePort(conn, inputPort);
        if (index < 0 || ((ConnectorEnd)conn.getEnds().get(index)).getPartWithPort() == null) {
            return null;
        }
        Property input = ((ConnectorEnd)conn.getEnds().get(index)).getPartWithPort();
        return input;
    }

    public static String getDestPortName(Connector conn) {
        Port[] outputPort = new Port[1];
        int index = ArchitectureQueries.getDestPort(conn, outputPort);
        if (index < 0) {
            return "Unknown";
        }
        String outputName = outputPort[0].getName();
        return outputName;
    }

    public static Property getDestComponentForConnector(Connector conn) {
        Port[] outputPort = new Port[1];
        int index = ArchitectureQueries.getDestPort(conn, outputPort);
        if (index < 0 || ((ConnectorEnd)conn.getEnds().get(index)).getPartWithPort() == null) {
            return null;
        }
        Property output = ((ConnectorEnd)conn.getEnds().get(index)).getPartWithPort();
        return output;
    }

    public static String getDestComponentTypeNameForConnector(Connector conn) {
        Property prop = ArchitectureQueries.getDestComponentForConnector(conn);
        if (prop == null) {
            return null;
        }
        return prop.getType().getName();
    }

    public static String getDestComponentInstanceNameForConnector(Connector conn) {
        Property prop = ArchitectureQueries.getDestComponentForConnector(conn);
        if (prop == null) {
            return null;
        }
        return prop.getName();
    }

    public static List<Connector> getInternalConnectors(Class c) {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        for (Connector conn : c.getOwnedConnectors()) {
            if (conn.getEnds().size() < 2 || ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort() == null || ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort() == null) continue;
            connectors.add(conn);
        }
        return connectors;
    }

    public static List<Connector> getExternalInputConnectors(Class c) {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        for (Connector conn : c.getOwnedConnectors()) {
            if (conn.getEnds().size() < 2 || !(((ConnectorEnd)conn.getEnds().get(0)).getRole() instanceof Port) || !(((ConnectorEnd)conn.getEnds().get(1)).getRole() instanceof Port)) continue;
            Port port_1 = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
            Port port_2 = (Port)((ConnectorEnd)conn.getEnds().get(1)).getRole();
            if ((!ArchitectureQueries.isAnInputPort(port_1).booleanValue() || ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort() != null) && (!ArchitectureQueries.isAnInputPort(port_2).booleanValue() || ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort() != null)) continue;
            connectors.add(conn);
        }
        return connectors;
    }

    public static List<Connector> getExternalOutputConnectors(Class c) {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        for (Connector conn : c.getOwnedConnectors()) {
            if (conn.getEnds().size() < 2 || !(((ConnectorEnd)conn.getEnds().get(0)).getRole() instanceof Port) || !(((ConnectorEnd)conn.getEnds().get(1)).getRole() instanceof Port)) continue;
            Port port_1 = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
            Port port_2 = (Port)((ConnectorEnd)conn.getEnds().get(1)).getRole();
            if ((!ArchitectureQueries.isAnOutputPort(port_1).booleanValue() || ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort() != null) && (!ArchitectureQueries.isAnOutputPort(port_2).booleanValue() || ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort() != null)) continue;
            connectors.add(conn);
        }
        return connectors;
    }

    public static Class getRootClassForModel(Model m) {
        for (Element ne : m.getOwnedElements()) {
            if (ne instanceof Class) {
                return (Class)ne;
            }
            if (!(ne instanceof Model)) continue;
            return ArchitectureQueries.getRootClassForModel((Model)ne);
        }
        return null;
    }

    public static List<Property> getAllSubComponentsInClass(Class c) {
        LinkedList<Property> sub_components = new LinkedList<Property>();
        List<Property> level_1 = ArchitectureQueries.getLevel1SubComponentsForComponent(c);
        sub_components.addAll(level_1);
        for (Property prop : level_1) {
            List<Property> next_levels = ArchitectureQueries.getAllSubComponentsInClass((Class)prop.getType());
            sub_components.addAll(next_levels);
        }
        return sub_components;
    }

    public static List<Property> getLevel1SubComponentsForComponent(Class c) {
        LinkedList<Property> sub_components = new LinkedList<Property>();
        for (Property prop : c.getAllAttributes()) {
            Type t = prop.getType();
            if (!(t instanceof Class) || !GeneralQueries.hasStereotype((Class)t, org.eclipse.papyrus.RobotML.System.class).booleanValue()) continue;
            sub_components.add(prop);
        }
        return sub_components;
    }

    @Deprecated
    public static List<Property> getLevel1SubComponentsForComponentWithStereotype(Class c, String stereotype) {
        LinkedList<Property> sub_components = new LinkedList<Property>();
        for (Property prop : c.getAllAttributes()) {
            Type t = prop.getType();
            if (!(t instanceof Class) || !GeneralQueries.inheritsFrom((Class)t, stereotype).booleanValue()) continue;
            sub_components.add(prop);
        }
        return sub_components;
    }

    public static List<Port> getOutputPortsForElement(Element elt) {
        LinkedList<Port> found_output_ports = new LinkedList<Port>();
        for (Element child : elt.getOwnedElements()) {
            if (!(child instanceof Port) || !ArchitectureQueries.isAnOutputPort((Port)child).booleanValue()) continue;
            found_output_ports.add((Port)child);
        }
        return found_output_ports;
    }

    public static List<Port> getInputPortsForElement(Element elt) {
        LinkedList<Port> found_input_ports = new LinkedList<Port>();
        for (Element child : elt.getOwnedElements()) {
            if (!(child instanceof NamedElement) || !(child instanceof Port) || !ArchitectureQueries.isAnInputPort((Port)child).booleanValue()) continue;
            Port found_port = (Port)child;
            found_input_ports.add(found_port);
        }
        return found_input_ports;
    }

    public static List<Property> getOnPort(Parameter param) {
        LinkedList<Property> result = new LinkedList<Property>();
        for (Stereotype st : param.getAppliedStereotypes()) {
            if (!st.getName().contains("OnPort")) continue;
            for (Property p : st.getAttributes()) {
                result.add(p);
            }
        }
        return result;
    }

    public static List<NamedElement> getComponentModels(Model model) {
        LinkedList<NamedElement> found_elts = new LinkedList<NamedElement>();
        for (Element elt : model.allOwnedElements()) {
            if (!(elt instanceof Class) || !GeneralQueries.hasStereotype((Class)elt, org.eclipse.papyrus.RobotML.System.class).booleanValue() || GeneralQueries.hasStereotype((Class)elt, Platform.class).booleanValue()) continue;
            found_elts.add((NamedElement)elt);
        }
        return found_elts;
    }

    public static Boolean isRootModel(Model elt) {
        if (elt == null) {
            return false;
        }
        if (elt.getOwner() == null) {
            return true;
        }
        return false;
    }

    public static Boolean isMacroComponent(Class c) {
        boolean result = false;
        if (ArchitectureQueries.getLevel1SubComponentsForComponent(c).size() > 0) {
            result = true;
        }
        return result;
    }

    public static Boolean hasNativeImplementation(Class c) {
        org.eclipse.papyrus.RobotML.System sys = (org.eclipse.papyrus.RobotML.System)UMLUtil.getStereotypeApplication((Element)c, org.eclipse.papyrus.RobotML.System.class);
        if (sys == null) {
            return false;
        }
        return sys.isNative();
    }

    public static String getNativeLibraryPathForComponent(Class c) {
        org.eclipse.papyrus.RobotML.System sys = (org.eclipse.papyrus.RobotML.System)UMLUtil.getStereotypeApplication((Element)c, org.eclipse.papyrus.RobotML.System.class);
        if (sys == null) {
            return null;
        }
        return sys.getLibraryPath();
    }

    public static String getNativeComponentNameForComponent(Class c) {
        org.eclipse.papyrus.RobotML.System sys = (org.eclipse.papyrus.RobotML.System)UMLUtil.getStereotypeApplication((Element)c, org.eclipse.papyrus.RobotML.System.class);
        if (sys == null) {
            return null;
        }
        return sys.getLibraryComponentName();
    }

    public static int getOutputPortBufferSize(Port p) {
        DataFlowPort dfp = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)p, DataFlowPort.class);
        if (dfp == null) {
            return 0;
        }
        return dfp.getBufferSize();
    }

    public static String getComponentFileName(Class c, String end) {
        return String.valueOf(c.getName()) + end;
    }

    public static Boolean isPortConnected(Port p1) {
        if (p1.getEnds().size() > 0) {
            Connector conn = (Connector)((ConnectorEnd)p1.getEnds().get(0)).getOwner();
            return ArchitectureQueries.isConnectionValid(conn);
        }
        return false;
    }

    public static String getConnectionOtherSide(Port p1) {
        if (p1.getEnds().size() > 0) {
            Connector conn = (Connector)((ConnectorEnd)p1.getEnds().get(0)).getOwner();
            ConnectorEnd e1 = (ConnectorEnd)conn.getEnds().get(0);
            ConnectorEnd e2 = (ConnectorEnd)conn.getEnds().get(1);
            Port p2 = null;
            System.out.println("p1=" + p1.getName());
            Property c2 = null;
            if (e1.getRole() == p1) {
                p2 = (Port)e2.getRole();
                c2 = e2.getPartWithPort();
                System.out.println("1 - p2=" + p2.getName() + ", c2=" + c2.getName());
            } else if (e2.getRole() == p1) {
                p2 = (Port)e1.getRole();
                c2 = e1.getPartWithPort();
                System.out.println("2 - p2=" + p2.getName() + ", c2=" + c2.getName());
            }
            if (c2.getName().equals(((NamedElement)conn.getOwner()).getName())) {
                return "@" + p2.getName();
            }
            return "@" + c2.getName() + "." + p2.getName();
        }
        return "?????";
    }

    public static Boolean isDataFlowPort(Port port) {
        DataFlowPort dfp = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)port, DataFlowPort.class);
        if (dfp == null) {
            return false;
        }
        return true;
    }

    public static Boolean isAnInputPort(Port port) {
        try {
            DataFlowPort dfp = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)port, DataFlowPort.class);
            if (dfp == null) {
                return false;
            }
            if (dfp.getDirection() == DataFlowDirectionKind.IN) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("EXCEPTION caught:" + e.toString());
            return false;
        }
    }

    public static Boolean isAnOutputPort(Port port) {
        try {
            DataFlowPort dfp = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)port, DataFlowPort.class);
            if (dfp == null) {
                return false;
            }
            if (dfp.getDirection() == DataFlowDirectionKind.OUT) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("EXCEPTION caught:" + e.toString());
            return false;
        }
    }

    public static Boolean isAProvidedPort(Port port) {
        try {
            ServicePort sp = (ServicePort)UMLUtil.getStereotypeApplication((Element)port, ServicePort.class);
            if (sp == null) {
                return false;
            }
            if (sp.getKind() == ServiceFlowKind.PROVIDED) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("EXCEPTION caught:" + e.toString());
            return false;
        }
    }

    public static Boolean isARequiredPort(Port port) {
        try {
            ServicePort sp = (ServicePort)UMLUtil.getStereotypeApplication((Element)port, ServicePort.class);
            if (sp == null) {
                return false;
            }
            if (sp.getKind() == ServiceFlowKind.REQUIRED) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("EXCEPTION caught:" + e.toString());
            return false;
        }
    }

    public static Boolean isServicePort(Port port) {
        ServicePort serviceport = (ServicePort)UMLUtil.getStereotypeApplication((Element)port, ServicePort.class);
        if (serviceport != null) {
            return true;
        }
        return false;
    }

    public static Boolean definesConnections(Class cl) {
        if (cl.getOwnedConnectors().size() > 0) {
            return true;
        }
        return false;
    }

    public static Boolean isConnectionValid(Connector connector) {
        if (connector.getEnds().size() != 2) {
            return false;
        }
        for (ConnectorEnd cend : connector.getEnds()) {
            if (cend.getRole() != null && cend.getPartWithPort() != null) continue;
            return false;
        }
        return true;
    }

    public static String getConnectionDefinition(Connector connector) {
        ConnectorEnd e1 = (ConnectorEnd)connector.getEnds().get(0);
        ConnectorEnd e2 = (ConnectorEnd)connector.getEnds().get(1);
        return String.valueOf(e1.getPartWithPort().getName()) + "." + e1.getRole().getName() + ".connectTo(" + e2.getPartWithPort().getName() + "." + e2.getRole().getName() + ")";
    }

    public static Port getConnectedPort(Port port) {
        if (port.getEnds().size() == 0) {
            return null;
        }
        Connector conn = (Connector)((ConnectorEnd)port.getEnds().get(0)).getOwner();
        ConnectorEnd e1 = (ConnectorEnd)conn.getEnds().get(0);
        ConnectorEnd e2 = (ConnectorEnd)conn.getEnds().get(1);
        return e1.getRole() == port ? (Port)e2.getRole() : (Port)e1.getRole();
    }

    public static List<Connector> getConnectionsFromPort(Port port) {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        for (ConnectorEnd connEnd : port.getEnds()) {
            Connector conn = (Connector)connEnd.getOwner();
            if (conn.getEnds().size() < 2 || ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort() == null || ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort() == null) continue;
            connectors.add(conn);
        }
        return connectors;
    }

    public static void inspectDataFlowPort(Port port) {
        Stereotype pst = (Stereotype)port.getAppliedStereotypes().get(0);
        if (port.getType() != null) {
            System.out.println("\t\t* type: " + port.getType().getName());
        } else {
            System.err.println("\t\t\t* port " + port.getName() + " has no type ! ");
        }
        for (Property propSt : pst.getAllAttributes()) {
            System.out.println("\t\t* port stereotype has attribute: " + propSt.getName() + " - " + port.getValue(pst, propSt.getName()));
        }
    }

    public static void inspectServicePort(Port port) {
        Stereotype pst = (Stereotype)port.getAppliedStereotypes().get(0);
        if (port.getType() != null) {
            System.out.println("\t\t* type: " + port.getType().getName());
        } else {
            System.err.println("\t\t\t* port " + port.getName() + " has no type ! ");
        }
        for (Property propSt : pst.getAllAttributes()) {
            System.out.println("\t\t* port stereotype has attribute: " + propSt.getName() + " - " + port.getValue(pst, propSt.getName()));
        }
    }

    public static Boolean isAnAncestorOf(Class current_elt, Class other_elt) {
        Boolean result = false;
        if (current_elt != null && other_elt != null) {
            if (current_elt == other_elt) {
                result = true;
            } else {
                for (Class parent : current_elt.getSuperClasses()) {
                    current_elt = parent;
                    if (other_elt != current_elt) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public static Boolean isAnInputOutputPort(Port port) {
        try {
            DataFlowPort dfp = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)port, DataFlowPort.class);
            if (dfp == null) {
                return false;
            }
            if (dfp.getDirection() == DataFlowDirectionKind.INOUT) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("EXCEPTION caught:" + e.toString());
            return false;
        }
    }
}

