/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.robotml.validation.constraints.ConstraintsUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class PropertyNameVsItsTypeName
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Property subsystem = (Property)ctx.getTarget();
        if (ConstraintsUtil.verifyRobotMLApplied((Element)subsystem).booleanValue()) {
            if (subsystem.getType() == null) {
                return ctx.createFailureStatus(new Object[]{"Property (subsystem or attribute) should have a Type" + subsystem.getQualifiedName()});
            }
            String typeName = subsystem.getType().getName();
            if (subsystem.getName().replaceAll(" ", "").compareToIgnoreCase("") == 0) {
                if (subsystem instanceof Port) {
                    return ctx.createFailureStatus(new Object[]{"Port  should have a name "});
                }
                return ctx.createFailureStatus(new Object[]{"Property (subsystem or attribute) should have a name " + subsystem.getQualifiedName()});
            }
            if (subsystem.getName().compareToIgnoreCase(typeName) == 0) {
                if (subsystem instanceof Port) {
                    return ctx.createFailureStatus(new Object[]{"Port  should have a name diffrent from its Type name" + subsystem.getQualifiedName()});
                }
                return ctx.createFailureStatus(new Object[]{"Property (subsystem or attribute) should have a name diffrent from its Type name " + subsystem.getQualifiedName()});
            }
        }
        return ctx.createSuccessStatus();
    }
}

