/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.robotml.deployment.Copy;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class Utils {
    public static NamedElement getNamedElementFromList(EList<? extends NamedElement> namedElementList, String name) {
        for (NamedElement namedElement : namedElementList) {
            if (!namedElement.getName().equals(name)) continue;
            return namedElement;
        }
        return null;
    }

    public static Package getTop(Element element) {
        while (element != null) {
            Element owner = element.getOwner();
            if (owner == null && element instanceof Package) {
                return (Package)element;
            }
            element = owner;
        }
        return null;
    }

    public static Package getRoot(Element element, String subfolder) {
        Package root = Utils.getTop(element);
        if (root.getNestedPackage(subfolder) != null) {
            return root.getNestedPackage(subfolder);
        }
        return root.createNestedPackage(subfolder);
    }

    public static Operation createOwnedOperation(Classifier cl, String name, EList<String> paramNames, EList<Type> paramTypes, Type retType) {
        if (cl instanceof Class) {
            return ((Class)cl).createOwnedOperation(name, paramNames, paramTypes, retType);
        }
        if (cl instanceof Interface) {
            return ((Interface)cl).createOwnedOperation(name, paramNames, paramTypes, retType);
        }
        return null;
    }

    public static Operation getOwnedOperation(Classifier cl, String name, EList<String> paramNames, EList<Type> paramTypes) {
        if (cl instanceof Class) {
            return ((Class)cl).getOwnedOperation(name, paramNames, paramTypes);
        }
        if (cl instanceof Interface) {
            return ((Interface)cl).getOwnedOperation(name, paramNames, paramTypes);
        }
        return null;
    }

    public static Class componentType(Class implementation) {
        if (Utils.isCompImpl((Classifier)implementation)) {
            for (Class componentType : implementation.getSuperClasses()) {
                if (!Utils.isCompType(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static boolean isComposite(Class implementation) {
        return Utils.isCompImpl((Classifier)implementation) && Utils.getParts(implementation).size() > 0;
    }

    public static EList<Property> getParts(Class implementation) {
        return implementation.getParts();
    }

    public static boolean isComposition(Property attribute) {
        if (Utils.treatNoneAsComposite()) {
            return attribute.getAggregation() != AggregationKind.SHARED_LITERAL;
        }
        return attribute.getAggregation() == AggregationKind.COMPOSITE_LITERAL;
    }

    public static boolean isComposite(InstanceSpecification is) {
        return is.getSlots().size() > 0;
    }

    public static NamedElement getQualifiedElement(Package root, String qualifiedName) {
        NamedElement namedElement = null;
        int index = qualifiedName.indexOf("::");
        if (index != -1) {
            String remainder = qualifiedName.substring(index + 2);
            namedElement = Utils.getQualifiedElement(root, remainder, qualifiedName);
        }
        if (namedElement == null) {
            namedElement = Utils.getQualifiedElement(root, qualifiedName, String.valueOf(root.getName()) + "::" + qualifiedName);
        }
        return namedElement;
    }

    public static NamedElement getQualifiedElement(Package root, String remainingPath, String qualifiedName) {
        if (root == null) {
            return null;
        }
        if (!remainingPath.contains("::")) {
            for (NamedElement candidate : root.getMembers()) {
                String name = candidate.getName();
                if (name == null || !name.equals(remainingPath) || !candidate.getQualifiedName().equals(qualifiedName)) continue;
                return candidate;
            }
        } else {
            String segment = remainingPath.split("::")[0];
            String remainder = remainingPath.substring(segment.length() + 2);
            for (Element element : root.getMembers()) {
                NamedElement foundElement;
                if (!(element instanceof Package) || !((NamedElement)element).getName().equals(segment) || (foundElement = Utils.getQualifiedElement((Package)element, remainder, qualifiedName)) == null) continue;
                return foundElement;
            }
        }
        return null;
    }

    public static boolean isElementInDifferentModel(Package model, NamedElement namedElement) {
        return model != Utils.getTop((Element)namedElement);
    }

    public static boolean isElementImported(Copy sat, NamedElement namedElement) {
        if (Utils.isElementInDifferentModel(sat.source, namedElement)) {
            String qualifiedName = namedElement.getQualifiedName();
            int index = qualifiedName.indexOf("::");
            if (index != -1) {
                qualifiedName = qualifiedName.substring(index + 2);
            }
            if (Utils.getQualifiedElement(sat.target, qualifiedName) != null) {
                return true;
            }
        }
        return false;
    }

    public static NamedElement getExistingNEinTarget(Copy sat, NamedElement namedElement) {
        if (sat.copyExtReferences) {
            return Utils.getExistingElement(sat.target, namedElement, false);
        }
        if (Utils.isElementInDifferentModel(sat.source, namedElement)) {
            return namedElement;
        }
        return Utils.getExistingElement(sat.target, namedElement, false);
    }

    public static NamedElement getExistingElement(Package model, NamedElement namedElement, boolean skipTop) {
        EList list = namedElement.allNamespaces();
        int offset = skipTop ? 2 : 1;
        Package currentPkg = model;
        int i = list.size() - offset;
        while (i >= 0) {
            String name = ((Namespace)list.get(i)).getName();
            NamedElement member = currentPkg.getMember(name);
            if (!(member instanceof Package)) {
                return null;
            }
            currentPkg = (Package)member;
            --i;
        }
        String name = namedElement.getName();
        return currentPkg.getMember(name);
    }

    public static boolean hasNonPortOwnedAttribute(Class cl, String name) {
        for (Property p : cl.getOwnedAttributes()) {
            if (p instanceof Port || !p.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static <T extends EObject> EList<T> getAllElementsOfType(Element examineElement, java.lang.Class<T> clazz) {
        BasicEList visitedPackages = new BasicEList();
        return Utils.getAllElementsOfType(examineElement, clazz, (EList<Element>)visitedPackages);
    }

    public static <T extends EObject> EList<T> getAllElementsOfType(Element examineElement, java.lang.Class<T> clazz, EList<Element> visitedPackages) {
        UniqueEList list = new UniqueEList();
        for (Element element : examineElement.allOwnedElements()) {
            if (element instanceof Package) {
                if (visitedPackages.contains((Object)element)) continue;
                visitedPackages.add((Object)element);
                list.addAll(Utils.getAllElementsOfType(element, clazz, visitedPackages));
                continue;
            }
            if (!clazz.isInstance(element)) continue;
            list.add((Object)element);
        }
        return list;
    }

    public static Package getUserModel() {
        try {
            EList resources = ServiceUtils.getInstance().getModelSet(null).getResources();
            if (resources.size() >= 3) {
                int i = 0;
                while (i < 3) {
                    EObject topEObj;
                    Resource userResource = (Resource)resources.get(i);
                    if (userResource.getContents().size() > 0 && (topEObj = (EObject)userResource.getContents().get(0)) instanceof Package) {
                        return (Package)topEObj;
                    }
                    ++i;
                }
            }
        }
        catch (ServiceException serviceException) {}
        return null;
    }

    public static boolean isCompImpl(Classifier implementation) {
        return !implementation.isAbstract();
    }

    public static boolean isCompType(Class component) {
        return component.isAbstract();
    }

    public static boolean treatNoneAsComposite() {
        return true;
    }

    public static boolean isComponent(Class component) {
        return Utils.isCompType(component) || Utils.isCompImpl((Classifier)component);
    }

    public static String getAbsoluteFN(String fileName) {
        try {
            URL absoluteURL = FileLocator.toFileURL((URL)new URL(fileName));
            return absoluteURL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }
}

