/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.TransformationException;
import org.eclipse.papyrus.robotml.deployment.Utils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class DepCreation {
    private static Map<Object, Integer> map;

    public static Slot createSlot(InstanceSpecification is, InstanceSpecification partIS, Property part) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)part);
        InstanceValue iv = (InstanceValue)slot.createValue(null, null, UMLPackage.eINSTANCE.getInstanceValue());
        iv.setInstance(partIS);
        return slot;
    }

    public static Slot createSlotForConfigProp(InstanceSpecification is, Property attribute) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)attribute);
        Type type = attribute.getType();
        if (type != null) {
            String name = type.getName();
            type.getQualifiedName();
            if (name.equals("Integer")) {
                slot.createValue("value for " + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralInteger());
            } else if (name.equals("Boolean")) {
                slot.createValue("value for " + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralBoolean());
            } else {
                slot.createValue("value for " + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralString());
            }
        }
        return slot;
    }

    public static Slot createStringSlotForConfigProp(InstanceSpecification is, Property attribute) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)attribute);
        Type type = attribute.getType();
        if (type != null) {
            slot.createValue("value for " + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralString());
        }
        return slot;
    }

    public static InstanceSpecification createDepPlan(Package cdp, Class typeOrImplem, String name, boolean createSlotsForConfigValues) throws TransformationException {
        return DepCreation.createDepPlan(cdp, typeOrImplem, name, createSlotsForConfigValues, new Stack<Classifier>());
    }

    public static InstanceSpecification createDepPlan(Package cdp, Class typeOrImplem, String name, boolean createSlotsForConfigValues, Stack<Classifier> visitedClassifiers) throws TransformationException {
        if (visitedClassifiers.contains(typeOrImplem)) {
            String path = "";
            for (Classifier cl : visitedClassifiers) {
                if (path.length() > 0) {
                    path = String.valueOf(path) + ", ";
                }
                path = String.valueOf(path) + cl.getName();
            }
            path = String.valueOf(path) + ", " + typeOrImplem.getName();
            throw new TransformationException("Class \"" + typeOrImplem.getQualifiedName() + "\" is referenced in a circle! Thus, an infinite number of instance specifications would be required.\n\n" + "recursion path: " + path);
        }
        visitedClassifiers.push((Classifier)typeOrImplem);
        InstanceSpecification is = (InstanceSpecification)cdp.createPackagedElement(name, UMLPackage.eINSTANCE.getInstanceSpecification());
        if (name.equals("mainInstance")) {
            DepUtils.setMainInstance(cdp, is);
        }
        Class implementation = null;
        if ((Utils.isCompImpl((Classifier)typeOrImplem) || typeOrImplem instanceof Node) && typeOrImplem instanceof Class) {
            implementation = typeOrImplem;
        }
        if (!(implementation instanceof Class)) {
            throw new TransformationException("cannot find suitable implementation for instance <" + name + "> (given type <" + typeOrImplem.getName() + ">)");
        }
        is.getClassifiers().add((Object)implementation);
        for (Property attribute : implementation.getAllAttributes()) {
            if (attribute instanceof Port) continue;
            Type type = attribute.getType();
            if (Utils.isComposition(attribute)) {
                if ((!(type instanceof Class) || !Utils.isComponent((Class)type)) && !(type instanceof Node)) continue;
                Class cl = (Class)type;
                int upper = attribute.getUpper();
                String infix = "";
                int i = 0;
                while (i < upper) {
                    String partName = String.valueOf(name) + "." + attribute.getName();
                    if (upper > 1) {
                        partName = String.valueOf(partName) + "_" + infix + i;
                    }
                    InstanceSpecification partIS = DepCreation.createDepPlan(cdp, cl, partName, createSlotsForConfigValues, visitedClassifiers);
                    DepCreation.createSlot(is, partIS, attribute);
                    ++i;
                }
                continue;
            }
            if (type instanceof Class || type != null) continue;
            throw new TransformationException("type of attribute \"" + attribute.getName() + "\" within class \"" + implementation.getName() + "\" is not defined");
        }
        visitedClassifiers.pop();
        return is;
    }

    public static InstanceSpecification createPlatformInstances(Package platform, Class implementation, String name) throws TransformationException {
        InstanceSpecification is = null;
        if (name != null) {
            is = (InstanceSpecification)platform.createPackagedElement(name, UMLPackage.eINSTANCE.getInstanceSpecification());
            is.getClassifiers().add((Object)implementation);
        }
        for (Property attribute : implementation.getAllAttributes()) {
            if (attribute instanceof Port) continue;
            Type type = attribute.getType();
            if (!Utils.isComposition(attribute) || !(type instanceof Class)) continue;
            Class cl = (Class)type;
            int upper = attribute.getUpper();
            String infix = "";
            int i = 0;
            while (i < upper) {
                String partName = name != null ? String.valueOf(name) + "." : "";
                partName = String.valueOf(partName) + attribute.getName();
                if (upper > 1) {
                    partName = String.valueOf(partName) + "_" + infix + i;
                }
                InstanceSpecification partIS = DepCreation.createPlatformInstances(platform, cl, partName);
                if (is != null) {
                    DepCreation.createSlot(is, partIS, attribute);
                }
                ++i;
            }
        }
        return is;
    }

    public static void initAutoValues(InstanceSpecification is) {
        map = new HashMap<Object, Integer>();
        DepCreation.initAutoValuesHelper(is);
        Stack<InstanceSpecification> isStack = new Stack<InstanceSpecification>();
        DepCreation.copyAutoValues(isStack, is);
    }

    public static void initAutoValuesHelper(InstanceSpecification is) {
        for (Slot slot : is.getSlots()) {
            slot.getDefiningFeature();
        }
    }

    public static void copyAutoValues(Stack<InstanceSpecification> isStack, InstanceSpecification is) {
        isStack.push(is);
        for (Slot slot : is.getSlots()) {
            StructuralFeature sf = slot.getDefiningFeature();
            if (sf == null) {
                System.err.println(is.getName());
                break;
            }
            for (ValueSpecification vs : slot.getValues()) {
                InstanceSpecification subIS;
                if (!(vs instanceof InstanceValue) || (subIS = ((InstanceValue)vs).getInstance()) == null) continue;
                DepCreation.copyAutoValues(isStack, subIS);
            }
        }
        isStack.pop();
    }

    public static ValueSpecification getNearestValue(Stack<InstanceSpecification> isStack, Property source) {
        Stack<InstanceSpecification> copy = new Stack<InstanceSpecification>();
        copy.addAll(isStack);
        while (!copy.isEmpty()) {
            InstanceSpecification pop = (InstanceSpecification)copy.pop();
            ValueSpecification vs = DepCreation.getNearestValueHelper(isStack, pop, source);
            if (vs == null) continue;
            return vs;
        }
        return null;
    }

    public static ValueSpecification getNearestValueHelper(Stack<InstanceSpecification> isStack, InstanceSpecification is, Property source) {
        for (Slot slot : is.getSlots()) {
            StructuralFeature sf = slot.getDefiningFeature();
            if (sf == source) {
                Iterator iterator = slot.getValues().iterator();
                if (iterator.hasNext()) {
                    ValueSpecification vs = (ValueSpecification)iterator.next();
                    return vs;
                }
                return null;
            }
            for (ValueSpecification vs : slot.getValues()) {
                InstanceSpecification subIS;
                if (!(vs instanceof InstanceValue) || isStack.contains(subIS = ((InstanceValue)vs).getInstance())) continue;
                return DepCreation.getNearestValueHelper(isStack, subIS, source);
            }
        }
        return null;
    }
}

