/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.RobotML.Allocate;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class AllocUtils {
    public static EList<InstanceSpecification> getAllNodes(InstanceSpecification instance) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodes((NamedElement)instance);
        for (InstanceSpecification containedInstance : DepUtils.getContainedInstances(instance)) {
            nodeList.addAll(AllocUtils.getAllNodes(containedInstance));
        }
        return nodeList;
    }

    public static EList<InstanceSpecification> getAllNodesOrThreadsParent(InstanceSpecification instance) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodesOrThreads((NamedElement)instance);
        Package cdp = instance.getNearestPackage();
        for (NamedElement parentNE : cdp.getMembers()) {
            InstanceSpecification parentIS;
            if (!(parentNE instanceof InstanceSpecification) || !DepUtils.getContainedInstances(parentIS = (InstanceSpecification)parentNE).contains((Object)instance)) continue;
            nodeList.addAll(AllocUtils.getAllNodesOrThreadsParent(parentIS));
        }
        return nodeList;
    }

    public static InstanceSpecification getNode(InstanceSpecification instance) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodes((NamedElement)instance);
        if (nodeList.size() != 0) {
            return (InstanceSpecification)nodeList.get(0);
        }
        return null;
    }

    public static InstanceSpecification getNodeOrThread(InstanceSpecification instanceOrThread) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodesOrThreads((NamedElement)instanceOrThread);
        if (nodeList.size() != 0) {
            return (InstanceSpecification)nodeList.get(0);
        }
        return null;
    }

    public static EList<InstanceSpecification> getNodesOrThreads(NamedElement instanceOrThread) {
        UniqueEList nodeList = new UniqueEList();
        for (DirectedRelationship relationship : instanceOrThread.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getAbstraction())) {
            Abstraction abstraction = (Abstraction)relationship;
            if (!StUtils.isApplied((Element)abstraction, Allocate.class)) continue;
            for (Element target : abstraction.getTargets()) {
                if (!(target instanceof InstanceSpecification)) continue;
                nodeList.add((Object)((InstanceSpecification)target));
            }
        }
        return nodeList;
    }

    public static EList<InstanceSpecification> getNodes(NamedElement instanceOrThread) {
        UniqueEList nodeList = new UniqueEList();
        EList<InstanceSpecification> nodeOrThreads = AllocUtils.getNodesOrThreads(instanceOrThread);
        for (InstanceSpecification nodeOrThread : nodeOrThreads) {
            DepUtils.getClassifier(nodeOrThread);
            nodeList.add((Object)nodeOrThread);
        }
        return nodeList;
    }

    public static EList<Node> updateAllocation(InstanceSpecification instance, InstanceSpecification oldNode, InstanceSpecification newNode) {
        UniqueEList nodeList = new UniqueEList();
        block0: for (Abstraction abstraction : instance.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getAbstraction())) {
            if (!StUtils.isApplied((Element)abstraction, Allocate.class)) continue;
            EList suppliers = abstraction.getSuppliers();
            int index = 0;
            while (index < suppliers.size()) {
                if (suppliers.get(index) == oldNode) {
                    if (newNode == null) {
                        abstraction.destroy();
                        continue block0;
                    }
                    suppliers.set(index, (Object)newNode);
                    continue block0;
                }
                ++index;
            }
        }
        return nodeList;
    }

    public static boolean allocate(InstanceSpecification instance, InstanceSpecification node) {
        Package cdp = (Package)instance.getOwner();
        Abstraction allocation = (Abstraction)cdp.createPackagedElement("allocate to " + node.getName(), UMLPackage.eINSTANCE.getAbstraction());
        if (StUtils.apply((Element)allocation, Allocate.class) == null) {
            return false;
        }
        allocation.getClients().add((Object)instance);
        allocation.getSuppliers().add((Object)node);
        return true;
    }
}

