/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.diagram.common.migration;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.robotml.diagram.common.Activator;
import org.eclipse.ui.handlers.HandlerUtil;

public class MigrateDiagramsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection.isEmpty() || !(currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        Object selectedElement = selection.getFirstElement();
        Object selectedAdapter = Platform.getAdapterManager().getAdapter(selectedElement, IFile.class);
        if (selectedAdapter instanceof IFile) {
            final IFile selectedFile = (IFile)selectedAdapter;
            Job openDialogJob = new Job("Switch profile"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Migrating model...", -1);
                    ModelSet modelSet = new ModelSet();
                    ModelsReader reader = new ModelsReader();
                    reader.readModel(modelSet);
                    IPath workspacePath = selectedFile.getFullPath();
                    URI workspaceURI = URI.createPlatformResourceURI((String)workspacePath.toString(), (boolean)true);
                    ViewPrototype protoArchitecture = null;
                    ViewPrototype protoDatatypeDef = null;
                    ViewPrototype protoInterfaceDef = null;
                    ViewPrototype protoComponentDef = null;
                    for (ViewPrototype proto : PolicyChecker.getCurrent().getAllPrototypes()) {
                        if (proto.getLabel().contains("RobotML Architecture")) {
                            protoArchitecture = proto;
                            continue;
                        }
                        if (proto.getLabel().contains("RobotML Component")) {
                            protoComponentDef = proto;
                            continue;
                        }
                        if (proto.getLabel().contains("RobotML Interface")) {
                            protoInterfaceDef = proto;
                            continue;
                        }
                        if (!proto.getLabel().contains("RobotML Datatype")) continue;
                        protoDatatypeDef = proto;
                    }
                    try {
                        modelSet.loadModels(workspaceURI);
                        NotationModel notationModel = (NotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
                        if (notationModel != null) {
                            Resource mainNotationResource = notationModel.getResource();
                            TreeIterator allContents = mainNotationResource.getAllContents();
                            while (allContents.hasNext()) {
                                EObject currentElement = (EObject)allContents.next();
                                if (!(currentElement instanceof Diagram)) continue;
                                if (((Diagram)currentElement).getType().equalsIgnoreCase("architecture")) {
                                    ((Diagram)currentElement).setType("CompositeStructure");
                                    DiagramUtils.setPrototype((Diagram)((Diagram)currentElement), (ViewPrototype)protoArchitecture);
                                    DiagramUtils.setOwner((Diagram)((Diagram)currentElement), (EObject)((Diagram)currentElement).getElement());
                                    continue;
                                }
                                if (((Diagram)currentElement).getType().equalsIgnoreCase("componentdef")) {
                                    ((Diagram)currentElement).setType("CompositeStructure");
                                    DiagramUtils.setPrototype((Diagram)((Diagram)currentElement), (ViewPrototype)protoComponentDef);
                                    DiagramUtils.setOwner((Diagram)((Diagram)currentElement), (EObject)((Diagram)currentElement).getElement());
                                    continue;
                                }
                                if (((Diagram)currentElement).getType().equalsIgnoreCase("datatypedef")) {
                                    ((Diagram)currentElement).setType("PapyrusUMLClassDiagram");
                                    DiagramUtils.setPrototype((Diagram)((Diagram)currentElement), (ViewPrototype)protoDatatypeDef);
                                    DiagramUtils.setOwner((Diagram)((Diagram)currentElement), (EObject)((Diagram)currentElement).getElement());
                                    continue;
                                }
                                if (!((Diagram)currentElement).getType().equalsIgnoreCase("interfacedef")) continue;
                                ((Diagram)currentElement).setType("PapyrusUMLClassDiagram");
                                DiagramUtils.setPrototype((Diagram)((Diagram)currentElement), (ViewPrototype)protoInterfaceDef);
                                DiagramUtils.setOwner((Diagram)((Diagram)currentElement), (EObject)((Diagram)currentElement).getElement());
                            }
                            mainNotationResource.save(null);
                        }
                    }
                    catch (ModelMultiException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.robotml.diagram.common", e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.robotml.diagram.common", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            openDialogJob.setUser(true);
            openDialogJob.schedule();
        }
        return null;
    }
}

