/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.export;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.requirements.export.Activator;
import org.eclipse.papyrus.sysml16.requirements.Requirement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExportRequirementCommandHandler
extends AbstractCommandHandler {
    private final String FS = ";";

    protected Command getCommand(IEvaluationContext context) {
        Package myPackage;
        String currentName;
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof Package && (currentName = (myPackage = (Package)selectedElements.get(0)).getName()) != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "ExportCommand", null, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                    dialog.setText("Save requirements as");
                    dialog.setFileName(String.valueOf(currentName) + ".csv");
                    dialog.setFilterPath(System.getProperty("user.home"));
                    dialog.setOverwrite(true);
                    String result = dialog.open();
                    if (result != null) {
                        try {
                            ExportRequirementCommandHandler.this.saveRequirements(result);
                        }
                        catch (IOException e) {
                            Activator.log.error("can't save to file " + result, (Throwable)e);
                        }
                    }
                    return CommandResult.newOKCommandResult();
                }

                public boolean canUndo() {
                    return false;
                }
            };
            return new GMFtoEMFCommandWrapper((ICommand)cmd);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Collection<Requirement> getRequirements(Package pkg) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (NamedElement member : pkg.getMembers()) {
            Requirement requirement = (Requirement)UMLUtil.getStereotypeApplication((Element)member, Requirement.class);
            if (requirement == null) continue;
            requirements.add(requirement);
        }
        return requirements;
    }

    private void saveRequirements(String filename) throws IOException {
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1) {
            Package selectedPackage = (Package)selectedElements.get(0);
            ArrayList<String> msg = new ArrayList<String>();
            this.addRequirements(selectedPackage, msg);
            Path path = Paths.get(filename, new String[0]);
            Files.write(path, msg, Charset.forName(System.getProperty("file.encoding", "UTF-8")), new OpenOption[0]);
        }
    }

    private void addRequirements(Package pkg, List<String> list) {
        for (Requirement req : this.getRequirements(pkg)) {
            list.add(this.getRow(req));
            EList classList = req.getBase_Class().getNestedClassifiers();
            for (Classifier classifier : classList) {
                Requirement requirement = (Requirement)UMLUtil.getStereotypeApplication((Element)classifier, Requirement.class);
                if (requirement == null) continue;
                list.add(this.getRow(requirement));
            }
        }
        for (PackageableElement subPkg : pkg.getPackagedElements()) {
            if (!(subPkg instanceof Package)) continue;
            this.addRequirements((Package)subPkg, list);
        }
    }

    protected String formatCsvField(String field) {
        String ret = "";
        if (field != null) {
            ret = field;
        }
        if (ret.contains("\"") || ret.contains(";")) {
            String newField = field.replace("\"", "\"\"");
            ret = ret.length() > 1 && newField.startsWith("\"") && newField.endsWith("\"") ? newField : "\"" + newField + "\"";
        }
        if (ret.contains("\r\n")) {
            ret = ret.replace("\r\n", " ");
        }
        if (ret.contains("\n")) {
            ret = ret.replace("\n", " ");
        }
        return ret;
    }

    private String getRow(Requirement req) {
        ArrayList<String> list = new ArrayList<String>();
        Package ppackage = req.getBase_Class().getPackage();
        if (ppackage != null) {
            list.add(this.formatCsvField(ppackage.getQualifiedName()));
        } else {
            list.add("");
        }
        list.add(req.getId());
        list.add(this.formatCsvField(req.getBase_Class().getName()));
        list.add(this.formatCsvField(req.getText()));
        return list.stream().collect(Collectors.joining(";"));
    }
}

