/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.assistant.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.requirements.sysml.assistant.commands.DecomposeReqCommand;
import org.eclipse.papyrus.requirements.sysml.common.Utils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class InitDecomposeReqCommand
extends RecordingCommand {
    protected Element selectedElement;
    TransactionalEditingDomain domain;

    public InitDecomposeReqCommand(TransactionalEditingDomain domain, Element selectedElement) {
        super(domain, "DecomposeReqCommand");
        this.selectedElement = selectedElement;
        this.domain = domain;
    }

    protected void doExecute() {
        String concatenedString = "";
        Package owner = null;
        if (this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement") != null) {
            Stereotype stereotype = this.selectedElement.getAppliedStereotype("SysML::Requirements::Requirement");
            concatenedString = String.valueOf(concatenedString) + this.selectedElement.getValue(stereotype, "text");
            owner = this.selectedElement.getNearestPackage();
            String id = Utils.getNewRequirementID((Element)((Class)this.selectedElement));
            Class req = owner.createOwnedClass(id, false);
            Stereotype reqStereotype = req.getApplicableStereotype("SysML::Requirements::Requirement");
            req.applyStereotype(reqStereotype);
            req.setValue(reqStereotype, "text", (Object)concatenedString);
            req.setValue(reqStereotype, "id", (Object)id);
            DecomposeReqCommand decompositionReqCreateCommand = new DecomposeReqCommand(this.domain, req, (Class)this.selectedElement);
            decompositionReqCreateCommand.execute();
        }
    }
}

