/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.m2m.qvt.oml.debug.core.IQVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugElement;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOValue;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;

public class QVTOVariable
extends QVTODebugElement
implements IVariable {
    private final VMVariable fUnderlyingVar;
    private final IValue fValue;

    QVTOVariable(IQVTODebugTarget debugTarget, VMVariable vmVar, long frameID) {
        super(debugTarget);
        this.fUnderlyingVar = vmVar;
        this.fValue = new QVTOValue(this.getQVTODebugTarget(), vmVar, frameID);
    }

    public boolean isModelParameter() {
        return this.fUnderlyingVar.kind == 4;
    }

    public boolean isLocalVariable() {
        return this.fUnderlyingVar.kind == 0;
    }

    public boolean isCollectionElement() {
        return this.fUnderlyingVar.kind == 6;
    }

    public boolean isPredefinedVariable() {
        return this.fUnderlyingVar.kind == 3;
    }

    public boolean isIntermProperty() {
        return this.fUnderlyingVar.kind == 5;
    }

    public boolean isAttribute() {
        return this.fUnderlyingVar.kind == 1;
    }

    public boolean isReference() {
        return this.fUnderlyingVar.kind == 2;
    }

    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    public String getName() throws DebugException {
        return this.fUnderlyingVar.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fUnderlyingVar.type.declaringType;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }
}

