/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.text.DecimalFormat;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.dialogs.ChartRangeValues;

public class ChartRangeDialog
extends TitleAreaDialog {
    private ScrollableChart scrollableChart;
    private Text textStartX;
    private Text textStopX;
    private Combo comboScaleX;
    private Text textStartY;
    private Text textStopY;
    private Combo comboScaleY;
    private ChartRangeValues chartRangeValues = new ChartRangeValues();

    public ChartRangeDialog(Shell parent, ScrollableChart scrollableChart) {
        super(parent);
        this.scrollableChart = scrollableChart;
    }

    public ChartRangeValues getChartRangeValues() {
        return this.chartRangeValues;
    }

    public void create() {
        super.create();
        this.setTitle("Chart Range");
        this.setMessage("Set the chart to a defined range.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createSectionAxisX(composite);
        this.createSectionAxisY(composite);
        this.initialize();
        return container;
    }

    protected void okPressed() {
        this.chartRangeValues.setAxisX(this.comboScaleX.getSelectionIndex());
        this.chartRangeValues.setStartX(this.textStartX.getText().trim());
        this.chartRangeValues.setStopX(this.textStopX.getText().trim());
        this.chartRangeValues.setAxisY(this.comboScaleY.getSelectionIndex());
        this.chartRangeValues.setStartY(this.textStartY.getText().trim());
        this.chartRangeValues.setStopY(this.textStopY.getText().trim());
        super.okPressed();
    }

    private void createSectionAxisX(Composite parent) {
        this.textStartX = new Text(parent, 2048);
        this.textStartX.setText("");
        this.textStartX.setLayoutData((Object)this.getTextGridData());
        this.textStopX = new Text(parent, 2048);
        this.textStopX.setText("");
        this.textStopX.setLayoutData((Object)this.getTextGridData());
        this.comboScaleX = new Combo(parent, 8);
        this.comboScaleX.setLayoutData((Object)this.getComboGridData());
        this.comboScaleX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ChartRangeDialog.this.comboScaleX.getSelectionIndex();
                BaseChart baseChart = ChartRangeDialog.this.scrollableChart.getBaseChart();
                IAxis xAxis = baseChart.getAxisSet().getXAxis(selectionIndex);
                Range rangeX = xAxis.getRange();
                if (rangeX != null) {
                    DecimalFormat decimalFormatX = baseChart.getDecimalFormat("X_AXIS", selectionIndex);
                    ChartRangeDialog.this.textStartX.setText(decimalFormatX.format(rangeX.lower));
                    ChartRangeDialog.this.textStopX.setText(decimalFormatX.format(rangeX.upper));
                }
            }
        });
    }

    private void createSectionAxisY(Composite parent) {
        this.textStartY = new Text(parent, 2048);
        this.textStartY.setText("");
        this.textStartY.setLayoutData((Object)this.getTextGridData());
        this.textStopY = new Text(parent, 2048);
        this.textStopY.setText("");
        this.textStopY.setLayoutData((Object)this.getTextGridData());
        this.comboScaleY = new Combo(parent, 8);
        this.comboScaleY.setLayoutData((Object)this.getComboGridData());
        this.comboScaleY.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ChartRangeDialog.this.comboScaleY.getSelectionIndex();
                BaseChart baseChart = ChartRangeDialog.this.scrollableChart.getBaseChart();
                IAxis yAxis = baseChart.getAxisSet().getYAxis(selectionIndex);
                Range rangeY = yAxis.getRange();
                if (rangeY != null) {
                    DecimalFormat decimalFormatY = baseChart.getDecimalFormat("Y_AXIS", selectionIndex);
                    ChartRangeDialog.this.textStartY.setText(decimalFormatY.format(rangeY.lower));
                    ChartRangeDialog.this.textStopY.setText(decimalFormatY.format(rangeY.upper));
                }
            }
        });
    }

    private GridData getTextGridData() {
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        return gridData;
    }

    private GridData getComboGridData() {
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        return gridData;
    }

    private void initialize() {
        IChartSettings chartSettings = this.scrollableChart.getChartSettings();
        BaseChart baseChart = this.scrollableChart.getBaseChart();
        String[] axisLabelsX = baseChart.getAxisLabels("X_AXIS");
        this.comboScaleX.setItems(axisLabelsX);
        if (axisLabelsX.length > 0) {
            int selectedIndex = chartSettings.getRangeSelectorDefaultAxisX();
            if (selectedIndex >= 0 && selectedIndex < axisLabelsX.length) {
                this.comboScaleX.select(selectedIndex);
            } else {
                this.comboScaleX.select(0);
            }
        }
        String[] axisLabelsY = baseChart.getAxisLabels("Y_AXIS");
        this.comboScaleY.setItems(axisLabelsY);
        if (axisLabelsY.length > 0) {
            int selectedIndex = chartSettings.getRangeSelectorDefaultAxisY();
            if (selectedIndex >= 0 && selectedIndex < axisLabelsY.length) {
                this.comboScaleY.select(selectedIndex);
            } else {
                this.comboScaleY.select(0);
            }
        }
        this.setCurrentValues();
    }

    private void setCurrentValues() {
        BaseChart baseChart = this.scrollableChart.getBaseChart();
        int indexX = this.comboScaleX.getSelectionIndex() >= 0 ? this.comboScaleX.getSelectionIndex() : 0;
        int indexY = this.comboScaleY.getSelectionIndex() >= 0 ? this.comboScaleY.getSelectionIndex() : 0;
        IAxis xAxis = baseChart.getAxisSet().getXAxis(indexX);
        IAxis yAxis = baseChart.getAxisSet().getYAxis(indexY);
        Range rangeX = xAxis.getRange();
        Range rangeY = yAxis.getRange();
        DecimalFormat decimalFormatX = baseChart.getDecimalFormat("X_AXIS", indexX);
        DecimalFormat decimalFormatY = baseChart.getDecimalFormat("Y_AXIS", indexY);
        if (rangeX != null && rangeY != null) {
            this.textStartX.setText(decimalFormatX.format(rangeX.lower));
            this.textStopX.setText(decimalFormatX.format(rangeX.upper));
            this.textStartY.setText(decimalFormatY.format(rangeY.lower));
            this.textStopY.setText(decimalFormatY.format(rangeY.upper));
        } else {
            this.textStartX.setText("");
            this.textStopX.setText("");
            this.textStartY.setText("");
            this.textStopY.setText("");
        }
    }
}

