/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class FoldingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_FOLDING_ENABLED = "foldingReconcilingStrategy.enabled";
    public static final String PREF_AUTOFOLD_COMMENTS = "foldingReconcilingStrategy.collapseComments";
    public static final String PREF_AUTOFOLD_LICENSE_HEADERS_COMMENTS = "foldingReconcilingStrategy.collapseLicenseHeaders";
    public static final String PREF_AUTOFOLD_REGIONS = "foldingReconcilingStrategy.collapseRegions";
    public static final String PREF_AUTOFOLD_IMPORT_STATEMENTS = "foldingReconcilingStrategy.collapseImports";

    public FoldingPreferencePage() {
        super(1);
        this.setPreferenceStore(LanguageServerPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor foldingEnabled = new BooleanFieldEditor(PREF_FOLDING_ENABLED, "Enable folding", parent);
        this.addField((FieldEditor)foldingEnabled);
        Label label = new Label(parent, 0);
        label.setText("\nInitially fold these elements:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BooleanFieldEditor autoFoldComments = new BooleanFieldEditor(PREF_AUTOFOLD_COMMENTS, "Comments", parent);
        this.addField((FieldEditor)autoFoldComments);
        BooleanFieldEditor autoFoldLicenseHeaders = new BooleanFieldEditor(PREF_AUTOFOLD_LICENSE_HEADERS_COMMENTS, "License Header Comments", parent);
        this.addField((FieldEditor)autoFoldLicenseHeaders);
        BooleanFieldEditor autoFoldRegions = new BooleanFieldEditor(PREF_AUTOFOLD_REGIONS, "Folding Regions", parent);
        this.addField((FieldEditor)autoFoldRegions);
        BooleanFieldEditor autoFoldImports = new BooleanFieldEditor(PREF_AUTOFOLD_IMPORT_STATEMENTS, "Import statements", parent);
        this.addField((FieldEditor)autoFoldImports);
        Runnable updateEditorStates = () -> {
            autoFoldComments.setEnabled(foldingEnabled.getBooleanValue(), parent);
            autoFoldLicenseHeaders.setEnabled(foldingEnabled.getBooleanValue() && !autoFoldComments.getBooleanValue(), parent);
            autoFoldRegions.setEnabled(foldingEnabled.getBooleanValue(), parent);
            autoFoldImports.setEnabled(foldingEnabled.getBooleanValue(), parent);
        };
        foldingEnabled.getDescriptionControl(parent).addListener(13, event -> updateEditorStates.run());
        autoFoldComments.getDescriptionControl(parent).addListener(13, event -> updateEditorStates.run());
        UI.getDisplay().asyncExec(updateEditorStates);
    }

    public void init(IWorkbench workbench) {
    }

    public static final class PreferenceInitializer
    extends AbstractPreferenceInitializer {
        public void initializeDefaultPreferences() {
            IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
            store.setDefault(FoldingPreferencePage.PREF_FOLDING_ENABLED, true);
            store.setDefault(FoldingPreferencePage.PREF_AUTOFOLD_COMMENTS, false);
            store.setDefault(FoldingPreferencePage.PREF_AUTOFOLD_LICENSE_HEADERS_COMMENTS, false);
            store.setDefault(FoldingPreferencePage.PREF_AUTOFOLD_REGIONS, false);
            store.setDefault(FoldingPreferencePage.PREF_AUTOFOLD_IMPORT_STATEMENTS, false);
        }
    }
}

