/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.diagnostics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.IMarkerAttributeComputer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.operations.diagnostics.DiagnosticAnnotation;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class LSPDiagnosticsToMarkers
implements Consumer<PublishDiagnosticsParams> {
    public static final String LSP_DIAGNOSTIC = "lspDiagnostic";
    public static final String LANGUAGE_SERVER_ID = "languageServerId";
    public static final String LS_DIAGNOSTIC_MARKER_TYPE = "org.eclipse.lsp4e.diagnostic";
    private static final IMarkerAttributeComputer DEFAULT_MARKER_ATTRIBUTE_COMPUTER = new IMarkerAttributeComputer(){

        @Override
        public void addMarkerAttributesForDiagnostic(Diagnostic diagnostic, @Nullable IDocument document, IResource resource, Map<String, Object> attributes) {
        }
    };
    private final String languageServerId;
    private final String markerType;
    private final IMarkerAttributeComputer markerAttributeComputer;

    public LSPDiagnosticsToMarkers(String serverId, @Nullable String markerType, @Nullable IMarkerAttributeComputer markerAttributeComputer) {
        this.languageServerId = serverId;
        this.markerType = markerType != null ? markerType : LS_DIAGNOSTIC_MARKER_TYPE;
        this.markerAttributeComputer = markerAttributeComputer == null ? DEFAULT_MARKER_ATTRIBUTE_COMPUTER : markerAttributeComputer;
    }

    public LSPDiagnosticsToMarkers(String serverId) {
        this(serverId, null, null);
    }

    @Override
    public void accept(PublishDiagnosticsParams diagnostics) {
        try {
            String uri = diagnostics.getUri();
            IResource resource = LSPEclipseUtils.findResourceFor(uri);
            if (resource != null && resource.isAccessible()) {
                this.updateMarkers(diagnostics, resource);
            } else {
                for (IEditorReference editorRef : LSPEclipseUtils.findOpenEditorsFor(LSPEclipseUtils.toUri(uri))) {
                    ITextViewer textViewer = LSPEclipseUtils.getTextViewer(editorRef.getEditor(true));
                    if (!(textViewer instanceof ISourceViewer)) continue;
                    ISourceViewer sourceViewer = (ISourceViewer)textViewer;
                    this.updateEditorAnnotations(sourceViewer, diagnostics);
                }
            }
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private void updateEditorAnnotations(ISourceViewer sourceViewer, PublishDiagnosticsParams diagnostics) {
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
            HashSet toRemove = new HashSet();
            annotationModel.getAnnotationIterator().forEachRemaining(annotation -> {
                if (annotation instanceof DiagnosticAnnotation) {
                    toRemove.add(annotation);
                }
            });
            HashMap toAdd = new HashMap(diagnostics.getDiagnostics().size(), 1.0f);
            diagnostics.getDiagnostics().forEach(diagnostic -> {
                try {
                    IDocument doc = sourceViewer.getDocument();
                    if (doc != null) {
                        int startOffset = LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), doc);
                        int endOffset = LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), doc);
                        toAdd.put(new DiagnosticAnnotation((Diagnostic)diagnostic, this.markerAttributeComputer::computeMarkerMessage), new Position(startOffset, endOffset - startOffset));
                    }
                }
                catch (BadLocationException ex) {
                    LanguageServerPlugin.logError(ex);
                }
            });
            annotationModelExtension.replaceAnnotations((Annotation[])toRemove.toArray(Annotation[]::new), toAdd);
        }
    }

    private WorkspaceJob updateMarkers(final PublishDiagnosticsParams diagnostics, final IResource resource) {
        WorkspaceJob job = new WorkspaceJob("Update markers from diagnostics"){

            public boolean belongsTo(@Nullable Object family) {
                return LanguageServerPlugin.FAMILY_UPDATE_MARKERS == family;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(@Nullable IProgressMonitor monitor) throws CoreException {
                if (!resource.isAccessible()) {
                    return Status.OK_STATUS;
                }
                IResource iResource = resource;
                synchronized (iResource) {
                    this.doRun();
                }
                return Status.OK_STATUS;
            }

            private void doRun() throws CoreException {
                HashSet<IMarker> toDeleteMarkers = ArrayUtil.asHashSet(resource.findMarkers(LSPDiagnosticsToMarkers.this.markerType, true, 0));
                toDeleteMarkers.removeIf(marker -> !Objects.equals(marker.getAttribute(LSPDiagnosticsToMarkers.LANGUAGE_SERVER_ID, ""), LSPDiagnosticsToMarkers.this.languageServerId));
                ArrayList<Diagnostic> newDiagnostics = new ArrayList<Diagnostic>();
                HashMap<IMarker, Diagnostic> toUpdate = new HashMap<IMarker, Diagnostic>();
                IDocument existingDocument = LSPEclipseUtils.getExistingDocument(resource);
                boolean hasDiagnostics = !diagnostics.getDiagnostics().isEmpty();
                boolean temporaryLoadDocument = existingDocument == null;
                IDocument document = hasDiagnostics && temporaryLoadDocument ? LSPEclipseUtils.getDocument(resource) : existingDocument;
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    IMarker associatedMarker = LSPDiagnosticsToMarkers.this.getExistingMarkerFor(document, diagnostic, toDeleteMarkers);
                    if (associatedMarker == null) {
                        newDiagnostics.add(diagnostic);
                        continue;
                    }
                    toDeleteMarkers.remove(associatedMarker);
                    toUpdate.put(associatedMarker, diagnostic);
                }
                try {
                    for (Diagnostic diagnostic : newDiagnostics) {
                        if (!resource.exists()) continue;
                        Map<String, Object> markerAttributes = LSPDiagnosticsToMarkers.this.computeMarkerAttributes(document, diagnostic, resource);
                        resource.createMarker(LSPDiagnosticsToMarkers.this.markerType, markerAttributes);
                    }
                    for (Map.Entry entry : toUpdate.entrySet()) {
                        IMarker marker2 = (IMarker)entry.getKey();
                        if (!marker2.exists()) continue;
                        Map<String, Object> markerAttributes = LSPDiagnosticsToMarkers.this.computeMarkerAttributes(document, (Diagnostic)entry.getValue(), resource);
                        LSPDiagnosticsToMarkers.this.updateMarker(markerAttributes, marker2);
                    }
                    toDeleteMarkers.forEach(t -> {
                        try {
                            t.delete();
                        }
                        catch (CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    });
                }
                finally {
                    if (document != null && temporaryLoadDocument) {
                        FileBuffers.getTextFileBufferManager().disconnect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        };
        job.setSystem(true);
        job.setRule(resource.getWorkspace().getRuleFactory().markerRule(resource));
        job.schedule();
        return job;
    }

    protected void updateMarker(Map<String, Object> targetAttributes, IMarker marker) {
        try {
            if (!targetAttributes.equals(marker.getAttributes())) {
                marker.setAttributes(targetAttributes);
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private @Nullable IMarker getExistingMarkerFor(@Nullable IDocument document, Diagnostic diagnostic, Set<IMarker> remainingMarkers) {
        if (document == null) {
            return null;
        }
        String markerMessage = this.markerAttributeComputer.computeMarkerMessage(diagnostic);
        for (IMarker marker : remainingMarkers) {
            if (!marker.exists()) continue;
            try {
                if (LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), document) != MarkerUtilities.getCharStart((IMarker)marker) || LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), document) != MarkerUtilities.getCharEnd((IMarker)marker) && !Objects.equals(diagnostic.getRange().getStart(), diagnostic.getRange().getEnd()) || !Objects.equals(marker.getAttribute("message"), markerMessage) || !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID), this.languageServerId)) continue;
                return marker;
            }
            catch (CoreException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    private Map<String, Object> computeMarkerAttributes(@Nullable IDocument document, Diagnostic diagnostic, IResource resource) {
        String source;
        Either code = diagnostic.getCode();
        if (code != null && code.isLeft()) {
            diagnostic.setCode(Either.forLeft((Object)((String)code.getLeft()).intern()));
        }
        if ((source = diagnostic.getSource()) != null) {
            diagnostic.setSource(source.intern());
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(8);
        attributes.put(LSP_DIAGNOSTIC, diagnostic);
        attributes.put(LANGUAGE_SERVER_ID, this.languageServerId);
        attributes.put("message", this.markerAttributeComputer.computeMarkerMessage(diagnostic));
        attributes.put("severity", LSPEclipseUtils.toEclipseMarkerSeverity(diagnostic.getSeverity()));
        if (document != null) {
            int end;
            int start;
            Range range = diagnostic.getRange();
            int documentLength = document.getLength();
            try {
                start = Math.min(LSPEclipseUtils.toOffset(range.getStart(), document), documentLength);
            }
            catch (BadLocationException ex) {
                start = documentLength;
            }
            try {
                end = Math.min(LSPEclipseUtils.toOffset(range.getEnd(), document), documentLength);
            }
            catch (BadLocationException ex) {
                end = documentLength;
            }
            try {
                int lineOfStartOffset = document.getLineOfOffset(start);
                attributes.put("lineNumber", lineOfStartOffset + 1);
                if (start == end && documentLength > end && document.getLineOfOffset(++end) != lineOfStartOffset) {
                    --start;
                    --end;
                }
            }
            catch (BadLocationException ex) {
                LanguageServerPlugin.logError(ex);
            }
            attributes.put("charStart", start);
            attributes.put("charEnd", end);
        }
        this.markerAttributeComputer.addMarkerAttributesForDiagnostic(diagnostic, document, resource, attributes);
        return attributes;
    }
}

