/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTreeContentProvider;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class NewContentTypeLSPLaunchDialog
extends Dialog {
    protected @Nullable IContentType contentType;
    protected @Nullable ILaunchConfiguration launchConfig;
    protected Set<String> launchMode = Collections.emptySet();

    protected NewContentTypeLSPLaunchDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite res = (Composite)super.createDialogArea(parent);
        res.setLayout((Layout)new GridLayout(2, false));
        new Label(res, 0).setText(Messages.NewContentTypeLSPLaunchDialog_associateContentType);
        new Label(res, 0).setText(Messages.NewContentTypeLSPLaunchDialog_withLSPLaunch);
        FilteredTree contentTypesFilteredTree = new FilteredTree(res, 2048, new PatternFilter(), true, false);
        TreeViewer contentTypesViewer = contentTypesFilteredTree.getViewer();
        contentTypesFilteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        contentTypesViewer.setContentProvider((IContentProvider)new ContentTypesContentProvider());
        contentTypesViewer.setLabelProvider((IBaseLabelProvider)new ContentTypesLabelProvider());
        contentTypesViewer.setComparator(new ViewerComparator());
        contentTypesViewer.setInput((Object)Platform.getContentTypeManager());
        contentTypesViewer.addSelectionChangedListener(event -> {
            IStructuredSelection sel;
            Object object;
            ISelection iSelection = event.getSelection();
            if (iSelection instanceof IStructuredSelection && (object = (sel = (IStructuredSelection)iSelection).getFirstElement()) instanceof IContentType) {
                IContentType newContentType;
                this.contentType = newContentType = (IContentType)object;
            }
            this.updateButtons();
        });
        FilteredTree launchersFilteredTree = new FilteredTree(res, 2048, new PatternFilter(), true, false);
        TreeViewer launchConfigViewer = launchersFilteredTree.getViewer();
        launchersFilteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        launchConfigViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)DebugUITools.newDebugModelPresentation(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        launchConfigViewer.setContentProvider((IContentProvider)new LaunchConfigurationTreeContentProvider(null, this.getShell()));
        launchConfigViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        ComboViewer launchModeViewer = new ComboViewer(res);
        GridData comboGridData = new GridData(131072, -1, true, false, 2, 1);
        comboGridData.widthHint = 100;
        launchModeViewer.getControl().setLayoutData((Object)comboGridData);
        launchModeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        launchModeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object o) {
                StringBuilder res = new StringBuilder();
                for (String s : (Set)o) {
                    res.append(s);
                    res.append(',');
                }
                if (res.length() > 0) {
                    res.deleteCharAt(res.length() - 1);
                }
                return res.toString();
            }
        });
        launchConfigViewer.addSelectionChangedListener(event -> {
            Object object;
            IStructuredSelection sel;
            ILaunchConfiguration newLaunchConfig = null;
            ISelection iSelection = event.getSelection();
            if (iSelection instanceof IStructuredSelection && (sel = (IStructuredSelection)iSelection).size() == 1 && (object = sel.getFirstElement()) instanceof ILaunchConfiguration) {
                ILaunchConfiguration launchConfig;
                newLaunchConfig = launchConfig = (ILaunchConfiguration)object;
            }
            this.launchConfig = newLaunchConfig;
            this.updateLaunchModes(launchModeViewer);
            this.updateButtons();
        });
        launchModeViewer.addSelectionChangedListener(event -> {
            Set<Object> mode;
            IStructuredSelection sel;
            Object object;
            ISelection iSelection = event.getSelection();
            this.launchMode = iSelection instanceof IStructuredSelection && (object = (sel = (IStructuredSelection)iSelection).getFirstElement()) instanceof Set ? (mode = (Set<Object>)object) : Collections.emptySet();
            this.updateButtons();
        });
        return res;
    }

    protected Control createContents(Composite parent) {
        Control res = super.createContents(parent);
        this.updateButtons();
        return res;
    }

    public IContentType getContentType() {
        return NullSafetyHelper.castNonNull(this.contentType);
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return NullSafetyHelper.castNonNull(this.launchConfig);
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(this.contentType != null && this.launchConfig != null && !this.launchMode.isEmpty());
    }

    private void updateLaunchModes(ComboViewer launchModeViewer) {
        ILaunchConfiguration launchConfig = this.launchConfig;
        if (launchConfig == null) {
            launchModeViewer.setInput(Collections.emptyList());
        } else {
            Set<Set<String>> modes = null;
            try {
                modes = launchConfig.getType().getSupportedModeCombinations();
            }
            catch (CoreException e) {
                LanguageServerPlugin.getDefault().getLog().log((IStatus)new Status(4, LanguageServerPlugin.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
            }
            if (modes == null) {
                modes = Collections.singleton(Collections.singleton("run"));
            }
            launchModeViewer.setInput((Object)modes);
            Set<String> currentMode = null;
            if (!launchModeViewer.getStructuredSelection().isEmpty()) {
                currentMode = launchModeViewer.getStructuredSelection().getFirstElement();
            }
            if (currentMode == null || !modes.contains(currentMode)) {
                launchModeViewer.setSelection((ISelection)new StructuredSelection());
                currentMode = null;
            }
            if (currentMode == null) {
                for (Set<String> mode : modes) {
                    if (mode.size() != 1 || !"run".equals(mode.iterator().next())) continue;
                    currentMode = mode;
                    launchModeViewer.setSelection((ISelection)new StructuredSelection(currentMode));
                }
            }
            if (currentMode == null && !modes.isEmpty()) {
                launchModeViewer.setSelection((ISelection)new StructuredSelection(modes.iterator().next()));
            }
        }
        this.updateButtons();
    }

    public Set<String> getLaunchMode() {
        return this.launchMode;
    }

    private static final class ContentTypesContentProvider
    implements ITreeContentProvider {
        private @Nullable IContentTypeManager manager;

        private ContentTypesContentProvider() {
        }

        public Object[] getChildren(@Nullable Object parentElement) {
            IContentTypeManager manager = this.manager;
            if (manager == null) {
                return new Object[0];
            }
            ArrayList<IContentType> elements = new ArrayList<IContentType>();
            IContentType baseType = (IContentType)parentElement;
            IContentType[] contentTypes = manager.getAllContentTypes();
            int i = 0;
            while (i < contentTypes.length) {
                IContentType type = contentTypes[i];
                if (Objects.equals(type.getBaseType(), baseType)) {
                    elements.add(type);
                }
                ++i;
            }
            return elements.toArray();
        }

        public @Nullable Object getParent(Object element) {
            IContentType contentType = (IContentType)element;
            return contentType.getBaseType();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(@Nullable Object inputElement) {
            return this.getChildren(null);
        }

        public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
            this.manager = (IContentTypeManager)newInput;
        }
    }

    private static final class ContentTypesLabelProvider
    extends LabelProvider {
        private ContentTypesLabelProvider() {
        }

        public String getText(Object element) {
            IContentType contentType = (IContentType)element;
            return contentType.getName();
        }
    }
}

