/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.mount.BindOptions;

final class ImmutableBindOptions
implements BindOptions {
    @Nullable
    private final String propagation;

    private ImmutableBindOptions(@Nullable String propagation) {
        this.propagation = propagation;
    }

    @Override
    @JsonProperty(value="Propagation")
    @Nullable
    public String propagation() {
        return this.propagation;
    }

    public final ImmutableBindOptions withPropagation(@Nullable String value) {
        if (Objects.equals(this.propagation, value)) {
            return this;
        }
        return new ImmutableBindOptions(value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBindOptions && this.equalTo(0, (ImmutableBindOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableBindOptions another) {
        return Objects.equals(this.propagation, another.propagation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.propagation);
        return h;
    }

    public String toString() {
        return "BindOptions{propagation=" + this.propagation + "}";
    }

    public static ImmutableBindOptions copyOf(BindOptions instance) {
        if (instance instanceof ImmutableBindOptions) {
            return (ImmutableBindOptions)instance;
        }
        return ImmutableBindOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements BindOptions.Builder {
        private String propagation;

        private Builder() {
        }

        public final Builder from(BindOptions instance) {
            Objects.requireNonNull(instance, "instance");
            String propagationValue = instance.propagation();
            if (propagationValue != null) {
                this.propagation(propagationValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Propagation")
        public final Builder propagation(@Nullable String propagation) {
            this.propagation = propagation;
            return this;
        }

        @Override
        public ImmutableBindOptions build() {
            return new ImmutableBindOptions(this.propagation);
        }
    }
}

