/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Size;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class SizeConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)SizeConstraintTest.webArchiveBuilder().withTestClass(SizeConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-size", id="a")})
    public void testSizeConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        SizeDummyEntity dummy = new SizeDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.collection = new HashSet<String>();
        dummy.collection.add("foo");
        dummy.collection.add("bar");
        dummy.string = "";
        dummy.map = new HashMap<String, String>();
        dummy.map.put("key1", "value1");
        dummy.map.put("key2", "value2");
        dummy.integerArray = new Integer[0];
        dummy.booleanArray = new boolean[0];
        dummy.byteArray = new byte[0];
        dummy.charArray = new char[0];
        dummy.doubleArray = new double[0];
        dummy.floatArray = new float[0];
        dummy.intArray = new int[0];
        dummy.longArray = new long[0];
        dummy.shortArray = new short[0];
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("collection"), ConstraintViolationAssert.violationOf(Size.class).withProperty("map"), ConstraintViolationAssert.violationOf(Size.class).withProperty("string"), ConstraintViolationAssert.violationOf(Size.class).withProperty("integerArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("booleanArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("byteArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("charArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("doubleArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("floatArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("intArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("longArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("shortArray"));
        dummy.collection.remove("bar");
        dummy.string = "a";
        dummy.integerArray = new Integer[1];
        dummy.booleanArray = new boolean[1];
        dummy.byteArray = new byte[1];
        dummy.charArray = new char[1];
        dummy.doubleArray = new double[1];
        dummy.floatArray = new float[1];
        dummy.intArray = new int[1];
        dummy.longArray = new long[1];
        dummy.shortArray = new short[1];
        dummy.map.remove("key1");
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static class SizeDummyEntity {
        @Size(min=1, max=1)
        private @Size(min=1, max=1) String string;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Collection<String> collection;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Map<String, String> map;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Integer[] integerArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) boolean[] booleanArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) byte[] byteArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) char[] charArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) double[] doubleArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) float[] floatArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) int[] intArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) long[] longArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) short[] shortArray;

        private SizeDummyEntity() {
        }
    }
}

