/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;

public abstract class BasePartMenuRenderer<N>
extends BaseRenderer<MMenu, WMenu<N>>
implements EventProcessor.ChildrenHandler<MMenu, MMenuElement> {
    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    protected void initWidget(final MMenu element, WMenu<N> widget) {
        super.initWidget(element, widget);
        widget.setShowingCallback(new Runnable(){

            @Override
            public void run() {
                BasePartMenuRenderer.handleShowing(element);
            }
        });
    }

    static void handleShowing(MMenu element) {
        for (MMenuElement e : element.getChildren()) {
            if (!(e.getRenderer() instanceof BaseItemRenderer)) continue;
            BaseItemRenderer r = (BaseItemRenderer)e.getRenderer();
            r.checkEnablement(e);
        }
    }

    @Override
    public void doProcessContent(MMenu element) {
        WMenu menu = (WMenu)this.getWidget((MUIElement)element);
        if (menu == null) {
            this.getLogger().error("No widget found for '" + element + "'");
            return;
        }
        for (MMenuElement e : element.getChildren()) {
            WMenuElement widget = (WMenuElement)this.engineCreateWidget(e);
            if (widget == null || !e.isVisible()) continue;
            menu.addElement(widget);
        }
    }

    @Override
    public void handleChildrenRemove(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenAddition(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    public void childRendered(MMenu parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WMenu menu = (WMenu)this.getWidget((MUIElement)parentElement);
        if (menu == null) {
            this.getLogger().error("No widget found for '" + element + "'");
            return;
        }
        WMenuElement menuElement = (WMenuElement)element.getWidget();
        if (menuElement != null) {
            menu.addElement(idx, menuElement);
        } else {
            this.getLogger().error("The widget of element '" + element + "' is null");
        }
    }

    public void hideChild(MMenu container, MUIElement changedObj) {
        WMenu menu = (WMenu)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }
}

