/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.internal;

import com.sun.javafx.tk.Toolkit;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.util.Duration;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UISynchronizeImpl
extends UISynchronize
implements org.eclipse.fx.ui.services.sync.UISynchronize {
    @Inject
    @Log
    Logger logger;

    public <V> V syncExec(Callable<V> callable, V defaultValue) {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FutureTask<V> task = new FutureTask<V>(callable);
        Platform.runLater(task);
        try {
            Object v = task.get();
            return v;
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("Unable to wait until the task is completed", (Throwable)e);
        }
        finally {
            task.cancel(true);
        }
        return defaultValue;
    }

    public void syncExec(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(runnable, null);
            Platform.runLater(task);
            try {
                try {
                    task.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.logger.error("Unable to wait until the task is completed", (Throwable)e);
                    task.cancel(true);
                }
            }
            finally {
                task.cancel(true);
            }
        }
    }

    public <V> Future<V> asyncExec(Callable<V> callable) {
        FutureTask<V> task = new FutureTask<V>(callable);
        Platform.runLater(task);
        return task;
    }

    public void asyncExec(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    public Subscription scheduleExecution(long delay, Runnable runnable) {
        final AtomicBoolean b = new AtomicBoolean(true);
        final Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), a -> {
            if (b.get()) {
                runnable.run();
            }
        }, new KeyValue[0])});
        t.play();
        return new Subscription(){

            public void dispose() {
                b.set(false);
                t.stop();
            }
        };
    }

    public <T> CompletableFuture<T> scheduleExecution(long delay, Callable<T> runnable) {
        CompletableFuture future = new CompletableFuture();
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), a -> {
            try {
                if (!future.isCancelled()) {
                    future.complete(runnable.call());
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }, new KeyValue[0])});
        t.play();
        return future;
    }

    public <T> @Nullable T block(final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UISynchronize.BlockCondition<T> blockCondition) {
        final AtomicReference<@Nullable V> rv = new AtomicReference();
        blockCondition.subscribeUnblockedCallback(new Callback<T>(){

            public void call(@Nullable T value) {
                rv.set(value);
                Toolkit.getToolkit().exitNestedEventLoop((Object)blockCondition, null);
            }
        });
        Toolkit.getToolkit().enterNestedEventLoop(blockCondition);
        return (T)rv.get();
    }
}

