/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards.update;

import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternUpdateSpecification;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.PatternUpdateComparisonViewer;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractModifiableTemplateElementsPage;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ValuesViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternUpdateElementsPage
extends AbstractModifiableTemplateElementsPage<TemplatePatternUpdateSpecification> {
    protected FeaturesViewer _detailsViewer;
    protected ValuesViewer _referenceViewer;
    protected ValuesViewer _targetViewer;
    EMFDiffNode _diffNode;
    EMatch _selectedMatch;
    protected EditingDomain _editingDomain;
    protected IStructuredSelection _selection;
    SashForm _sash;

    public PatternUpdateElementsPage(TemplatePatternUpdateSpecification updateData_p) {
        super(Messages.PatternUpdateElementsPage_Name, updateData_p);
        EObject obj = updateData_p.getScopeElement();
        if (obj != null) {
            this._editingDomain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(obj);
            this._diffNode = new EMFDiffNode((EComparison)updateData_p.getVisualizationComparison(), this._editingDomain);
        }
    }

    @Override
    protected ModelSubsetViewer createModelViewer(Composite parent_p) {
        final PatternUpdateComparisonViewer resultViewer = new PatternUpdateComparisonViewer(parent_p, this._editingDomain, true, false){

            protected int getControlWidgetConfiguration() {
                int result = ModelSubsetViewer.SORT | ModelSubsetViewer.EXPAND | ModelSubsetViewer.COLLAPSE;
                if (PatternUpdateElementsPage.this.showParentsCheckbox()) {
                    result |= ModelSubsetViewer.SHOW_PARENTS;
                }
                return result;
            }
        };
        resultViewer.setInput(this.getData());
        ((TemplatePatternUpdateSpecification)this.getData()).addTemplateElementsChangedListener(new AbstractModifiableTemplatePatternSpecification.ITemplateElementsChangedListener(){

            public void templateElementsChanged() {
                resultViewer.setInput(PatternUpdateElementsPage.this.getData());
                PatternUpdateElementsPage.this.validate();
            }
        });
        return resultViewer;
    }

    @Override
    protected Group createTemplateElementsGroup(Composite parent_p) {
        final Group result = this.createGroup(parent_p, this.getElementsGroupName(), true, 1);
        ((TemplatePatternUpdateSpecification)this.getData()).addTemplateElementsChangedListener(new AbstractModifiableTemplatePatternSpecification.ITemplateElementsChangedListener(){

            public void templateElementsChanged() {
                result.setText(PatternUpdateElementsPage.this.getElementsGroupName());
            }
        });
        return result;
    }

    @Override
    protected String getElementsGroupName() {
        StringBuilder result = new StringBuilder();
        int nbDiffs = ((TemplatePatternUpdateSpecification)this.getData()).getVisualizationComparison().getRemainingDifferences().size();
        result.append(super.getElementsGroupName());
        result.append(' ');
        result.append('(');
        result.append(nbDiffs);
        result.append(' ');
        if (nbDiffs == 1) {
            result.append(Messages.PatternUpdateElementsPage_SingleDiff);
        } else {
            result.append(Messages.PatternUpdateElementsPage_ManyDiffs);
        }
        result.append(')');
        return result.toString();
    }

    @Override
    protected Composite createSpecificControls() {
        Composite additionalElementComposite = new Composite((Composite)this._sash, 4);
        additionalElementComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        additionalElementComposite.setLayout((Layout)layout);
        this.createDetailsGroup(additionalElementComposite);
        this._sash.setWeights(new int[]{5, 3});
        return additionalElementComposite;
    }

    private void createButtonsGroup(Composite parent_p) {
        Composite buttonsComposite = new Composite(parent_p, 0);
        buttonsComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        buttonsComposite.setLayout((Layout)layout2);
        this.createIncludeAllDependenciesButton(buttonsComposite);
        this.createIncludeAllInstancesButton(buttonsComposite);
    }

    @Override
    public void createControl(Composite parent_p) {
        Composite mainComposite = new Composite(parent_p, 4);
        this.setControl((Control)mainComposite);
        GridLayout mainCompositeLayout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)mainCompositeLayout);
        this.setDefaultMessage();
        this._templateElementsViewer = this.createTemplateElementControls(mainComposite);
        this.createSpecificControls();
        this.createButtonsGroup(this._sash.getParent());
        this.createRoleControls(mainComposite, this.allowEdition());
    }

    @Override
    protected ModelSubsetViewer createTemplateElementControls(Composite parent_p) {
        Group contentsGroup = this.createTemplateElementsGroup(parent_p);
        this._sash = new SashForm((Composite)contentsGroup, 66048);
        this._sash.setLayout((Layout)new FillLayout());
        this._sash.setLayoutData((Object)new GridData(1808));
        ModelSubsetViewer result = this.createModelViewer((Composite)this._sash);
        Menu menu = new Menu((Control)result.getTreeViewer().getTree());
        this.createNavigationControls(menu, result);
        if (this.allowEdition()) {
            this.createMappingControls(menu, result);
        }
        this.createIsUniqueItem(menu, result);
        if (this.allowEdition()) {
            this.createScopeModificationControls(menu, result);
        }
        result.getTreeViewer().getTree().setMenu(menu);
        return result;
    }

    private void createDetailsGroup(Composite parent_p) {
        Group detailsGroup = new Group(parent_p, 4);
        detailsGroup.setText(Messages.InstanceConformityDialog_DetailsGroup);
        detailsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        detailsGroup.setLayout((Layout)new GridLayout(3, false));
        this.createCompositeArea((Composite)detailsGroup, Messages.InstanceConformityDialog_DetailsDifferenceGroup, 0);
        this.createCompositeArea((Composite)detailsGroup, Messages.InstanceConformityDialog_DetailsLeftGroup, 1);
        this.createCompositeArea((Composite)detailsGroup, Messages.InstanceConformityDialog_DetailsRightGroup, 2);
        this.createSynchronizationListener();
    }

    private Composite createCompositeArea(Composite parent_p, String message_p, int role_p) {
        Composite composite = this.createEmptyComposite(parent_p, 1);
        Label label = new Label(composite, 4);
        label.setText(message_p);
        if (role_p == 1) {
            this._targetViewer = new ValuesViewer(composite, true);
        } else if (role_p == 2) {
            this._referenceViewer = new ValuesViewer(composite, false);
        } else if (role_p == 0) {
            this.createDetailsFeatureViewer(composite);
        }
        return composite;
    }

    private void createDetailsFeatureViewer(Composite parent_p) {
        this._detailsViewer = new FeaturesViewer(parent_p);
        this._detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                Object obj;
                PatternUpdateElementsPage.this._targetViewer.setInput(null);
                PatternUpdateElementsPage.this._referenceViewer.setInput(null);
                ISelection detailSelection = PatternUpdateElementsPage.this._detailsViewer.getSelection();
                if (detailSelection != null && detailSelection instanceof StructuredSelection && !((StructuredSelection)detailSelection).isEmpty() && (obj = ((StructuredSelection)detailSelection).getFirstElement()) instanceof EStructuralFeature) {
                    MatchAndFeatureImpl maf = new MatchAndFeatureImpl(PatternUpdateElementsPage.this._selectedMatch, (EStructuralFeature)obj);
                    ValuesViewer.ValuesInput targetInput = new ValuesViewer.ValuesInput(PatternUpdateElementsPage.this._diffNode, (MatchAndFeature)maf);
                    PatternUpdateElementsPage.this._targetViewer.setInput((Object)targetInput);
                    ValuesViewer.ValuesInput referenceInput = new ValuesViewer.ValuesInput(PatternUpdateElementsPage.this._diffNode, (MatchAndFeature)maf);
                    PatternUpdateElementsPage.this._referenceViewer.setInput((Object)referenceInput);
                }
            }
        });
    }

    protected void createSynchronizationListener() {
        this._templateElementsViewer.getTreeViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IMatch match;
                PatternUpdateElementsPage.this._detailsViewer.setInput(null);
                PatternUpdateElementsPage.this._selection = PatternUpdateElementsPage.this._templateElementsViewer.getSelection();
                Object obj = PatternUpdateElementsPage.this._selection.getFirstElement();
                if (obj != null && obj instanceof EObject && (match = ((TemplatePatternUpdateSpecification)PatternUpdateElementsPage.this.getData()).getVisualizationComparison().getMapping().getMatchFor((EObject)obj, Role.TARGET)) instanceof EMatch) {
                    PatternUpdateElementsPage.this._selectedMatch = (EMatch)match;
                    FeaturesViewer.FeaturesInput input = new FeaturesViewer.FeaturesInput(PatternUpdateElementsPage.this._diffNode, (IMatch)PatternUpdateElementsPage.this._selectedMatch);
                    PatternUpdateElementsPage.this._detailsViewer.setInput((Object)input);
                    if (PatternUpdateElementsPage.this._detailsViewer.getElementAt(0) != null) {
                        PatternUpdateElementsPage.this._detailsViewer.setSelection((ISelection)new StructuredSelection(PatternUpdateElementsPage.this._detailsViewer.getElementAt(0)));
                    }
                }
            }
        });
    }

    protected Composite createEmptyComposite(Composite parent_p, int columns_p) {
        Composite result = new Composite(parent_p, 2048);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(columns_p, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        return result;
    }
}

